<?php
session_start();
require 'auth21.php';
if (empty($_SESSION['user_code'])) {
    header("Location: login");
    exit;
}
$user = getUser($pdo);
if($user['account_status'] == "NOTSIGNEDUP"){
    header("Location: registration");
    exit;
}
?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>تنظیمات حساب - حساب کاربری | Vuexy - قالب مدیریت بوت استرپ</title>
    <meta content="" name="description"/>
    <!-- Favicon -->
    <link href="../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <!-- Icons -->
    <link href="../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <!-- Core CSS -->
    <link href="../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../assets/css/demo.css" rel="stylesheet"/>
    <!-- Vendors CSS -->
    <link href="../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/animate-css/animate.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/sweetalert2/sweetalert2.css" rel="stylesheet"/>
    <!-- Page CSS -->
    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>

    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../../assets/js/config.js"></script>
    <!-- Better experience of RTL -->
    <link href="../../assets/css/rtl.css" rel="stylesheet"/>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->
        <?php require_once 'sidebar.php';?>
        <!-- / Menu -->
        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            <?php require_once 'navbar.php';?>
            <!-- / Navbar -->
            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->
                <div class="container-xxl flex-grow-1 container-p-y">
                    <h4 class="py-3 mb-4">
                        <span class="text-muted fw-light">تنظیمات حساب /</span>
                        حساب کاربری
                    </h4>
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="nav nav-pills flex-column flex-md-row mb-4">
                                <li class="nav-item">
                                    <a class="nav-link active" href="javascript:void(0);">
                                        <i class="ti-xs ti ti-users me-1"></i>
                                        حساب کاربری
                                    </a>
                                </li>
                            </ul>
                            <div class="card mb-4">
                                <h5 class="card-header">جزئیات پروفایل</h5>
                                <!-- Account -->
                                <hr class="my-0"/>
                                <div class="card-body">
                                    <div id="alert-container"></div>
                                    <form id="formAccountSettings">
                                        <div class="row">
                                            <div class="mb-3 col-md-6">
                                                <label class="form-label" for="firstName">نام</label>
                                                <?php

                                                ?>
                                                <input autofocus class="form-control" id="firstName" name="firstName" type="text" value="<?=$user['firstname'];?>"/>
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <label class="form-label" for="lastName">نام خانوادگی</label>
                                                <input class="form-control" id="lastName" name="lastName" type="text" value="<?=$user['lastname'];?>"/>
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <label class="form-label" for="email">ایمیل</label>
                                                <input class="form-control" id="email" name="email" placeholder="john.doe@example.com" type="text" value="<?=$user['email'];?>"/>
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <label class="form-label" for="nationalID">کد ملی</label>
                                                <input class="form-control" id="nationalID" name="nationalID" type="text" value="<?=$user['nationalID'];?>"/>
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <label class="form-label" for="phoneNumber">شماره موبایل</label>
                                                <div class="input-group input-group-merge">
                                                    <input class="form-control ltr" id="phoneNumber" name="phoneNumber" placeholder="09123456789" type="text" value="<?=$user['phone'];?>"/>
                                                </div>
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <label class="form-label" for="province">استان</label>
                                                <input class="form-control" id="province" name="province" placeholder="تهران" type="text" value="<?=$user['province'];?>"/>
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <label class="form-label" for="city">َشهر</label>
                                                <input class="form-control" id="city" name="city" placeholder="تهران" type="text" value="<?=$user['province'];?>"/>
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <label class="form-label" for="address">آدرس</label>
                                                <input class="form-control" id="address" name="address" placeholder="خ ملاصدرا ..." type="text" value="<?=$user['address'];?>"/>
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <label class="form-label" for="zipCode">کد پستی</label>
                                                <?php
                                                echo $user['zipcode'];
                                                ?>
                                                <input class="form-control" id="zipCode" maxlength="10" name="zipCode" placeholder="123456789" value="<?=$user['zipcode'];?>" type="text"/>
                                            </div>
                                        </div>
                                        <div class="mt-2">
                                            <button id="submitForm" class="btn btn-primary me-2" type="button">ذخیره تغییرات</button>
                                            <button class="btn btn-label-secondary" type="reset">لغو</button>
                                        </div>
                                    </form>
                                </div>
                                <!-- /Account -->
                                <div id="cardSubmitting" style="background-color: black;opacity: 70%;width: 100%;height: 100%;position: absolute;display: none;justify-content: center;align-items: center;">
                                    <h2 class="text-white">در حال ثبت تغییرات...</h2>
                                </div>
                            </div>
                            <div class="card">
                                <h5 class="card-header">حذف حساب کاربری</h5>
                                <div class="card-body">
                                    <div class="mb-3 col-12 mb-0">
                                        <div class="alert alert-warning">
                                            <h5 class="alert-heading mb-1">آیا مطمئن هستید که می خواهید اکانت خود را حذف کنید؟</h5>
                                            <p class="mb-0">هنگامی که حساب خود را حذف می کنید، دیگر راه برگشتی وجود ندارد. لطفا مطمئن باشید</p>
                                        </div>
                                    </div>
                                    <form id="formAccountDeactivation" onsubmit="return false">
                                        <div class="form-check mb-4">
                                            <input class="form-check-input" id="accountActivation" name="accountActivation" type="checkbox"/>
                                            <label class="form-check-label" for="accountActivation">من حذف حساب خود را تأیید می کنم</label>
                                        </div>
                                        <button class="btn btn-danger deactivate-account" type="submit">حذف حساب کاربری</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script>
                        function showAlert(message, type = 'success') {
                            const container = document.getElementById('alert-container');

                            // Create alert div
                            const alertEl = document.createElement('div');
                            alertEl.className = `alert alert-${type} alert-dismissible fade show mt-3`;
                            alertEl.role = 'alert';
                            alertEl.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    `;

                            // Append and auto-remove after 5 seconds
                            container.innerHTML = ''; // remove previous alert if you want only one
                            container.appendChild(alertEl);

                            setTimeout(() => {
                                const bsAlert = bootstrap.Alert.getOrCreateInstance(alertEl);
                                bsAlert.close();
                            }, 5000);
                        }
                        document.getElementById("submitForm").addEventListener("click", function () {
                            const form = document.getElementById('formAccountSettings'); // The form's ID
                            const formData = new FormData(form);
                            formData.append('action', 'save_profile');
                            // Show overlay
                            document.getElementById("cardSubmitting").style.display = "flex";

                            fetch("functions/account_funcs.php", {
                                method: "POST",
                                body: formData
                            })
                                .then(res => res.json())
                                .then(data => {
                                    // Hide overlay
                                    document.getElementById("cardSubmitting").style.display = "none";

                                    if (data.success) {
                                        showAlert(data.message || "تغییرات با موفقیت ذخیره شد.", "success");
                                    } else {
                                        showAlert(data.error || "خطایی رخ داده است.", "danger");
                                    }
                                })
                                .catch(err => {
                                    document.getElementById("cardSubmitting").style.display = "none";
                                    showAlert("خطا در ارتباط با سرور", "danger");
                                });
                        });
                    </script>
                </div>
                <!-- / Content -->
                <!-- Footer -->
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl">
                        <div class="footer-container d-flex align-items-center justify-content-between py-2 flex-md-row flex-column">
                            <div> ©
                                <script>
                                    document.write(new Date().getFullYear());

                                </script>
                                , ارائه شده توسط
                                <span class="text-danger byte-hover">بایت ‌مَستر</span>
                                در سایت
                                <a class="fw-medium" href="#support" target="_blank">راستچین</a>
                            </div>
                            <div class="d-none d-lg-inline-block">
                                <a class="footer-link me-4" href="#support" target="_blank">لایسنس</a>
                                <a class="footer-link me-4" href="#support" target="_blank">قالب‌های بیشتر</a>
                                <a class="footer-link me-4" href="https://demos.pixinvent.com/vuexy-html-admin-template/documentation/" target="_blank">مستندات</a>
                                <a class="footer-link d-none d-sm-inline-block" href="#support-theme" target="_blank">پشتیبانی</a>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- / Footer -->
                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>
    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    <!-- Drag Target Area To SlideIn Menu On Small Screens -->
    <div class="drag-target"></div>
</div>
<!-- / Layout wrapper -->
<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="../../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>
<!-- endbuild -->
<!-- Vendors JS -->
<script src="../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../assets/vendor/libs/select2/i18n/fa.js"></script>
<script src="../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../assets/vendor/libs/@form-validation/auto-focus.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave.js"></script>
<script src="../../assets/vendor/libs/cleavejs/cleave-phone.js"></script>
<script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
<!-- Main JS -->
<script src="../../assets/js/main.js"></script>
<!-- Page JS -->
<script src="../../assets/js/pages-account-settings-account.js"></script>
</body>

</html>
