<?php
session_start();
require 'auth21.php';
if (empty($_SESSION['user_code'])) {
    header("Location: login");
    exit;
}
$user = getUser($pdo);
if($user['account_status'] == "NOTSIGNEDUP"){
    header("Location: registration");
    exit;
}
$patientCode = $_GET['pcode'] ?? '';
$officeCode  = $_SESSION['user_code'] ?? null;

/* ==================== FETCH DROPDOWN LISTS ==================== */
$patientsList = [];
$stmt = $pdo->prepare("SELECT patient_code, patient_fullname_encrypted, patient_phone_encrypted,patient_nationalid_encrypted,iv,salt,enc_code
                       FROM patients 
                       WHERE office_code = ? AND status='ACTIVE'");
$stmt->execute([$officeCode]);
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $patient_encrypted = [
            'patient_fullname_encrypted' => decryptData($row['patient_fullname_encrypted']),
            'patient_nationalid_encrypted'  => decryptData($row['patient_nationalid_encrypted']),
            'patient_phone_encrypted'=> decryptData($row['patient_phone_encrypted'])
    ];
    $iv = $row['iv'];
    $salt = $row['salt'];
    $enc_code = $row['enc_code'];
    $tmp_patient = get_decrypted_data($patient_encrypted,$iv,$salt,$enc_code);
    $patientsList[] = [
        'code'  => $row['patient_code'],
        'name'  => $tmp_patient['patient_fullname_encrypted'],
        'phone' => $tmp_patient['patient_phone_encrypted'],
        'nationalid' => $tmp_patient['patient_nationalid_encrypted']
    ];
}

$dentistsList = [];
$stmt = $pdo->prepare("SELECT dentist_code, dentist_fullname_encrypted,iv,salt,enc_code
                       FROM dentists 
                       WHERE office_code = ? AND status='ACTIVE'");
$stmt->execute([$officeCode]);
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $dentist_encrypted = [
            'dentist_fullname_encrypted' => decryptData($row['dentist_fullname_encrypted'])
    ];
    $iv = $row['iv'];
    $salt = $row['salt'];
    $enc_code = $row['enc_code'];
    $tmp_dentist = get_decrypted_data($dentist_encrypted,$iv,$salt,$enc_code);
    $dentistsList[] = [
        'code' => $row['dentist_code'],
        'name' => $tmp_dentist['dentist_fullname_encrypted']
    ];
}

$unitsList = [];
$stmt = $pdo->prepare("SELECT unit_code, unit_name 
                       FROM dental_chairs 
                       WHERE office_code = ?");
$stmt->execute([$officeCode]);
$unitsList = $stmt->fetchAll(PDO::FETCH_ASSOC);

$servicesList = [];
$stmt = $pdo->prepare("
        SELECT service_code, service_title, service_category_code
        FROM services
        WHERE status = 'ACTIVE' AND COALESCE(hide_default_for, '') NOT LIKE :pattern
          AND (office_code = :office_code OR office_code = 'DEFAULT')
    ");
$stmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
$servicesList = $stmt->fetchAll(PDO::FETCH_ASSOC);

$servicesCategoryList = [];
$stmt =  $pdo->prepare("
        SELECT service_category_code, category_title
        FROM service_categories
        WHERE (office_code = :office_code OR office_code = 'DEFAULT')
          AND status = 'ACTIVE' AND COALESCE(hide_default_for, '') NOT LIKE :pattern
    ");
$stmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
$servicesCategoryList = $stmt->fetchAll(PDO::FETCH_ASSOC);
/* ============================================================== */

if(isset($_GET['pcode'])){
    $stmt = $pdo->prepare("
    SELECT *
    FROM patients
    WHERE patient_code = :code
      AND office_code = :office_code
      AND status != 'DELETED'
");
    $stmt->execute([':code' => $patientCode, ':office_code' => $officeCode]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    $dec = fn($v) => $v ? decryptData($v) : '';

    $firstname      = $dec($row['patient_firstname_encrypted'] ?? null);
    $lastname       = $dec($row['patient_lastname_encrypted'] ?? null);
    $phone          = $dec($row['patient_phone_encrypted'] ?? null);
    $gender         = $dec($row['gender_encrypted'] ?? null);
    $nationalid     = $dec($row['patient_nationalid_encrypted'] ?? null);
    $firstname_en   = $dec($row['firstname_en_encrypted'] ?? null);
    $lastname_en    = $dec($row['lastname_en_encrypted'] ?? null);
    $home_number    = $dec($row['home_number_encrypted'] ?? null);
    $father_name    = $dec($row['father_name_encrypted'] ?? null);
    $emergency_contact        = $dec($row['emergency_contact_encrypted'] ?? null);
    $emergency_contact_name   = $dec($row['emergency_contact_name_encrypted'] ?? null);
    $emergency_contact_relation = $dec($row['emergency_contact_relation_encrypted'] ?? null);
    $education      = $dec($row['education_encrypted'] ?? null);
    $occupation     = $dec($row['occupation_encrypted'] ?? null);
    $birthdate      = $dec($row['birthdate_encrypted'] ?? null);
    $address        = $dec($row['address_encrypted'] ?? null);
    $bloodtype      = $dec($row['bloodtype_encrypted'] ?? null);
    $pregnancy      = $dec($row['pregnancy_encrypted'] ?? null);
    $marital_status = $dec($row['marital_status_encrypted'] ?? null);
    $patient_medical_histories_json = $dec($row['medical_histories_encrypted'] ?? null);
    $patient_medical_histories_array = json_decode($patient_medical_histories_json);
    if(!is_array($patient_medical_histories_array)){
        $patient_medical_histories_array = json_decode(json_decode($patient_medical_histories_json));
    }
    $mhStmt = $pdo->prepare("
    SELECT
        id,
        history_code,
        title_encrypted,
        history_type,
        description_encrypted,
        alert_flag
    FROM medical_histories
    WHERE (office_code = :office_code OR office_code = 'DEFAULT')
      AND status != 'DELETED' AND hide_default_for NOT LIKE :pattern
");
    $mhStmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
    $medical_histories = $mhStmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($medical_histories as &$mh) {
        $mh['title'] = decryptData($mh['title_encrypted']);
    }
    unset($mh);
}
?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>تقویم شمسی | Vuexy - قالب مدیریت بوت استرپ</title>
    <meta content="" name="description"/>
    <!-- Favicon -->
    <link href="../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <!-- Icons -->
    <link href="../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <!-- Core CSS -->
    <link href="../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../assets/css/demo.css" rel="stylesheet"/>
    <!-- Vendors CSS -->
    <link href="../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../assets/libs/fullcalendar/fullcalendar.css" rel="stylesheet"/>
    <link href="../../assets/libs/flatpickr/flatpickr.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/quill/editor.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <link rel="stylesheet" href="../../assets/vendor/libs/sweetalert2/sweetalert2.css" />

    <!-- Page CSS -->
    <link href="../../assets/vendor/css/pages/app-calendar.css" rel="stylesheet"/>
    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>

    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../../assets/js/config.js"></script>
    <!-- Better experience of RTL -->
    <link href="../../assets/css/rtl.css" rel="stylesheet"/>

<!--    <script src="https://cdn.jsdelivr.net/npm/jalaali-js/dist/jalaali.min.js"></script>-->
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->
        <?php require_once 'sidebar.php';?>
        <!-- / Menu -->
        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            <?php require_once 'navbar.php';?>
            <!-- / Navbar -->
            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->
                <div class="container-xxl flex-grow-1 container-p-y">
                    <div class="card app-calendar-wrapper">
                        <div class="row g-0">
                            <!-- Calendar Sidebar -->
                            <div class="col app-calendar-sidebar" id="app-calendar-sidebar">
                                <div class="border-bottom p-4 my-sm-0 mb-3">
                                    <div class="d-grid">
                                        <button aria-controls="addEventSidebar" class="btn btn-primary btn-toggle-sidebar" data-bs-target="#addEventSidebar" data-bs-toggle="offcanvas">
                                            <i class="ti ti-plus me-1"></i>
                                            <span class="align-middle">افزودن نوبت</span>
                                        </button>
                                    </div>
                                </div>
                                <div class="p-3">
                                    <!-- inline calendar (flatpicker) -->
                                    <div class="inline-calendar"></div>
                                    <hr class="container-m-nx mb-4 mt-3"/>
                                    <!-- Filter -->
                                    <div class="mb-3 ms-3">
                                        <small class="text-small text-muted text-uppercase align-middle">فیلتر کنید</small>
                                    </div>
                                    <div class="form-check mb-2 ms-3">
                                        <input checked class="form-check-input select-all" data-value="all" id="selectAll" type="checkbox"/>
                                        <label class="form-check-label" for="selectAll">مشاهده همه</label>
                                    </div>
                                    <div class="app-calendar-events-filter ms-3">
                                        <div class="form-check form-check-danger mb-2">
                                            <input checked class="form-check-input input-filter" data-value="personal" id="select-personal" type="checkbox"/>
                                            <label class="form-check-label" for="select-personal">شخصی</label>
                                        </div>
                                        <div class="form-check mb-2">
                                            <input checked class="form-check-input input-filter" data-value="business" id="select-business" type="checkbox"/>
                                            <label class="form-check-label" for="select-business">کسب و کار</label>
                                        </div>
                                        <div class="form-check form-check-warning mb-2">
                                            <input checked class="form-check-input input-filter" data-value="family" id="select-family" type="checkbox"/>
                                            <label class="form-check-label" for="select-family">خانواده</label>
                                        </div>
                                        <div class="form-check form-check-success mb-2">
                                            <input checked class="form-check-input input-filter" data-value="holiday" id="select-holiday" type="checkbox"/>
                                            <label class="form-check-label" for="select-holiday">تعطیلات</label>
                                        </div>
                                        <div class="form-check form-check-info">
                                            <input checked class="form-check-input input-filter" data-value="etc" id="select-etc" type="checkbox"/>
                                            <label class="form-check-label" for="select-etc">سایر موارد</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /Calendar Sidebar -->
                            <!-- Calendar & Modal -->
                            <div class="col app-calendar-content">
                                <div class="card shadow-none border-0">
                                    <div class="card-body pb-0">
                                        <!-- FullCalendar -->
                                        <div id="calendar"></div>
                                    </div>
                                </div>
                                <div class="app-overlay"></div>
                                <!-- FullCalendar Offcanvas -->
                                <!-- FullCalendar Offcanvas -->
                                <div aria-labelledby="addEventSidebarLabel" class="offcanvas offcanvas-end event-sidebar" id="addEventSidebar" tabindex="-1">
                                    <div class="offcanvas-header my-1">
                                        <h5 class="offcanvas-title" id="addEventSidebarLabel">افزودن نوبت</h5>
                                        <button aria-label="بستن" class="btn-close text-reset" data-bs-dismiss="offcanvas" type="button"></button>
                                    </div>
                                    <div class="offcanvas-body pt-0">
                                        <form class="event-form pt-0" id="addAppointmentForm" onsubmit="return false">

                                            <div class="mb-3">
                                                <label class="form-label" for="patient_select">انتخاب بیمار</label>
                                                <select class="form-select" id="patient_select" name="patient_select">
                                                    <option value="">-- انتخاب از لیست --</option>
                                                    <?php
                                                    $stmt = $pdo->prepare("
            SELECT patient_code, patient_fullname_encrypted,patient_phone_encrypted,patient_nationalid_encrypted,iv,salt,enc_code
            FROM patients
            WHERE office_code = ? AND status='ACTIVE'
        ");
                                                    $stmt->execute([$_SESSION['user_code']]);
                                                    foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $pat) {
                                                        $patient_encrypted = [
                                                                'patient_phone_encrypted'       => decryptData($pat['patient_phone_encrypted']),
                                                                'patient_nationalid_encrypted'       => decryptData($pat['patient_nationalid_encrypted']),
                                                                'patient_fullname_encrypted'       => decryptData($pat['patient_fullname_encrypted'])
                                                        ];
                                                        $iv = $pat['iv'];
                                                        $salt = $pat['salt'];
                                                        $enc_code = $pat['enc_code'];
                                                        $tmp_patient = get_decrypted_data($patient_encrypted,$iv,$salt,$enc_code);
                                                        echo '<option data-phone="' . htmlspecialchars($tmp_patient['patient_phone_encrypted']) . '" data-nationalid="' . htmlspecialchars($tmp_patient['patient_nationalid_encrypted']) . '" value="'.htmlspecialchars($pat['patient_code']).'" >' .
                                                            htmlspecialchars($tmp_patient['patient_fullname_encrypted']) .
                                                            '</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label" for="patient_name">نام و نام خانوادگی بیمار</label>
                                                <input type="text" class="form-control" id="patient_name" name="patient_name" placeholder="احمد مومنی">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label" for="patient_nationalid">کد ملی بیمار</label>
                                                <input type="text" class="form-control" id="patient_nationalid" name="patient_nationalid" placeholder="0045214766">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label" for="patient_phone">شماره تماس بیمار</label>
                                                <input type="text" class="form-control" id="patient_phone" name="patient_phone" placeholder="09123456789">
                                            </div>
                                            <!-- Start Date -->
                                            <div class="mb-3">
                                                <label class="form-label" for="eventStartDate">تاریخ نوبت</label>
                                                <input class="form-control" id="eventStartDate" name="eventStartDate" placeholder="تاریخ نوبت" type="text"/>
                                            </div>
                                            <!-- Appointment Time -->
                                            <div class="mb-3">
                                                <label class="form-label" for="eventStartTime">ساعت نوبت</label>
                                                <input class="form-control" id="eventStartTime" name="eventStartTime" placeholder="14:30" type="text"/>
                                            </div>
                                            <!-- End Date -->
                                            <div class="mb-3">
                                                <label class="form-label" for="eventLength">مدت نوبت (دقیقه)</label>
                                                <input class="form-control" id="eventLength" name="eventLength" placeholder="30" value="30" type="text"/>
                                            </div>
                                            <!-- Service Select -->

                                            <div class="mb-3">
                                                <label class="form-label" for="service_category_select">دسته‌بندی درمان</label>
                                                <select class="select2 select-event-label form-select" id="service_category_select" name="service_category_code">
                                                    <?php foreach ($servicesCategoryList as $s): ?>
                                                        <option value="<?= htmlspecialchars($s['service_category_code']) ?>"><?= htmlspecialchars($s['category_title']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label" for="service_select">درمان</label>
                                                <select class="select2 select-event-label form-select" id="service_select" name="service_code">
                                                    <?php foreach ($servicesList as $s): ?>
                                                        <option value="<?= htmlspecialchars($s['service_code']) ?>"><?= htmlspecialchars($s['service_title']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>

                                            <!-- Dentist Select -->
                                            <div class="mb-3 select2-primary">
                                                <label class="form-label" for="dentist_select">دندانپزشک</label>
                                                <select class="select2 select-event-guests form-select" id="dentist_select" name="dentist_code">
                                                    <?php foreach ($dentistsList as $d): ?>
                                                        <option value="<?= htmlspecialchars($d['code']) ?>"><?= htmlspecialchars($d['name']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>

                                            <!-- Unit Select -->
                                            <div class="mb-3">
                                                <label class="form-label" for="unit_select">یونیت</label>
                                                <select class="form-select" id="unit_select" name="unit_code">
                                                    <?php foreach ($unitsList as $u): ?>
                                                        <option value="<?= htmlspecialchars($u['unit_code']) ?>"><?= htmlspecialchars($u['unit_name']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>

                                            <!-- Description -->
                                            <div class="mb-3">
                                                <label class="form-label" for="eventDescription">شرح</label>
                                                <textarea class="form-control" id="eventDescription" name="eventDescription"></textarea>
                                            </div>

                                            <!-- Form Actions -->
                                            <div class="mb-3 d-flex justify-content-sm-between justify-content-start my-4">
                                                <div>
                                                    <button class="btn btn-label-secondary btn-cancel me-sm-0 me-1" data-bs-dismiss="offcanvas" type="reset"> لغو</button>
                                                    <button class="btn btn-primary btn-add-event me-sm-3 me-1" type="submit">افزودن</button>
                                                </div>
                                            </div>
                                        </form>
                                        <div>
                                            <button class="btn btn-label-danger btn-delete-event d-none" onclick="deleteAppointment()">حذف</button>
                                        </div>
                                    </div>
                                </div>
                                <!-- /FullCalendar Offcanvas -->

                                <script>
                                    // Auto-fill phone number when selecting patient
                                    document.getElementById('patient_select').addEventListener('change', function() {
                                        if (this.selectedIndex === 0){
                                            document.getElementById('patient_phone').value = '';
                                            document.getElementById('patient_nationalid').value ='';
                                            document.getElementById('patient_name').value = '';

                                        }
                                        else {
                                            const phone = this.options[this.selectedIndex].getAttribute('data-phone');
                                            document.getElementById('patient_phone').value = phone || '';
                                            const nationalid = this.options[this.selectedIndex].getAttribute('data-nationalid');
                                            document.getElementById('patient_nationalid').value = nationalid || '';
                                            const p_name = this.options[this.selectedIndex].innerHTML;
                                            document.getElementById('patient_name').value = p_name || '';
                                        }
                                    });
                                </script>
                            </div>
                            <!-- /Calendar & Modal -->
                        </div>
                    </div>
                </div>
                <!-- / Content -->
                <!-- Footer -->
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl">
                        <div class="footer-container d-flex align-items-center justify-content-between py-2 flex-md-row flex-column">
                            <div> ©
                                <script>
                                    document.write(new Date().getFullYear());

                                </script>
                                , ارائه شده توسط
                                <span class="text-danger byte-hover">بایت ‌مَستر</span>
                                در سایت
                                <a class="fw-medium" href="#support" target="_blank">راستچین</a>
                            </div>
                            <div class="d-none d-lg-inline-block">
                                <a class="footer-link me-4" href="#support" target="_blank">لایسنس</a>
                                <a class="footer-link me-4" href="#support" target="_blank">قالب‌های بیشتر</a>
                                <a class="footer-link me-4" href="https://demos.pixinvent.com/vuexy-html-admin-template/documentation/" target="_blank">مستندات</a>
                                <a class="footer-link d-none d-sm-inline-block" href="#support-theme" target="_blank">پشتیبانی</a>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- / Footer -->
                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>
    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    <!-- Drag Target Area To SlideIn Menu On Small Screens -->
    <div class="drag-target"></div>
</div>
<!-- / Layout wrapper -->
<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="../../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>
<!-- endbuild -->
<!-- Vendors JS -->
<script>
    let today_jalali;
    let selected_patient;
    console.log(selected_patient);
    let service;
    let service_category;
    <?php
    if (isset($_GET['pcode'])){
        ?>
    selected_patient = '<?=trim($_GET['pcode'])?>';
    console.log(selected_patient);
    let patients_options = document.getElementById('patient_select').children;
    for (const patientsOption of patients_options) {
        if (patientsOption.value === selected_patient){
            document.getElementById('patient_select').value = selected_patient;
            document.getElementById('patient_select').dispatchEvent(new Event('change'));
        }
    }

    <?php
    }
    if(isset($_GET['service'])){
        ?>
    service = '<?=trim($_GET['service'])?>';
    document.getElementById('service_select').value = service;
    document.getElementById('service_select').dispatchEvent(new Event('change'));
    <?php
    }
    if(isset($_GET['service-cat'])){
        ?>
    service_category = '<?=trim($_GET['service-cat'])?>';
    document.getElementById('service_category_select').value = service_category;
    document.getElementById('service_category_select').dispatchEvent(new Event('change'));
    <?php
    }
    ?>
    window.onload = function(){
        const now = new Date();
        const today = `${now.getFullYear()}-${String(now.getMonth() + 1).padStart(2, '0')}-${String(now.getDate()).padStart(2, '0')}`;
        today_jalali = convertGregorianToJalali(today);
    }
</script>
<script src="../../assets/libs/fullcalendar/fullcalendar.js"></script>
<script src="../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../assets/vendor/libs/@form-validation/auto-focus.js"></script>
<script src="../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../assets/vendor/libs/select2/i18n/fa.js"></script>
<script src="../../assets/libs/jdate/jdate.js"></script>
<script src="../../assets/libs/flatpickr/flatpickr-jalali.js"></script>
<script src="../../assets/libs/flatpickr/l10n/fa.js"></script>
<script src="../../assets/vendor/libs/moment/moment.js"></script>
<!-- Main JS -->
<script src="../../assets/js/main.js"></script>
<script>var events = [];</script>
<script>
    function resetAddAppointmentForm() {
        // Target the add appointment form
        const $form = $('#addAppointmentForm');

        // Reset native form elements
        $form[0].reset();

        // Clear all Select2 dropdowns
        $form.find('select').each(function () {
            if ($(this).data('select2')) {
                $(this).val(null).trigger('change');
            } else {
                this.selectedIndex = 0;
            }
        });

        // Clear any flatpickr calendars
        $form.find('input').each(function () {
            if (this._flatpickr) {
                this._flatpickr.clear();
            }
        });
    }
</script>
<script src="../../assets/js/app-calendar-jalali.js?1"></script>
<!-- Page JS -->
<script>
    $('#addAppointmentForm').on('submit', function (e) {
        e.preventDefault();

        const selectedPatient = ($('#patient_select').val() || '').trim(); // handle null
        const patientName = ($('#patient_name').val() || '').trim();

        // Require name if no patient selected
        if (!selectedPatient && !patientName) {
            Swal.fire({
                icon: 'warning',
                title: 'نام بیمار الزامی است',
                text: 'لطفاً نام بیمار را وارد کنید یا از لیست انتخاب کنید.',
                showCancelButton: false,
                confirmButtonText: 'باشه',
                customClass: { confirmButton: 'btn btn-danger me-3 waves-effect waves-light' },
                buttonsStyling: false
            });
            return;
        }

        submitAppointmentForm(selectedPatient);
    });

    function submitAppointmentForm(selectedPatient) {
        const fd = new FormData(document.getElementById('addAppointmentForm'));
        <?php
        if(isset($_GET['treatment-plan'])){
            ?>
        fd.append('treatment_plan', '<?=htmlspecialchars($_GET['treatment-plan'])?>');
    <?php
        }
        ?>
        const btnSubmit = document.querySelector('button[type="submit"]');
        if(btnSubmit.innerHTML === "ویرایش"){
            fd.append('action', 'edit_appointment');
        }
        else {
            fd.append('action', 'add_appointment');
        }

        // If an existing patient is selected, remove manual patient fields
        if (selectedPatient) {
            fd.delete('patient_name');
            fd.delete('patient_nationalid');
            fd.delete('patient_phone');
        }

        fetch('functions/appointments_funcs.php', {
            method: 'POST',
            body: fd
        })
            .then(res => res.json())
            .then(res => {
                Swal.fire({
                    icon: res.success ? 'success' : 'error',
                    title: res.success ? 'موفق!' : 'خطا',
                    text: res.success ? res.message : res.error,
                    confirmButtonText: 'باشه',
                    showCancelButton: false,
                    customClass: { cancelButton: 'd-none',noButton: 'd-none',confirmButton: 'btn btn-primary me-3 waves-effect waves-light' },
                    buttonsStyling: false
                }).then(() => {
                    if (res.success) {
                        // Close sidebar if using Bootstrap Offcanvas
                        const offcanvasEl = document.getElementById('addEventSidebar');
                        const offcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
                        if (offcanvas) offcanvas.hide();

                        // Refresh calendar events if needed
                        if (typeof calendar !== 'undefined') {
                            calendar.refetchEvents();
                        }
                    }
                });
            })
            .catch(() => {
                Swal.fire({
                    icon: 'error',
                    title: 'خطا',
                    text: 'ارتباط با سرور برقرار نشد',
                    confirmButtonText: 'باشه'
                });
            });
    }
    function deleteAppointment() {
        const selectedPatient = ($('#patient_select').val() || '').trim(); // handle null
        console.log(selectedPatient);
        const fd = new FormData();
        fd.append('code', appointmentToUpdate);
        fd.append('action', 'delete_appointment');

        fetch('functions/appointments_funcs.php', {
            method: 'POST',
            body: fd
        })
            .then(res => res.json())
            .then(res => {
                Swal.fire({
                    icon: res.success ? 'success' : 'error',
                    title: res.success ? 'موفق!' : 'خطا',
                    text: res.success ? res.message : res.error,
                    confirmButtonText: 'باشه',
                    showCancelButton: false,
                    customClass: { cancelButton: 'd-none',noButton: 'd-none',confirmButton: 'btn btn-primary me-3 waves-effect waves-light' },
                    buttonsStyling: false
                }).then(() => {
                    if (res.success) {
                        // Close sidebar if using Bootstrap Offcanvas
                        const offcanvasEl = document.getElementById('addEventSidebar');
                        const offcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
                        if (offcanvas) offcanvas.hide();

                        // Refresh calendar events if needed
                        if (typeof calendar !== 'undefined') {
                            console.log(calendar);
                            //calendar.refetchEvents();
                        }else {
                            window.location.reload();
                        }

                    }
                });
            })
            .catch(() => {
                Swal.fire({
                    icon: 'error',
                    title: 'خطا',
                    text: 'ارتباط با سرور برقرار نشد',
                    confirmButtonText: 'باشه'
                });
            });
    }
</script>
<script>
    function convertGregorianToJalali(gregorianDateString) {
        if (!gregorianDateString || typeof gregorianDateString !== 'string') {
            console.error("Invalid input: gregorianDateString must be a non-empty string.");
            return null;
        }

        // Split the Gregorian date string into year, month, and day
        const parts = gregorianDateString.split('-');

        if (parts.length !== 3) {
            console.error("Invalid Gregorian date format. Expected 'YYYY-MM-DD'.");
            return null;
        }

        const year = parseInt(parts[0], 10);
        const month = parseInt(parts[1], 10);
        const day = parseInt(parts[2], 10);

        // Validate parsed numbers
        if (isNaN(year) || isNaN(month) || isNaN(day)) {
            console.error("Invalid Gregorian date components. Year, month, and day must be numbers.");
            return null;
        }

        // Use jalaali.toJalaali to convert
        const jalaliDate = jalaali.toJalaali(year, month, day);

        // Format the Jalali date as YYYY/MM/DD
        // Pad month and day with leading zeros if they are single digits
        const formattedMonth = String(jalaliDate.jm).padStart(2, '0');
        const formattedDay = String(jalaliDate.jd).padStart(2, '0');

        return `${jalaliDate.jy}/${formattedMonth}/${formattedDay}`;
    }

    // Example Usage:
    const gregorianInput = "2025-09-01";
    const jalaliOutput = convertGregorianToJalali(gregorianInput);

    if (jalaliOutput) {
        console.log(`Gregorian: ${gregorianInput} -> Jalali: ${jalaliOutput}`); // Expected: Gregorian: 2025-09-01 -> Jalali: 1404/06/10
    }
</script>
<script>
    // Appointment Time (24h time picker, manual typing allowed)
    if (document.querySelector('#eventStartTime')) {
        flatpickr('#eventStartTime', {
            enableTime: true,
            noCalendar: true,
            dateFormat: 'H:i',   // Store as 24h HH:mm
            time_24hr: true,     // 24-hour mode
            defaultHour: 14,
            defaultMinute: 0,
            allowInput: true     // Let users type manually
        });
    }
</script>
</body>
</html>
