<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once "config.php"; // DB connection

// If no active session but cookie exists → try auto-login
if (empty($_SESSION['user_code']) && !empty($_COOKIE['remember_token'])) {
    $cookie_token = $_COOKIE['remember_token'];
    $token_hash = hash('sha256', $cookie_token);

    $stmt = $pdo->prepare("SELECT user_code, expires_at FROM remember_tokens WHERE token_hash = ?");
    $stmt->execute([$token_hash]);
    $token_data = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($token_data && strtotime($token_data['expires_at']) > time()) {
        // Valid token — create session
        $_SESSION['user_code'] = $token_data['user_code'];

        // Rotate token for security
        $new_token = bin2hex(random_bytes(32));
        $new_hash  = hash('sha256', $new_token);
        $new_exp   = date('Y-m-d H:i:s', time() + (30 * 24 * 60 * 60));

        $pdo->prepare("DELETE FROM remember_tokens WHERE token_hash = ?")->execute([$token_hash]);
        $pdo->prepare("INSERT INTO remember_tokens (user_code, token_hash, expires_at) VALUES (?, ?, ?)")
            ->execute([$token_data['user_code'], $new_hash, $new_exp]);

        setcookie(
            'remember_token',
            $new_token,
            [
                'expires'  => time() + (30 * 24 * 60 * 60),
                'path'     => '/',
                'secure'   => isset($_SERVER['HTTPS']),
                'httponly' => true,
                'samesite' => 'Strict'
            ]
        );
    }
}

function getUser($pdo){
    $code = $_SESSION['user_code'];
    $stmt = $pdo->prepare("SELECT * FROM users WHERE user_code = ?");
    $stmt->execute([$code]);
    $userData = $stmt->fetch(PDO::FETCH_ASSOC);
    $user = [];
    $user['code'] = $userData['user_code'];
    $user['firstname'] = decryptData($userData['first_name_encrypted'] ?: 'کاربر');
    $user['lastname'] = decryptData($userData['last_name_encrypted'] ?: 'کاربر');
    $user['fullname'] = decryptData($userData['full_name_encrypted'] ?: 'کاربر');
    $user['email'] = decryptData($userData['email_encrypted'] ?: '');
    $user['nationalID'] = decryptData($userData['national_id_encrypted'] ?: '');
    $user['nezamID'] = decryptData($userData['nezam_id_encrypted'] ?: '');
    $user['phone'] = decryptData($userData['phone_encrypted']);
    $user['speciality'] = decryptData($userData['speciality_encrypted'] ?: '');
    $user['address'] = decryptData($userData['address_encrypted'] ?: '');
    $user['province'] = decryptData($userData['province_encrypted'] ?: '');
    $user['city'] = decryptData($userData['city_encrypted'] ?: '');
    $user['zipcode'] = decryptData($userData['zipcode_encrypted'] ?: '');
    $user['account_status'] = $userData['account_status'];
    $user['avatar'] = $userData['avatar'];
    return $user;
}