<?php
session_start();
require 'auth21.php';
if (empty($_SESSION['user_code'])) {
    header("Location: login");
    exit;
}
$user = getUser($pdo);
if($user['account_status'] == "NOTSIGNEDUP"){
    header("Location: registration");
    exit;
}
$officeCode = $_SESSION['user_code'] ?? null;
$patient_code = URL(1);
$stmt = $pdo->prepare("
    SELECT *
    FROM patients
    WHERE office_code = :office_code
      AND status != 'DELETED' AND patient_code = :patient_code
");
$stmt->execute([':office_code' => $officeCode, ':patient_code' => $patient_code]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
$patient_encrypted = [
        'patient_firstname_encrypted'       => decryptData($row['patient_firstname_encrypted']),
        'patient_lastname_encrypted'        => decryptData($row['patient_lastname_encrypted']),
        'patient_fullname_encrypted'        => decryptData($row['patient_fullname_encrypted']),
        'patient_nationalid_encrypted'      => decryptData($row['patient_nationalid_encrypted']),
        'patient_phone_encrypted'           => decryptData($row['patient_phone_encrypted']),
        'gender_encrypted'                  => decryptData($row['gender_encrypted']),
        'firstname_en_encrypted'            => decryptData($row['firstname_en_encrypted']),
        'lastname_en_encrypted'             => decryptData($row['lastname_en_encrypted']),
        'home_number_encrypted'             => decryptData($row['home_number_encrypted']),
        'father_name_encrypted'             => decryptData($row['father_name_encrypted']),
        'emergency_contact_encrypted'       => decryptData($row['emergency_contact_encrypted']),
        'emergency_contact_name_encrypted'  => decryptData($row['emergency_contact_name_encrypted']),
        'emergency_contact_relation_encrypted' => decryptData($row['emergency_contact_relation_encrypted']),
        'education_encrypted'               => decryptData($row['education_encrypted']),
        'occupation_encrypted'              => decryptData($row['occupation_encrypted']),
        'birthdate_encrypted'               => decryptData($row['birthdate_encrypted']),
        'address_encrypted'                 => decryptData($row['address_encrypted']),
        'bloodtype_encrypted'               => decryptData($row['bloodtype_encrypted']),
        'pregnancy_encrypted'               => decryptData($row['pregnancy_encrypted']),
        'marital_status_encrypted'          => decryptData($row['marital_status_encrypted']),
        'medical_histories_encrypted'       => decryptData($row['medical_histories_encrypted'])
];
$iv = $row['iv'];
$salt = $row['salt'];
$enc_code = $row['enc_code'];
$tmp_patient = get_decrypted_data($patient_encrypted,$iv,$salt,$enc_code);
$tmp_patient['patient_code'] = $row['patient_code'];
$tmp_patient['case_number_encrypted'] = $row['case_number_encrypted'];
$tmp_patient['patient_avatar'] = $row['patient_avatar'];
$tmp_patient['status'] = $row['status'];
$tmp_patient['created_at'] = $row['created_at'];
$patient = $tmp_patient;
$patient_avatar = '../../../assets/img/avatars/NoAvatar.png';
if($patient['patient_avatar'] != null && $patient['patient_avatar'] != ""){
    $patient_avatar = decryptData($patient['patient_avatar']);
}
$medical_histories = [];
$stmt = $pdo->prepare("
    SELECT *
    FROM medical_histories
    WHERE (office_code = :office_code or office_code = 'DEFAULT') AND hide_default_for NOT LIKE :pattern
      AND status != 'DELETED'
");
$stmt->execute([':office_code' => $officeCode,':pattern' => '%"'.$officeCode.'"%']);
$medical_histories_res = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($medical_histories_res as $medical_history) {
    $medical_histories[$medical_history['history_code']] = $medical_history;
}

$tariffs = [];
$stmt = $pdo->prepare("
    SELECT *
    FROM tariffs
    WHERE office_code = :office_code AND for_type = 'services' AND status != 'DELETED'
");
$stmt->execute([':office_code' => $officeCode]);
$tariffs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<?php
if(isset($_POST['add-done-services-submit'])){
    $treatment_code2 = "NOTREATMENTPLAN";
    if(isset($_GET['treatment-plan'])){
        $treatment_code2 = $_GET['treatment-plan'];
    }
    $dentist_code = "MANUAL";
    $manual_dentist_name = "NA";
    $dentist_selection_type = $_POST['dentist_selection_type'];
    if($dentist_selection_type == "manual"){
        $manual_dentist_name = $_POST['manual_dentist_name'];
    }
    else{
        $dentist_code = $_POST['dentist_code'];
    }
    $selected_dentition = trim($_POST['selected_dentition']);
    $selected_teeth = trim($_POST['selected_teeth']);
    $treatmentNote = trim($_POST['treatmentNote']);
    $service_code = trim($_POST['service_code']);
    $dentist_cut_percentage = trim($_POST['dentist_cut_percentage']);
    $dentist_cut_amount = trim($_POST['dentist_cut_amount']);
    $cost = str_replace(',', '', trim($_POST['treatment_cost']));
    $additionalCost = str_replace(',', '', trim($_POST['additionalTreatment_cost']));
    $patientPrimary_cost = str_replace(',', '', trim($_POST['patientPrimary_cost']));
    $clinicDiscount = (int)preg_replace('/\D+/', '', trim($_POST['clinicDiscount']));
    $dentistDiscount = (int)preg_replace('/\D+/', '', trim($_POST['dentistDiscount']));
    $patientFinal_cost = (int)preg_replace('/\D+/', '', trim($_POST['patientFinal_cost']));
    $paidJson = trim($_POST['paidJson']);
    $statusBtn = trim($_POST['statusInput']);
    $start_date = "نامشخص";
    $last_date = "نامشخص";
    $start_date = trim($_POST['start-date']);
    $last_date = trim($_POST['last-date']);
    $done_code = 'DONE-' . uniqid() . rand(100000,9999999);
    $persianDigits = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $englishDigits = ['0','1','2','3','4','5','6','7','8','9'];
    $jalaliDate = jdate('Y-m-d H:i:s');
    $jalaliYearEnglish = str_replace($persianDigits, $englishDigits, $jalaliDate);

    // --- Generate next numeric case number (PHP-side) ---
    $stmt = $pdo->prepare("
        SELECT done_code_number 
        FROM done_treatments 
        WHERE clinic_code = :office
    ");
    $stmt->execute([':office' => $officeCode]);
    $maxCase = 0;
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $done_code_number = $row['done_code_number']; // same as encryptData's reverse
        if (ctype_digit($done_code_number) && (int)$done_code_number > $maxCase) {
            $maxCase = (int)$done_code_number;
        }
    }
    $nextDoneNumber = $maxCase + 1;
    if(isset($_GET['mode']) && $_GET['mode'] == 'editDoneServices'){
        $done_code3 = $_GET['editDoneCode'];
        try {
            $stmt = $pdo->prepare("
        UPDATE done_treatments 
        SET
            start_date              = ?,
            finish_date             = ?,
            cost                    = ?,
            additional_cost         = ?,
            patientPrimary_cost     = ?,
            clinicDiscount          = ?,
            dentistDiscount         = ?,
            patientFinal_cost       = ?,
            dentist_cut_percentage  = ?,
            dentist_cut_amount      = ?,
            dentist_code            = ?,
            manual_dentist_name     = ?,
            service_code            = ?,
            teeth                   = ?,
            dentition               = ?,
            note                    = ?,
            shamsi_date              = ?,
            status                  = ?
        WHERE done_code = ? AND clinic_code = ?
    ");
            $stmt->execute([
                    $start_date,
                    $last_date,
                    $cost,
                    $additionalCost,
                    $patientPrimary_cost,
                    $clinicDiscount,
                    $dentistDiscount,
                    $patientFinal_cost,
                    $dentist_cut_percentage,
                    $dentist_cut_amount,
                    $dentist_code,
                    $manual_dentist_name,
                    $service_code,
                    $selected_teeth,
                    $selected_dentition,
                    $treatmentNote,
                    $jalaliYearEnglish,
                    $statusBtn,
                    $done_code3,
                    $officeCode
            ]);

            echo "<script>
        window.location.href = '$patient_code?tab=doneServices&success=updateDoneServices';
    </script>";

        } catch (PDOException $e) {
            echo "<script>
        alert('Error: " . addslashes($e->getMessage()) . "');
        window.history.back();
    </script>";
        }
    }
    else{
        try{
            $stmt = $pdo->prepare("
        INSERT INTO done_treatments (start_date,finish_date,done_code_number,done_code,treatment_code,cost,additional_cost,patientPrimary_cost,clinicDiscount,dentistDiscount,patientFinal_cost,paidJson,dentist_cut_percentage,dentist_cut_amount,dentist_code,manual_dentist_name, patient_code, clinic_code, service_code,teeth,dentition,note,shamsi_date,status) 
        VALUES (?,?,?,?,?,?,?,?,?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
            $stmt->execute([$start_date,$last_date,$nextDoneNumber,$done_code,$treatment_code2,$cost,$additionalCost,$patientPrimary_cost,$clinicDiscount,$dentistDiscount,$patientFinal_cost,$paidJson,$dentist_cut_percentage,$dentist_cut_amount,$dentist_code,$manual_dentist_name, $patient_code, $officeCode,$service_code,$selected_teeth,$selected_dentition,$treatmentNote,$jalaliYearEnglish,$statusBtn]);
            echo "<script>
                window.location.href = '$patient_code?tab=doneServices&success=addDoneServices';
              </script>";
        }
        catch (PDOException $e){
            echo "<script>
                alert('Error: " . addslashes($e->getMessage()) . "');
                window.history.back();
              </script>";
        }
    }
}
if(isset($_POST['add-treatment-plan-submit'])){
    $dentist_code = "MANUAL";
    $manual_dentist_name = "NA";
    $dentist_selection_type = $_POST['dentist_selection_type'];
    if($dentist_selection_type == "manual"){
        $manual_dentist_name = $_POST['manual_dentist_name'];
    }
    else{
        $dentist_code = $_POST['dentist_code'];
    }
    $selected_dentition = trim($_POST['selected_dentition']);
    $selected_teeth = trim($_POST['selected_teeth']);
    $treatmentNote = trim($_POST['treatmentNote']);
    $service_code = trim($_POST['service_code']);
    $dentist_cut_percentage = trim($_POST['dentist_cut_percentage']);
    $dentist_cut_amount = trim($_POST['dentist_cut_amount']);
    $cost = str_replace(',', '', trim($_POST['treatment_cost']));
    $additionalCost = str_replace(',', '', trim($_POST['additionalTreatment_cost']));
    $treatment_code = 'TRTMNT-' . uniqid() . rand(100000,9999999);
    $persianDigits = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $englishDigits = ['0','1','2','3','4','5','6','7','8','9'];
    $jalaliDate = jdate('Y-m-d H:i:s');
    $jalaliYearEnglish = str_replace($persianDigits, $englishDigits, $jalaliDate);
    try{
        $stmt = $pdo->prepare("
        INSERT INTO treatments (treatment_code,cost,additional_cost,dentist_cut_percentage,dentist_cut_amount,dentist_code,manual_dentist_name, patient_code, clinic_code, service_code,teeth,dentition,note,shamsi_date) 
        VALUES (?,?,?,?,?,?, ?, ?,?, ?, ?, ?, ?, ?)
    ");
        $stmt->execute([$treatment_code,$cost,$additionalCost,$dentist_cut_percentage,$dentist_cut_amount,$dentist_code,$manual_dentist_name, $patient_code, $officeCode,$service_code,$selected_teeth,$selected_dentition,$treatmentNote,$jalaliYearEnglish]);
        echo "<script>
                window.location.href = '$patient_code?tab=treatmentPlans&success=addTreatmentPlan';
              </script>";
    }
    catch (PDOException $e){
        echo "<script>
                alert('Error: " . addslashes($e->getMessage()) . "');
                window.history.back();
              </script>";
    }
}
?>
<?php
// Get dentists (assuming you have a dentists table)
$stmt = $pdo->prepare("SELECT dentist_code, dentist_fullname_encrypted,iv,salt,enc_code,cut FROM dentists WHERE office_code = ? AND status = 'ACTIVE'");
$stmt->execute([$officeCode]);
$dentists_enc = $stmt->fetchAll(PDO::FETCH_ASSOC);
$dentists_enc2 = [];
$dentists = [];
foreach ($dentists_enc as $dentist) {
    $dentists_enc2['dentist_fullname_encrypted'] = decryptData($dentist['dentist_fullname_encrypted']);
    $iv = $dentist['iv'];
    $salt = $dentist['salt'];
    $enc_code = $dentist['enc_code'];
    $tmp_dentist = get_decrypted_data($dentists_enc2,$iv,$salt,$enc_code);
    $tmp_dentist['dentist_code'] = $dentist['dentist_code'];
    $tmp_dentist['cut'] = $dentist['cut'];
    $dentists[] = $tmp_dentist;
}

?>
<?php
$stmt = $pdo->prepare("
        SELECT service_code, service_title, service_category_code
        FROM services
        WHERE status = 'ACTIVE' AND COALESCE(hide_default_for, '') NOT LIKE :pattern
          AND (office_code = :office_code OR office_code = 'DEFAULT')
    ");
$stmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
$services = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<?php
$service_categories = [];
$stmt =  $pdo->prepare("
        SELECT service_category_code, category_title
        FROM service_categories
        WHERE (office_code = :office_code OR office_code = 'DEFAULT')
          AND status = 'ACTIVE' AND COALESCE(hide_default_for, '') NOT LIKE :pattern
    ");
$stmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
$service_categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<?php
if(isset($_POST['edit-treatment-plan-submit'])){
    $selected_dentition = trim($_POST['selected_dentitionEdit']);
    $selected_teeth = trim($_POST['selected_teethEdit']);
    $treatmentNote = trim($_POST['treatmentNoteEdit']);
    $service_code = trim($_POST['service_code_edit']);
    $status = trim($_POST['status_edit']);
    $treatment_code = trim($_POST['treatment_code_edit']);
    $persianDigits = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $englishDigits = ['0','1','2','3','4','5','6','7','8','9'];
    try{
        $stmt = $pdo->prepare("
        UPDATE treatments set service_code = ?,teeth = ?,dentition = ?,note = ?,status = ? where treatment_code = ?");
        $stmt->execute([$service_code,$selected_teeth,$selected_dentition,$treatmentNote,$status,$treatment_code]);
        echo "<script>
                window.location.href = '$patient_code?tab=treatmentPlans&success=editTreatmentPlan';
              </script>";
    }
    catch (PDOException $e){
        echo "<script>
                alert('Error: " . addslashes($e->getMessage()) . "');
                window.history.back();
              </script>";
    }
}
?>
<?php

?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>نمایش کاربر - حساب کاربری | Vuexy - قالب مدیریت بوت استرپ</title>
    <meta content="" name="description"/>
    <!-- Favicon -->
    <link href="../../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <!-- Icons -->
    <link href="../../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <!-- Core CSS -->
    <link href="../../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../../assets/css/demo.css" rel="stylesheet"/>
    <!-- Vendors CSS -->
    <link href="../../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/animate-css/animate.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/sweetalert2/sweetalert2.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/select2/select2.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <link href="../../../assets/libs/flatpickr/flatpickr.css" rel="stylesheet"/>
    <link href="../../../assets/libs/bootstrap-datepicker/bootstrap-datepicker.css" rel="stylesheet"/>
    <link href="../../../assets/libs/jalali-datepicker/jalalidatepicker.css" rel="stylesheet" />
    <link href="../../../assets/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/jquery-timepicker/jquery-timepicker.css" rel="stylesheet"/>
    <link href="../../../assets/vendor/libs/pickr/pickr-themes.css" rel="stylesheet"/>
    <!-- Page CSS -->
    <link href="../../../assets/vendor/css/pages/page-user-view.css" rel="stylesheet"/>
    <!-- Helpers -->
    <script src="../../../assets/vendor/js/helpers.js"></script>

    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../../../assets/js/config.js"></script>
    <!-- Better experience of RTL -->
    <link href="../../../assets/css/rtl.css" rel="stylesheet"/>
    <script src="../../../assets/vendor/libs/jquery/jquery.js"></script>

</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->
        <?php require_once 'sidebar.php';?>
        <!-- / Menu -->
        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            <?php require_once 'navbar.php';?>
            <!-- / Navbar -->
            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->
                <div class="container-xxl flex-grow-1 container-p-y">
                    <h4 class="py-3 mb-4">
                        <span class="text-muted fw-light">اطلاعات افراد/</span>
                        پرونده بیمار
                    </h4>
                    <div class="row">
                        <!-- User Content -->
                        <div class="col-12">
                            <!-- User Pills -->
                            <ul class="nav nav-pills flex-column flex-md-row mb-4">
                                <?php
                                $treatmentPlanActiveBtn = '';
                                $addTreatmentPlanActiveBtn = '';
                                $appointmentsActiveBtn = '';
                                $messagesActiveBtn = '';
                                $patientOverviewActiveBtn = '';
                                $patientRecordsActiveBtn = '';
                                $addDoneServicesActiveBtn = '';
                                $doneServicesActiveBtn = '';
                                $accountingActiveBtn = '';
                                $treatmentPlanTabDisplay = "none";
                                $addTreatmentPlanTabDisplay = "none";
                                $appointmentsTabDisplay = "none";
                                $messagesTabDisplay = "none";
                                $patientOverviewTabDisplay = "none";
                                $patientRecordsTabDisplay = "none";
                                $doneServicesTabDisplay = "none";
                                $addDoneServicesTabDisplay = "none";
                                $accountingTabDisplay = "none";
                                if(isset($_GET['tab'])){
                                    if($_GET['tab'] == "overview"){
                                        $patientOverviewActiveBtn = 'active';
                                        $patientOverviewTabDisplay = "block";
                                    }
                                    if($_GET['tab'] == "treatmentPlans"){
                                        $treatmentPlanActiveBtn = 'active';
                                        $treatmentPlanTabDisplay = "block";
                                    }
                                    if($_GET['tab'] == "addTreatmentPlan"){
                                        $addTreatmentPlanActiveBtn =  'active';
                                        $addTreatmentPlanTabDisplay = "block";
                                    }
                                    if($_GET['tab'] == "doneServices"){
                                        $doneServicesActiveBtn = 'active';
                                        $doneServicesTabDisplay = "block";
                                    }
                                    if($_GET['tab'] == "addDoneServices"){
                                        $addDoneServicesActiveBtn =  'active';
                                        $addDoneServicesTabDisplay = "block";
                                    }
                                    if($_GET['tab'] == "appointments"){
                                        $appointmentsActiveBtn=  'active';
                                        $appointmentsTabDisplay = "block";
                                    }
                                    if($_GET['tab'] == "messages"){
                                        $messagesActiveBtn=  'active';
                                        $messagesTabDisplay = "block";
                                    }
                                    if($_GET['tab'] == "records"){
                                        $patientRecordsActiveBtn=  'active';
                                        $patientRecordsTabDisplay = "block";
                                    }
                                    if($_GET['tab'] == "accounting"){
                                        $accountingActiveBtn=  'active';
                                        $accountingTabDisplay = "block";
                                    }
                                }
                                else{
                                    $patientOverviewActiveBtn = 'active';
                                    $patientOverviewTabDisplay = "block";
                                }
                                ?>
                                <li class="nav-item">
                                    <a class="nav-link <?=$patientOverviewActiveBtn?>" href="<?=ROOT . 'cases/' . $patient_code . '?tab=overview'?>">
                                        <i class="ti ti-user-check ti-xs me-1"></i>
                                        اطلاعات بیمار
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?=$treatmentPlanActiveBtn?>" href="<?=ROOT . 'cases/' . $patient_code . '?tab=treatmentPlans'?>">
                                        <i class="ti ti-user-check ti-xs me-1"></i>
                                        طرح درمان ها
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?=$addTreatmentPlanActiveBtn?>" href="<?=ROOT . 'cases/' . $patient_code . '?tab=addTreatmentPlan'?>">
                                        <i class="ti ti-plus ti-xs me-1"></i>
                                        افزودن طرح درمان
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?=$doneServicesActiveBtn?>" href="<?=ROOT . 'cases/' . $patient_code . '?tab=doneServices'?>">
                                        <i class="ti ti-user-check ti-xs me-1"></i>
                                        درمان های انجام شده
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?=$addDoneServicesActiveBtn?>" href="<?=ROOT . 'cases/' . $patient_code . '?tab=addDoneServices'?>">
                                        <i class="ti ti-plus ti-xs me-1"></i>
                                        ثبت درمان
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?=$appointmentsActiveBtn?>" href="<?=ROOT . 'cases/' . $patient_code . '?tab=appointments'?>">
                                        <i class="ti ti-calendar-due ti-xs me-1"></i>
                                        نوبت ها
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?=$patientRecordsActiveBtn?>" href="<?=ROOT . 'cases/' . $patient_code . '?tab=records'?>">
                                        <i class="ti ti-folders ti-xs me-1"></i>
                                        رکوردها
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?=$accountingActiveBtn?>" href="<?=ROOT . 'cases/' . $patient_code . '?tab=accounting'?>">
                                        <i class="ti ti-receipt ti-xs me-1"></i>
                                        حسابداری
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link <?=$messagesActiveBtn?>" href="<?=ROOT . 'cases/' . $patient_code . '?tab=messages'?>">
                                        <i class="ti ti-message me-1 ti-xs"></i>
                                        پیام های ارسالی
                                    </a>
                                </li>
                            </ul>
                            <!--/ User Pills -->
                            <!-- Invoice table -->
                            <?php if (isset($_GET['success'])){
                                if($_GET['success'] == "addTreatmentPlan"){
                                    ?>
                                    <div class="alert alert-success mt-3 mb-3">
                                        طرح درمان با موفقیت افزوده شد.
                                    </div>
                                    <?php
                                }
                                if($_GET['success'] == "addDoneServices"){
                                    ?>
                                    <div class="alert alert-success mt-3 mb-3">
                                        درمان با موفقیت ثبت شد.
                                    </div>
                                    <?php
                                }
                                if($_GET['success'] == "editTreatmentPlan"){
                                    ?>
                                    <div class="alert alert-success mt-3 mb-3">
                                        طرح درمان با موفقیت ویرایش شد.
                                    </div>
                                    <?php
                                }
                            }
                            ?>
                            <div class="mb-4" style="display: <?=$patientOverviewTabDisplay?>">
                                <div class="row">
                                    <div class="col-12 col-md-6 col-lg-4 p-2">
                                        <div class="card">
                                            <div class="user-avatar-section">
                                                <div class="d-flex align-items-center flex-column">
                                                    <img alt="آواتار کاربر" class="img-fluid rounded mb-3 pt-1 mt-4" height="100" src="<?=$patient_avatar?>" width="100"/><br>
                                                    <button type="button" class="btn btn-primary mb-2" onclick="openCamera()">ثبت تصویر بیمار</button>
                                                    <div class="user-info text-center">
                                                        <h4 class="mb-2"><?=htmlspecialchars($patient['patient_fullname_encrypted'])?></h4>
                                                        <span class="badge bg-label-secondary mt-1">بیمار</span><br>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-around flex-wrap mt-3 pt-3 pb-4 border-bottom">
                                                <div class="d-flex align-items-start me-4 mt-3 gap-2">
                                            <span class="badge bg-label-primary p-2 rounded">
                                                <i class="ti ti-calendar ti-sm"></i>
                                            </span>
                                                    <div>
                                                        <p class="mb-0 fw-medium">1.23k</p>
                                                        <small>نوبت ها</small>
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-start mt-3 gap-2">
                                            <span class="badge bg-label-primary p-2 rounded">
                                                <i class="ti ti-circle-check ti-sm"></i>
                                            </span>
                                                    <div>
                                                        <p class="mb-0 fw-medium">568</p>
                                                        <small>درمان های انجام شده</small>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-8 p-2">
                                        <div class="card">
                                            <div class="card-body">
                                                <p class="mt-4 small text-uppercase text-muted">جزئیات</p>
                                                <div class="info-container">
                                                    <ul class="list-unstyled">
                                                        <li class="mb-2">
                                                            <span class="fw-medium me-1">شماره پرونده:</span>
                                                            <span><?= htmlspecialchars(decryptData($patient['case_number_encrypted'])) ?></span>
                                                        </li>
                                                        <li class="mb-2 pt-1">
                                                            <span class="fw-medium me-1">نام کامل:</span>
                                                            <span><?= htmlspecialchars($patient['patient_fullname_encrypted']) ?></span>
                                                        </li>
                                                        <li class="mb-2 pt-1">
                                                            <span class="fw-medium me-1">کد ملی:</span>
                                                            <span><?= htmlspecialchars($patient['patient_nationalid_encrypted']) ?></span>
                                                        </li>
                                                        <li class="mb-2 pt-1">
                                                            <span class="fw-medium me-1">شماره موبایل:</span>
                                                            <span><bdi><?= htmlspecialchars($patient['patient_phone_encrypted']) ?></bdi></span>
                                                        </li>
                                                        <li class="mb-2 pt-1">
                                                            <span class="fw-medium me-1">وضعیت:</span>
                                                            <span class="badge <?= $patient['status'] === 'ACTIVE' ? 'bg-label-success' : 'bg-label-danger' ?>">
                <?= $patient['status'] === 'ACTIVE' ? 'فعال' : 'غیرفعال' ?>
            </span>
                                                        </li>
                                                        <li class="mb-2 pt-1">
                                                            <span class="fw-medium me-1">سوابق پزشکی:</span>
                                                            <?php
                                                            $p_medical_histories_json1 = $patient['medical_histories_encrypted'];
                                                            $p_medical_histories_json2 = "";
                                                            $p_medical_histories_json3 = "";
                                                            $p_medical_histories_json4 = "";
                                                            $p_medical_history_arr = [];
                                                            if(is_array($p_medical_histories_json1)){
                                                                $p_medical_history_arr = $p_medical_histories_json1;
                                                            }
                                                            else{
                                                                $p_medical_histories_json2 = json_decode($p_medical_histories_json1);
                                                            }
                                                            if(is_array($p_medical_histories_json2)){
                                                                $p_medical_history_arr = $p_medical_histories_json2;
                                                            }
                                                            else{
                                                                $p_medical_histories_json3 = json_decode($p_medical_histories_json2);
                                                            }
                                                            if(is_array($p_medical_histories_json3)){
                                                                $p_medical_history_arr = $p_medical_histories_json3;
                                                            }
                                                            else{
                                                                $p_medical_histories_json4 = json_decode($p_medical_histories_json3);
                                                            }
                                                            foreach ($p_medical_history_arr as $key) {
                                                                $mh = $medical_histories[$key];
                                                                ?>
                                                                <span class="badge <?php if ($mh['alert_flag']){echo 'bg-label-danger ';}else{echo 'bg-label-warning';} ?> p-2"><?= htmlspecialchars(decryptData($mh['title_encrypted']))?></span>
                                                                <?php
                                                            }
                                                            ?>

                                                        </li>
                                                        <?php
                                                        $gregorian_date = $patient['created_at'];
                                                        $timestamp = strtotime($gregorian_date);
                                                        // With Persian formatting
                                                        $jalali_formatted = jdate('l، j F Y - ساعت H:i', $timestamp);
                                                        ?>
                                                        <li class="pt-1">
                                                            <span class="fw-medium me-1">تاریخ ایجاد:</span>
                                                            <span><?= htmlspecialchars($jalali_formatted) ?></span>
                                                        </li>
                                                    </ul>
                                                    <div class="d-flex justify-content-center">
                                                        <a class="btn btn-primary me-3" href="<?=ROOT?>edit-patients?pcode=<?=$patient_code?>">ویرایش</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <script>
                                let currentStream = null;
                                let capturedBlob = null;

                                /* Open camera */
                                async function openCamera(deviceId = null) {
                                    await loadCameras();
                                    stopCurrentStream();

                                    const constraints = {
                                        video: {
                                            width: { ideal: 720 },
                                            height: { ideal: 1280 },
                                            deviceId: deviceId ? { exact: deviceId } : undefined
                                        }
                                    };

                                    currentStream = await navigator.mediaDevices.getUserMedia(constraints);
                                    webcam.srcObject = currentStream;

                                    preview.style.display = 'none';
                                    webcam.style.display = 'block';
                                    document.getElementById('avatar_upload_progress').classList.add('d-none');
                                    document.getElementById('avatar_upload_progress_success').classList.add('d-none');
                                    bootstrap.Modal.getOrCreateInstance(cameraModal).show();
                                }

                                /* Load cameras */
                                async function loadCameras() {
                                    await navigator.mediaDevices.getUserMedia({ video: true });

                                    const devices = await navigator.mediaDevices.enumerateDevices();
                                    const select = document.getElementById('cameraSelect');
                                    select.innerHTML = '';

                                    devices
                                        .filter(d => d.kind === 'videoinput')
                                        .forEach((device, i) => {
                                            const option = document.createElement('option');
                                            option.value = device.deviceId;
                                            option.text = device.label || `Camera ${i + 1}`;
                                            select.appendChild(option);
                                        });

                                    select.onchange = () => openCamera(select.value);
                                }

                                /* Capture photo */
                                function capturePhoto() {
                                    const video = document.getElementById('webcam');

                                    const canvas = document.createElement('canvas');

                                    // Portrait output
                                    canvas.width = 720;
                                    canvas.height = 1280;

                                    const ctx = canvas.getContext('2d');
                                    ctx.drawImage(video, 0, 0, canvas.width, canvas.height);

                                    canvas.toBlob(blob => {
                                        capturedBlob = blob;
                                        preview.src = URL.createObjectURL(blob);
                                        preview.style.display = 'block';
                                        video.style.display = 'none';
                                        stopCurrentStream();
                                    }, 'image/jpeg', 0.95);
                                    document.getElementById('retakeBtn').classList.remove('d-none');
                                    document.getElementById('captureBtn').classList.add('d-none');
                                    document.getElementById('upload_avatar_file').disabled = false;
                                }

                                /* Retake */
                                function retakePhoto() {
                                    preview.style.display = 'none';
                                    webcam.style.display = 'block';
                                    openCamera(cameraSelect.value);

                                    document.getElementById('retakeBtn').classList.add('d-none');
                                    document.getElementById('captureBtn').classList.remove('d-none');
                                    document.getElementById('upload_avatar_file').disabled = true;

                                }

                                /* Stop stream */
                                function stopCurrentStream() {
                                    if (currentStream) {
                                        currentStream.getTracks().forEach(t => t.stop());
                                        currentStream = null;
                                    }
                                }

                                /* Cleanup on close */
                                cameraModal.addEventListener('hidden.bs.modal', stopCurrentStream);
                            </script>
                            <!-- Modal -->
                            <div class="modal fade" id="cameraModal" tabindex="-1">
                                <div class="modal-dialog modal-dialog-centered modal-lg">
                                    <div class="modal-content p-3">

                                        <div class="modal-body">
                                            <button class="btn-close mb-3" data-bs-dismiss="modal"></button>

                                            <select id="cameraSelect" class="form-select mb-3"></select>

                                            <div class="camera-center">
                                                <video id="webcam" autoplay playsinline></video>
                                                <img id="preview">
                                            </div>

                                            <div class="d-flex gap-2 mt-3">
                                                <button id="captureBtn" class="btn btn-outline-primary flex-fill" onclick="capturePhoto()">
                                                    📸 گرفتن عکس
                                                </button>
                                                <button id="retakeBtn" class="btn btn-warning flex-fill d-none" onclick="retakePhoto()">
                                                    🔄 دوباره
                                                </button>
                                                <button id="upload_avatar_file" class="btn btn-primary flex-fill" onclick="uploadCapturedImage();" disabled>
                                                    ثبت تصویر
                                                </button>
                                            </div>
                                            <div id="avatar_upload_progress" class="col mb-3 text-center d-none">
                                                <h2 class="form-label" for="nameWithTitle">در حال آپلود فایل ...</h2>
                                                <div class="progress mt-3">
                                                    <div id="uploadProgress2"
                                                         class="progress-bar progress-bar-striped progress-bar-animated bg-primary"
                                                         role="progressbar"
                                                         aria-valuemin="0"
                                                         aria-valuemax="100"
                                                         aria-valuenow="0"
                                                         style="width: 20%">
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="avatar_upload_progress_success" class="col mb-3 text-center d-none">
                                                <div class="alert alert-success">
                                                    عکس با موفقیت ثبت شد.
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <script>
                                function uploadCapturedImage() {
                                    if (!capturedBlob) {
                                        alert("لطفاً ابتدا عکس بگیرید");
                                        return;
                                    }
                                    document.getElementById('avatar_upload_progress').classList.remove('d-none');
                                    document.getElementById('avatar_upload_progress_success').classList.add('d-none');
                                    let formData = new FormData();

                                    // 👈 IMPORTANT: same key your backend expects
                                    const file = new File([capturedBlob], 'camera_' + Date.now() + '.jpg', {
                                        type: 'image/jpeg'
                                    });

                                    formData.append("uploaded_file[]", file);

                                    $.ajax({
                                        url: "<?=ROOT?>functions/add_avatar_upload_funcs.php",
                                        type: "POST",
                                        data: formData,
                                        processData: false,
                                        contentType: false,
                                        xhr: function () {
                                            let xhr = new window.XMLHttpRequest();
                                            xhr.upload.addEventListener("progress", function (evt) {
                                                if (evt.lengthComputable) {
                                                    let percent = (evt.loaded / evt.total) * 100;
                                                    $("#uploadProgress2")
                                                        .css("width", percent.toFixed(2) + "%")
                                                        .attr("aria-valuenow", percent.toFixed(2))
                                                        .text(percent.toFixed(0) + "%");
                                                }
                                            }, false);
                                            return xhr;
                                        },
                                        success: function (response) {
                                            const results = response.results;
                                            document.getElementById('uploaded_files_box').innerHTML = "";

                                            for (const result of results) {
                                                let arr = JSON.parse(result['server_response']);
                                                const code = arr.files[0].name;
                                                const name = arr.files[0].original_name;
                                                upld_fls_codes.push([code, name]);
                                            }

                                            for (const upld_fls_code of upld_fls_codes) {
                                                let tmp = `
                <button onclick="remove_file('${upld_fls_code[0]}')"
                    class="btn btn-label-primary waves-effect mt-2">
                    <span class="ti ti-x me-1"></span>
                    ${truncateWithDots(upld_fls_code[1])}
                </button>`;
                                                uploaded_files_box.innerHTML += tmp;
                                            }

                                            setTimeout(() => {
                                                document.getElementById('avatar_upload_progress').classList.add('d-none');
                                                document.getElementById('avatar_upload_progress_success').classList.remove('d-none');
                                                bootstrap.Modal.getOrCreateInstance(cameraModal).hide();
                                            }, 1000);
                                        },
                                        error: function () {
                                            alert("خطا در ارسال تصویر دوربین");
                                        }
                                    });
                                }

                            </script>
                            <style>
                                .camera-center {
                                    display: flex;
                                    justify-content: center; /* horizontal */
                                    align-items: center;     /* vertical */
                                    width: 100%;
                                    height: 100%;
                                }

                                #webcam,
                                #preview {
                                    width: 30%;
                                    aspect-ratio: 9 / 16;
                                    object-fit: cover;
                                    background: black;
                                    border-radius: 10px;
                                }
                            </style>
                            <div class="card mb-4" style="display: <?=$treatmentPlanTabDisplay?>">
                                <div class="table-responsive mb-3">
                                    <table class="table datatable-treatment-plans border-top">
                                        <thead>
                                        <tr>
                                            <th>ردیف</th>
                                            <th>دندان یا فک</th>
                                            <th>دندانپزشک</th>
                                            <th>درمان</th>
                                            <th>تاریخ ثبت</th>
                                            <th>تاریخ شروع</th>
                                            <th>تاریخ اتمام</th>
                                            <th>وضعیت</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                                <script>
                                    $(document).ready(function () {
                                        $('.datatable-treatment-plans').DataTable({
                                            processing: true,
                                            ajax: {
                                                url: '<?=ROOT?>functions/cases_funcs.php',
                                                type: 'POST',
                                                data: { action: 'load_treatments' , code: '<?=htmlspecialchars($patient_code)?>' },
                                                dataSrc: function(json) {
                                                    console.log("JSON response from server:", json); // <-- show the response
                                                    return json.data; // DataTables expects an array here
                                                },
                                                error: function(xhr, status, error) {
                                                    console.error("AJAX error:", status, error);
                                                    console.log("Response text:", xhr.responseText);
                                                }
                                            },
                                            columns: [
                                                { data: 'radif' },
                                                { data: 'tooth' },
                                                { data: 'dentist' },
                                                { data: 'service' },
                                                { data: 'created-date' },
                                                { data: 'start-date' },
                                                { data: 'finish-date' },
                                                { data: 'status' },
                                                { data: 'actions', orderable: false, searchable: false }
                                            ]
                                        });
                                    });
                                </script>
                            </div>
                            <div class="card mb-4" style="display: <?=$doneServicesTabDisplay?>">
                                <div class="table-responsive mb-3">
                                    <table class="table datatable-done-services border-top">
                                        <thead>
                                        <tr>
                                            <th>ردیف</th>
                                            <th>دندان یا فک</th>
                                            <th>دندانپزشک</th>
                                            <th>درمان</th>
                                            <th>تاریخ ثبت</th>
                                            <th>تاریخ شروع</th>
                                            <th>تاریخ اتمام</th>
                                            <th>وضعیت</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                                <script>
                                    $(document).ready(function () {
                                        $('.datatable-done-services').DataTable({
                                            processing: true,
                                            ajax: {
                                                url: '<?=ROOT?>functions/cases_funcs.php',
                                                type: 'POST',
                                                data: { action: 'load_done_services' , code: '<?=htmlspecialchars($patient_code)?>' },
                                                dataSrc: function(json) {
                                                    console.log("JSON response from server:", json); // <-- show the response
                                                    return json.data; // DataTables expects an array here
                                                },
                                                error: function(xhr, status, error) {
                                                    console.error("AJAX error:", status, error);
                                                    console.log("Response text:", xhr.responseText);
                                                }
                                            },
                                            columns: [
                                                { data: 'radif' },
                                                { data: 'tooth' },
                                                { data: 'dentist' },
                                                { data: 'service' },
                                                { data: 'created-date' },
                                                { data: 'start-date' },
                                                { data: 'finish-date' },
                                                { data: 'status' },
                                                { data: 'actions', orderable: false, searchable: false }
                                            ]
                                        });
                                    });
                                </script>
                            </div>
                            <?php
                            if($addTreatmentPlanActiveBtn == "active"){
                                ?>
                                <div class="card mb-4" style="display: <?=$addTreatmentPlanTabDisplay?>">
                                    <div class="row g-3 mt-2">
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h6 class="mt-5 text-center">انتخاب دندان یا فک</h6>
                                            <div class="large-6 columns chart">
                                                <div class="row">
                                                    <div class="position-relative d-flex justify-content-center align-items-center" style="height: 432px;">
                                                        <button id="secondarybtn" class="btn btn-primary" type="button" onclick="change_dentition(this)" style="position: absolute;top:45%;transform: translate(-50%, -50%);right: 0;">اصلی</button>
                                                        <button id="primarybtn" class="btn" type="button" onclick="change_dentition(this)" style="position: absolute;top:55%;transform: translate(-50%, -50%);right: 0;">شیری</button>
                                                        <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
                                                        <div style="margin-right: 100px;">
                                                            <button id="slctJawUBTN" class="btn btn-outline-primary" type="button" onclick="select_jaw(this,'u')" style="font-size: 12px;position: absolute;top: 30%;right: 50%;">کل فک بالا</button>
                                                            <button id="slctJawLBTN" class="btn btn-outline-primary" type="button" onclick="select_jaw(this,'l')" style="font-size: 12px;position: absolute;top: 60%;right: 49%;">کل فک پایین</button>
                                                            <div id="SecondaryDentition">
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="222" style="shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 395 371">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>

                                                                    <g>
                                                                        <path id="ur1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 170.5,16.5 C 176.176,16.3339 181.843,16.5006 187.5,17C 194.813,17.6524 197.313,21.4858 195,28.5C 191.465,54.1863 179.298,59.353 158.5,44C 154.248,40.4187 150.748,36.252 148,31.5C 146.707,27.4179 147.874,24.2513 151.5,22C 157.736,19.3625 164.069,17.5292 170.5,16.5 Z" />
                                                                        <text id="tur1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="170" y="35">1</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 206.5,16.5 C 218.151,15.7122 229.485,17.2122 240.5,21C 247.535,25.0465 248.369,30.2131 243,36.5C 236.929,43.2457 229.762,48.4123 221.5,52C 213.996,54.1593 208.163,51.9927 204,45.5C 200.074,37.6072 198.407,29.2739 199,20.5C 201.255,18.5012 203.755,17.1679 206.5,16.5 Z" />
                                                                        <text id="tul1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="220" y="35">1</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 136.5,32.5 C 140.516,31.8999 144.016,32.8999 147,35.5C 151.264,43.8106 152.264,52.4773 150,61.5C 146.345,68.0702 140.845,70.2368 133.5,68C 103.245,53.5208 104.245,41.6875 136.5,32.5 Z" />
                                                                        <text id="tur2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="140" y="50">2</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 250.5,32.5 C 262.156,32.8822 272.323,36.8822 281,44.5C 282.894,48.8494 282.227,52.8494 279,56.5C 272.387,62.9587 264.554,66.9587 255.5,68.5C 246.388,67.5425 242.055,62.3758 242.5,53C 242.947,48.4299 243.781,43.9299 245,39.5C 245.967,36.3794 247.8,34.046 250.5,32.5 Z" />
                                                                        <text id="tul2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="265" y="50">2</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 100.5,55.5 C 114.509,57.6616 124.342,65.3282 130,78.5C 130.956,82.572 130.456,86.4054 128.5,90C 118.12,93.3327 107.787,92.9994 97.5,89C 88.9226,83.3861 86.756,75.8861 91,66.5C 92.654,61.3576 95.8207,57.6909 100.5,55.5 Z" />
                                                                        <text id="tur3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="110" y="75">3</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 288.5,55.5 C 293.247,55.1357 297.081,56.8023 300,60.5C 304.379,67.452 305.712,74.7853 304,82.5C 294.496,90.9458 283.329,94.1125 270.5,92C 265.294,91.2621 262.961,88.2621 263.5,83C 263.517,79.6171 264.35,76.4505 266,73.5C 271.673,64.9703 279.173,58.9703 288.5,55.5 Z" />
                                                                        <text id="tul3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="285" y="75">3</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 94.5,90.5 C 106.243,98.3422 108.743,108.676 102,121.5C 97.5757,129.958 90.7423,132.791 81.5,130C 73.5614,127.391 67.3947,122.558 63,115.5C 59.0218,103.742 62.8551,95.9087 74.5,92C 81.3125,90.5394 87.9792,90.0394 94.5,90.5 Z" />
                                                                        <text id="tur4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="90" y="110">4</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 299.5,90.5 C 306.021,90.0394 312.688,90.5394 319.5,92C 331.145,95.9087 334.978,103.742 331,115.5C 323.988,126.922 313.822,131.755 300.5,130C 294.285,125.775 290.451,119.942 289,112.5C 287.41,102.681 290.91,95.3481 299.5,90.5 Z" />
                                                                        <text id="tul4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="305" y="110">4</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 61.5,127.5 C 86.831,126.631 95.331,137.964 87,161.5C 80.2346,171.502 71.0679,174.336 59.5,170C 44.2257,164.287 39.059,153.787 44,138.5C 48.5194,132.661 54.3527,128.995 61.5,127.5 Z" />
                                                                        <text id="tur5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="65" y="150">5</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 323.5,127.5 C 332.881,126.604 341.048,129.271 348,135.5C 355.609,148.351 353.109,158.851 340.5,167C 321.514,177.248 309.348,172.081 304,151.5C 302.052,144.135 303.885,137.968 309.5,133C 314.017,130.445 318.684,128.612 323.5,127.5 Z" />
                                                                        <text id="tul5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="330" y="150">5</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 50.5,171.5 C 56.5281,172.077 62.5281,172.911 68.5,174C 76.1223,175.999 78.6223,180.832 76,188.5C 74.1229,198.248 71.1229,207.582 67,216.5C 62.2191,219.363 57.0524,220.196 51.5,219C 44.0164,217.698 37.0164,215.031 30.5,211C 27.6107,205.879 26.7773,200.379 28,194.5C 29.0376,186.587 32.5376,180.087 38.5,175C 42.6227,173.808 46.6227,172.641 50.5,171.5 Z" />
                                                                        <text id="tur6" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="50" y="195">6</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 339.5,171.5 C 355.091,171.379 363.924,179.046 366,194.5C 368.888,205.903 364.721,213.07 353.5,216C 349.634,216.502 345.967,217.502 342.5,219C 337.232,220.068 332.232,219.401 327.5,217C 326.789,215.745 325.956,214.579 325,213.5C 320.902,202.119 318.568,190.452 318,178.5C 319.952,176.106 322.452,174.606 325.5,174C 330.315,173.197 334.981,172.363 339.5,171.5 Z" />
                                                                        <text id="tul6" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="340" y="195">6</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 31.5,219.5 C 42.8799,219.809 53.8799,221.976 64.5,226C 67.8575,228.693 69.1908,232.193 68.5,236.5C 68.037,245.877 67.2036,255.21 66,264.5C 63.538,270.487 59.038,273.654 52.5,274C 43.3932,274.793 34.3932,274.126 25.5,272C 22.0879,270.545 18.9212,268.712 16,266.5C 14.0771,263.456 13.2438,260.123 13.5,256.5C 13.8723,245.121 16.7056,234.454 22,224.5C 24.9074,222.132 28.0741,220.465 31.5,219.5 Z" />
                                                                        <text id="tur7" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="40" y="245">7</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 355.5,219.5 C 363.317,218.646 369.483,221.312 374,227.5C 378.702,238.714 380.702,250.381 380,262.5C 376.551,268.324 371.384,271.824 364.5,273C 355.152,274.869 345.819,274.869 336.5,273C 332.333,271.5 329.5,268.667 328,264.5C 326.395,253.217 325.728,241.884 326,230.5C 327.167,228 329,226.167 331.5,225C 339.5,222.57 347.5,220.737 355.5,219.5 Z" />
                                                                        <text id="tul7" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="355" y="245">7</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 14.5,278.5 C 24.8387,278.334 35.172,278.5 45.5,279C 52.5535,279.721 56.7202,283.554 58,290.5C 58.2785,296.957 59.2785,303.29 61,309.5C 63.2901,316.64 61.1234,321.807 54.5,325C 43.0487,328.264 31.3821,329.264 19.5,328C 10.3639,325.948 5.86392,320.114 6,310.5C 5.33333,303.5 5.33333,296.5 6,289.5C 6.8138,284.196 9.64713,280.529 14.5,278.5 Z" />
                                                                        <text id="tur8" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="30" y="300">8</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 348.5,278.5 C 358.839,278.334 369.172,278.5 379.5,279C 384.551,280.717 387.385,284.217 388,289.5C 389.042,299.635 388.375,309.635 386,319.5C 383.934,324.626 380.1,327.459 374.5,328C 362.618,329.264 350.951,328.264 339.5,325C 332.877,321.807 330.71,316.64 333,309.5C 334.661,301.894 335.994,294.227 337,286.5C 339.485,281.749 343.319,279.082 348.5,278.5 Z" />
                                                                        <text id="tul8" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="360" y="300">8</text>
                                                                    </g>

                                                                </svg>
                                                                <br>
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="222" style="margin-top: -36px;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 395 371">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>
                                                                    <!-- Rotated teeth paths -->
                                                                    <g transform="rotate(180 197.5 185.5)">
                                                                        <path id="ll1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 170.5,16.5 C 176.176,16.3339 181.843,16.5006 187.5,17C 194.813,17.6524 197.313,21.4858 195,28.5C 191.465,54.1863 179.298,59.353 158.5,44C 154.248,40.4187 150.748,36.252 148,31.5C 146.707,27.4179 147.874,24.2513 151.5,22C 157.736,19.3625 164.069,17.5292 170.5,16.5 Z" />
                                                                        <path id="lr1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 206.5,16.5 C 218.151,15.7122 229.485,17.2122 240.5,21C 247.535,25.0465 248.369,30.2131 243,36.5C 236.929,43.2457 229.762,48.4123 221.5,52C 213.996,54.1593 208.163,51.9927 204,45.5C 200.074,37.6072 198.407,29.2739 199,20.5C 201.255,18.5012 203.755,17.1679 206.5,16.5 Z" />
                                                                        <path id="ll2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 136.5,32.5 C 140.516,31.8999 144.016,32.8999 147,35.5C 151.264,43.8106 152.264,52.4773 150,61.5C 146.345,68.0702 140.845,70.2368 133.5,68C 103.245,53.5208 104.245,41.6875 136.5,32.5 Z" />
                                                                        <path id="lr2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 250.5,32.5 C 262.156,32.8822 272.323,36.8822 281,44.5C 282.894,48.8494 282.227,52.8494 279,56.5C 272.387,62.9587 264.554,66.9587 255.5,68.5C 246.388,67.5425 242.055,62.3758 242.5,53C 242.947,48.4299 243.781,43.9299 245,39.5C 245.967,36.3794 247.8,34.046 250.5,32.5 Z" />
                                                                        <path id="ll3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 100.5,55.5 C 114.509,57.6616 124.342,65.3282 130,78.5C 130.956,82.572 130.456,86.4054 128.5,90C 118.12,93.3327 107.787,92.9994 97.5,89C 88.9226,83.3861 86.756,75.8861 91,66.5C 92.654,61.3576 95.8207,57.6909 100.5,55.5 Z" />
                                                                        <path id="lr3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 288.5,55.5 C 293.247,55.1357 297.081,56.8023 300,60.5C 304.379,67.452 305.712,74.7853 304,82.5C 294.496,90.9458 283.329,94.1125 270.5,92C 265.294,91.2621 262.961,88.2621 263.5,83C 263.517,79.6171 264.35,76.4505 266,73.5C 271.673,64.9703 279.173,58.9703 288.5,55.5 Z" />
                                                                        <path id="ll4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 94.5,90.5 C 106.243,98.3422 108.743,108.676 102,121.5C 97.5757,129.958 90.7423,132.791 81.5,130C 73.5614,127.391 67.3947,122.558 63,115.5C 59.0218,103.742 62.8551,95.9087 74.5,92C 81.3125,90.5394 87.9792,90.0394 94.5,90.5 Z" />
                                                                        <path id="lr4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 299.5,90.5 C 306.021,90.0394 312.688,90.5394 319.5,92C 331.145,95.9087 334.978,103.742 331,115.5C 323.988,126.922 313.822,131.755 300.5,130C 294.285,125.775 290.451,119.942 289,112.5C 287.41,102.681 290.91,95.3481 299.5,90.5 Z" />
                                                                        <path id="ll5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 61.5,127.5 C 86.831,126.631 95.331,137.964 87,161.5C 80.2346,171.502 71.0679,174.336 59.5,170C 44.2257,164.287 39.059,153.787 44,138.5C 48.5194,132.661 54.3527,128.995 61.5,127.5 Z" />
                                                                        <path id="lr5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 323.5,127.5 C 332.881,126.604 341.048,129.271 348,135.5C 355.609,148.351 353.109,158.851 340.5,167C 321.514,177.248 309.348,172.081 304,151.5C 302.052,144.135 303.885,137.968 309.5,133C 314.017,130.445 318.684,128.612 323.5,127.5 Z" />
                                                                        <path id="ll6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 50.5,171.5 C 56.5281,172.077 62.5281,172.911 68.5,174C 76.1223,175.999 78.6223,180.832 76,188.5C 74.1229,198.248 71.1229,207.582 67,216.5C 62.2191,219.363 57.0524,220.196 51.5,219C 44.0164,217.698 37.0164,215.031 30.5,211C 27.6107,205.879 26.7773,200.379 28,194.5C 29.0376,186.587 32.5376,180.087 38.5,175C 42.6227,173.808 46.6227,172.641 50.5,171.5 Z" />
                                                                        <path id="lr6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 339.5,171.5 C 355.091,171.379 363.924,179.046 366,194.5C 368.888,205.903 364.721,213.07 353.5,216C 349.634,216.502 345.967,217.502 342.5,219C 337.232,220.068 332.232,219.401 327.5,217C 326.789,215.745 325.956,214.579 325,213.5C 320.902,202.119 318.568,190.452 318,178.5C 319.952,176.106 322.452,174.606 325.5,174C 330.315,173.197 334.981,172.363 339.5,171.5 Z" />
                                                                        <path id="ll7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 31.5,219.5 C 42.8799,219.809 53.8799,221.976 64.5,226C 67.8575,228.693 69.1908,232.193 68.5,236.5C 68.037,245.877 67.2036,255.21 66,264.5C 63.538,270.487 59.038,273.654 52.5,274C 43.3932,274.793 34.3932,274.126 25.5,272C 22.0879,270.545 18.9212,268.712 16,266.5C 14.0771,263.456 13.2438,260.123 13.5,256.5C 13.8723,245.121 16.7056,234.454 22,224.5C 24.9074,222.132 28.0741,220.465 31.5,219.5 Z" />
                                                                        <path id="lr7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 355.5,219.5 C 363.317,218.646 369.483,221.312 374,227.5C 378.702,238.714 380.702,250.381 380,262.5C 376.551,268.324 371.384,271.824 364.5,273C 355.152,274.869 345.819,274.869 336.5,273C 332.333,271.5 329.5,268.667 328,264.5C 326.395,253.217 325.728,241.884 326,230.5C 327.167,228 329,226.167 331.5,225C 339.5,222.57 347.5,220.737 355.5,219.5 Z" />
                                                                        <path id="ll8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 14.5,278.5 C 24.8387,278.334 35.172,278.5 45.5,279C 52.5535,279.721 56.7202,283.554 58,290.5C 58.2785,296.957 59.2785,303.29 61,309.5C 63.2901,316.64 61.1234,321.807 54.5,325C 43.0487,328.264 31.3821,329.264 19.5,328C 10.3639,325.948 5.86392,320.114 6,310.5C 5.33333,303.5 5.33333,296.5 6,289.5C 6.8138,284.196 9.64713,280.529 14.5,278.5 Z" />
                                                                        <path id="lr8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 348.5,278.5 C 358.839,278.334 369.172,278.5 379.5,279C 384.551,280.717 387.385,284.217 388,289.5C 389.042,299.635 388.375,309.635 386,319.5C 383.934,324.626 380.1,327.459 374.5,328C 362.618,329.264 350.951,328.264 339.5,325C 332.877,321.807 330.71,316.64 333,309.5C 334.661,301.894 335.994,294.227 337,286.5C 339.485,281.749 343.319,279.082 348.5,278.5 Z" />
                                                                    </g>

                                                                    <!-- Upright text labels -->
                                                                    <text id="tll1" onclick="tooth_select(document.getElementById('ll1'))" x="224.5" y="344.5" style="cursor:pointer;">1</text>
                                                                    <text id="tlr1" onclick="tooth_select(document.getElementById('lr1'))" x="174.5" y="344.5" style="cursor:pointer;">1</text>
                                                                    <text id="tll2" onclick="tooth_select(document.getElementById('ll2'))" x="260.5" y="328.5" style="cursor:pointer;">2</text>
                                                                    <text id="tlr2" onclick="tooth_select(document.getElementById('lr2'))" x="134.5" y="328.5" style="cursor:pointer;">2</text>
                                                                    <text id="tll3" onclick="tooth_select(document.getElementById('ll3'))" x="284.5" y="298.5" style="cursor:pointer;">3</text>
                                                                    <text id="tlr3" onclick="tooth_select(document.getElementById('lr3'))" x="110.5" y="298.5" style="cursor:pointer;">3</text>
                                                                    <text id="tll4" onclick="tooth_select(document.getElementById('ll4'))" x="310.5" y="260.5" style="cursor:pointer;">4</text>
                                                                    <text id="tlr4" onclick="tooth_select(document.getElementById('lr4'))" x="84.5" y="260.5" style="cursor:pointer;">4</text>
                                                                    <text id="tll5" onclick="tooth_select(document.getElementById('ll5'))" x="330.5" y="223.5" style="cursor:pointer;">5</text>
                                                                    <text id="tlr5" onclick="tooth_select(document.getElementById('lr5'))" x="64.5" y="223.5" style="cursor:pointer;">5</text>
                                                                    <text id="tll6" onclick="tooth_select(document.getElementById('ll6'))" x="344.5" y="180.5" style="cursor:pointer;">6</text>
                                                                    <text id="tlr6" onclick="tooth_select(document.getElementById('lr6'))" x="50.5" y="180.5" style="cursor:pointer;">6</text>
                                                                    <text id="tll7" onclick="tooth_select(document.getElementById('ll7'))" x="355.5" y="127.5" style="cursor:pointer;">7</text>
                                                                    <text id="tlr7" onclick="tooth_select(document.getElementById('lr7'))" x="39.5" y="127.5" style="cursor:pointer;">7</text>
                                                                    <text id="tll8" onclick="tooth_select(document.getElementById('ll8'))" x="365.5" y="71.5" style="cursor:pointer;">8</text>
                                                                    <text id="tlr8" onclick="tooth_select(document.getElementById('lr8'))" x="29.5" y="71.5" style="cursor:pointer;">8</text>
                                                                </svg>
                                                            </div>
                                                            <div id="PrimaryDentition" class="d-none">
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="161" style="z-index: 9999;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 237 161">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>

                                                                    <g>
                                                                        <path id="cur1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 101.5,12.5 C 107.061,11.8024 112.227,12.8024 117,15.5C 117.692,24.0905 115.192,31.5905 109.5,38C 98.9657,37.8431 91.1324,33.0097 86,23.5C 85.0799,20.6917 85.9133,18.5251 88.5,17C 92.8335,15.181 97.1668,13.681 101.5,12.5 Z"/>
                                                                        <text id="tcur1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="101" y="25">A</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 123.5,12.5 C 130.327,12.1241 136.994,12.9574 143.5,15C 146.249,16.1227 148.749,17.6227 151,19.5C 151.667,20.8333 151.667,22.1667 151,23.5C 146.737,29.7647 141.237,34.598 134.5,38C 130.495,39.0981 126.995,38.2648 124,35.5C 120.613,29.2317 119.28,22.565 120,15.5C 121.145,14.3636 122.312,13.3636 123.5,12.5 Z"/>
                                                                        <text id="tcul1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="135" y="25">A</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 75.5,21.5 C 77.8568,21.3367 80.1902,21.5034 82.5,22C 87.1827,28.4194 88.6827,35.586 87,43.5C 86.1667,45.6667 84.6667,47.1667 82.5,48C 79.0717,48.7011 75.7383,48.3677 72.5,47C 67.6977,44.1927 63.531,40.6927 60,36.5C 58.8238,32.7399 59.9904,29.9066 63.5,28C 67.4339,25.5361 71.4339,23.3694 75.5,21.5 Z"/>
                                                                        <text id="tcur2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="75" y="35">B</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 154.5,21.5 C 163.565,22.1165 171.065,25.7831 177,32.5C 177.667,33.8333 177.667,35.1667 177,36.5C 172.457,41.1866 167.291,45.02 161.5,48C 156.269,49.7238 152.435,48.2238 150,43.5C 148.255,35.3554 149.755,28.0221 154.5,21.5 Z"/>
                                                                        <text id="tcul2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="165" y="35">B</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 53.5,41.5 C 66.1955,41.0255 71.6955,47.0255 70,59.5C 69.0794,64.2609 66.246,66.5942 61.5,66.5C 52.1421,65.2939 44.6421,60.9606 39,53.5C 38.3131,51.0797 38.8131,48.913 40.5,47C 44.7239,44.7065 49.0572,42.8731 53.5,41.5 Z"/>
                                                                        <text id="tcur3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="55" y="55">C</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 174.5,41.5 C 181.446,41.7364 188.113,43.2364 194.5,46C 197.29,48.2103 198.123,51.0437 197,54.5C 190.087,62.8758 181.253,66.7092 170.5,66C 168.959,64.4207 167.792,62.5873 167,60.5C 164.359,51.8685 166.859,45.5352 174.5,41.5 Z"/>
                                                                        <text id="tcul3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="180" y="55">C</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 29.5,98.5 C 28.0697,97.4625 26.403,96.7959 24.5,96.5C 22.563,95.0686 20.7297,93.4019 19,91.5C 18.3333,89.1667 18.3333,86.8333 19,84.5C 22.5766,78.1077 25.5766,71.4411 28,64.5C 29.8333,62.6667 31.6667,60.8333 33.5,59C 35.5,58.3333 37.5,58.3333 39.5,59C 44.6037,61.7734 49.437,64.9401 54,68.5C 56.4839,80.0585 53.3172,89.8919 44.5,98C 39.5806,99.7781 34.5806,99.9448 29.5,98.5 Z"/>
                                                                        <text id="tcur4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="35" y="85">D</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 196.5,58.5 C 201.347,57.8404 205.181,59.5071 208,63.5C 211.397,71.7846 214.897,79.9513 218.5,88C 218.481,91.0334 217.148,93.3667 214.5,95C 207.87,98.4089 200.87,99.7422 193.5,99C 184.829,91.4893 180.662,81.9893 181,70.5C 185.784,65.8752 190.951,61.8752 196.5,58.5 Z"/>
                                                                        <text id="tcul4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="200" y="75">D</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 16.5,98.5 C 20.5483,98.3946 24.5483,98.7279 28.5,99.5C 32.6546,100.099 36.6546,101.265 40.5,103C 42.0412,104.579 43.2078,106.413 44,108.5C 42.4797,117.737 42.1464,127.07 43,136.5C 41.1667,141 38,144.167 33.5,146C 22.8381,148.532 13.6715,146.032 6,138.5C 4.94295,135.793 4.44295,132.96 4.5,130C 6.37616,122.313 7.54283,114.479 8,106.5C 9.44748,102.215 12.2808,99.5484 16.5,98.5 Z"/>
                                                                        <text id="tcur5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="20" y="120">E</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 214.5,97.5 C 220.957,96.9749 225.457,99.6416 228,105.5C 229.043,112.213 230.377,118.88 232,125.5C 233.968,138.209 228.468,145.042 215.5,146C 197.04,147.979 190.04,139.813 194.5,121.5C 190.959,114.151 191.959,107.651 197.5,102C 203.343,100.673 209.01,99.1727 214.5,97.5 Z"/>
                                                                        <text id="tcul5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="215" y="120">E</text>
                                                                    </g>
                                                                </svg>
                                                                <br>
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="161" style="margin-top: -20px;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 237 161">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>

                                                                    <!-- Rotated teeth paths -->
                                                                    <g transform="rotate(180 118.5 80.5)">
                                                                        <path id="cll1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 101.5,12.5 C 107.061,11.8024 112.227,12.8024 117,15.5C 117.692,24.0905 115.192,31.5905 109.5,38C 98.9657,37.8431 91.1324,33.0097 86,23.5C 85.0799,20.6917 85.9133,18.5251 88.5,17C 92.8335,15.181 97.1668,13.681 101.5,12.5 Z"/>
                                                                        <path id="clr1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 123.5,12.5 C 130.327,12.1241 136.994,12.9574 143.5,15C 146.249,16.1227 148.749,17.6227 151,19.5C 151.667,20.8333 151.667,22.1667 151,23.5C 146.737,29.7647 141.237,34.598 134.5,38C 130.495,39.0981 126.995,38.2648 124,35.5C 120.613,29.2317 119.28,22.565 120,15.5C 121.145,14.3636 122.312,13.3636 123.5,12.5 Z"/>
                                                                        <path id="cll2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 75.5,21.5 C 77.8568,21.3367 80.1902,21.5034 82.5,22C 87.1827,28.4194 88.6827,35.586 87,43.5C 86.1667,45.6667 84.6667,47.1667 82.5,48C 79.0717,48.7011 75.7383,48.3677 72.5,47C 67.6977,44.1927 63.531,40.6927 60,36.5C 58.8238,32.7399 59.9904,29.9066 63.5,28C 67.4339,25.5361 71.4339,23.3694 75.5,21.5 Z"/>
                                                                        <path id="clr2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 154.5,21.5 C 163.565,22.1165 171.065,25.7831 177,32.5C 177.667,33.8333 177.667,35.1667 177,36.5C 172.457,41.1866 167.291,45.02 161.5,48C 156.269,49.7238 152.435,48.2238 150,43.5C 148.255,35.3554 149.755,28.0221 154.5,21.5 Z"/>
                                                                        <path id="cll3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 53.5,41.5 C 66.1955,41.0255 71.6955,47.0255 70,59.5C 69.0794,64.2609 66.246,66.5942 61.5,66.5C 52.1421,65.2939 44.6421,60.9606 39,53.5C 38.3131,51.0797 38.8131,48.913 40.5,47C 44.7239,44.7065 49.0572,42.8731 53.5,41.5 Z"/>
                                                                        <path id="clr3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 174.5,41.5 C 181.446,41.7364 188.113,43.2364 194.5,46C 197.29,48.2103 198.123,51.0437 197,54.5C 190.087,62.8758 181.253,66.7092 170.5,66C 168.959,64.4207 167.792,62.5873 167,60.5C 164.359,51.8685 166.859,45.5352 174.5,41.5 Z"/>
                                                                        <path id="cll4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 29.5,98.5 C 28.0697,97.4625 26.403,96.7959 24.5,96.5C 22.563,95.0686 20.7297,93.4019 19,91.5C 18.3333,89.1667 18.3333,86.8333 19,84.5C 22.5766,78.1077 25.5766,71.4411 28,64.5C 29.8333,62.6667 31.6667,60.8333 33.5,59C 35.5,58.3333 37.5,58.3333 39.5,59C 44.6037,61.7734 49.437,64.9401 54,68.5C 56.4839,80.0585 53.3172,89.8919 44.5,98C 39.5806,99.7781 34.5806,99.9448 29.5,98.5 Z"/>
                                                                        <path id="clr4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 196.5,58.5 C 201.347,57.8404 205.181,59.5071 208,63.5C 211.397,71.7846 214.897,79.9513 218.5,88C 218.481,91.0334 217.148,93.3667 214.5,95C 207.87,98.4089 200.87,99.7422 193.5,99C 184.829,91.4893 180.662,81.9893 181,70.5C 185.784,65.8752 190.951,61.8752 196.5,58.5 Z"/>
                                                                        <path id="cll5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 16.5,98.5 C 20.5483,98.3946 24.5483,98.7279 28.5,99.5C 32.6546,100.099 36.6546,101.265 40.5,103C 42.0412,104.579 43.2078,106.413 44,108.5C 42.4797,117.737 42.1464,127.07 43,136.5C 41.1667,141 38,144.167 33.5,146C 22.8381,148.532 13.6715,146.032 6,138.5C 4.94295,135.793 4.44295,132.96 4.5,130C 6.37616,122.313 7.54283,114.479 8,106.5C 9.44748,102.215 12.2808,99.5484 16.5,98.5 Z"/>
                                                                        <path id="clr5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 214.5,97.5 C 220.957,96.9749 225.457,99.6416 228,105.5C 229.043,112.213 230.377,118.88 232,125.5C 233.968,138.209 228.468,145.042 215.5,146C 197.04,147.979 190.04,139.813 194.5,121.5C 190.959,114.151 191.959,107.651 197.5,102C 203.343,100.673 209.01,99.1727 214.5,97.5 Z"/>
                                                                    </g>

                                                                    <!-- Upright text labels -->
                                                                    <text id="tcll1" onclick="tooth_select(document.getElementById('cll1'))" x="135" y="140" style="cursor:pointer;">A</text>
                                                                    <text id="tclr1" onclick="tooth_select(document.getElementById('clr1'))" x="101" y="140" style="cursor:pointer;">A</text>
                                                                    <text id="tcll2" onclick="tooth_select(document.getElementById('cll2'))" x="165" y="130" style="cursor:pointer;">B</text>
                                                                    <text id="tclr2" onclick="tooth_select(document.getElementById('clr2'))" x="75" y="130" style="cursor:pointer;">B</text>
                                                                    <text id="tcll3" onclick="tooth_select(document.getElementById('cll3'))" x="180" y="110" style="cursor:pointer;">C</text>
                                                                    <text id="tclr3" onclick="tooth_select(document.getElementById('clr3'))" x="55" y="110" style="cursor:pointer;">C</text>
                                                                    <text id="tcll4" onclick="tooth_select(document.getElementById('cll4'))" x="200" y="80" style="cursor:pointer;">D</text>
                                                                    <text id="tclr4" onclick="tooth_select(document.getElementById('clr4'))" x="35" y="80" style="cursor:pointer;">D</text>
                                                                    <text id="tcll5" onclick="tooth_select(document.getElementById('cll5'))" x="215" y="40" style="cursor:pointer;">E</text>
                                                                    <text id="tclr5" onclick="tooth_select(document.getElementById('clr5'))" x="20" y="40" style="cursor:pointer;">E</text>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <script>
                                                            let selected_jaw = "";
                                                            function select_jaw(btn,jaw){
                                                                selected_teeth_5 = [];
                                                                if(btn.classList.contains('btn-primary')){
                                                                    //BARAYE IN K DANDUNAYE ENTEKHABI RESET BESHAN
                                                                    btn.classList.add('btn-outline-primary');
                                                                    btn.classList.remove('btn-primary');

                                                                    if(document.getElementById('slctJawUBTN').classList.contains('btn-outline-primary') && document.getElementById('slctJawLBTN').classList.contains('btn-outline-primary')){
                                                                        document.getElementById('SelectedJawText').style.display = "none";
                                                                        document.getElementById('dentChartSecondary').style.display = "none";
                                                                        document.getElementById('dentChartPrimary').style.display = "none";

                                                                        document.getElementById('SelectedJawText').innerHTML = "";
                                                                        document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                        document.getElementById('add-treatment-plan-box').classList.add('d-none');
                                                                    }
                                                                    else {
                                                                        if(document.getElementById('slctJawUBTN').classList.contains('btn-primary')){
                                                                            selected_teeth_5 = ["UPPERJAW"];
                                                                            document.getElementById('SelectedJawText').innerHTML = "کل فک بالا";
                                                                        }
                                                                        else {
                                                                            if(document.getElementById('slctJawLBTN').classList.contains('btn-primary')){
                                                                                selected_teeth_5 = ["LOWERJAW"];
                                                                                document.getElementById('SelectedJawText').innerHTML = "کل فک پایین";
                                                                            }
                                                                        }
                                                                    }

                                                                }
                                                                else {
                                                                    //BARAYE IN K DANDUNAYE ENTEKHABI RESET BESHAN

                                                                    ur = "";
                                                                    ul = "";
                                                                    lr = "";
                                                                    ll = "";

                                                                    cur = "";
                                                                    cul = "";
                                                                    clr = "";
                                                                    cll = "";

                                                                    document.getElementById('dentChartUpLeft').innerHTML = ul;
                                                                    document.getElementById('dentChartUpRight').innerHTML = ur;
                                                                    document.getElementById('dentChartLowLeft').innerHTML = ll;
                                                                    document.getElementById('dentChartLowRight').innerHTML = lr;

                                                                    document.getElementById('dentChartChildUpLeft').innerHTML = cul;
                                                                    document.getElementById('dentChartChildUpRight').innerHTML = cur;
                                                                    document.getElementById('dentChartChildLowLeft').innerHTML = cll;
                                                                    document.getElementById('dentChartChildLowRight').innerHTML = clr;

                                                                    var tmp45 = document.getElementsByTagName('path');
                                                                    for (const tmp45Element of tmp45) {
                                                                        $(tmp45Element).attr('fill','#ffffff');
                                                                        $(tmp45Element).attr('stroke','#000000');
                                                                        $('#t' + tmp45Element.id).css('fill','#000000');
                                                                    }
                                                                    document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.add('d-none');

                                                                    btn.classList.remove('btn-outline-primary');
                                                                    btn.classList.add('btn-primary');

                                                                    document.getElementById('SelectedJawText').style.display = "block";
                                                                    document.getElementById('dentChartSecondary').style.display = "none";
                                                                    document.getElementById('dentChartPrimary').style.display = "none";
                                                                    selected_teeth_5 = ["BOTHJAWS"];
                                                                    document.getElementById('SelectedJawText').innerHTML = "فک بالا و فک پایین";
                                                                    if(jaw === "u" && document.getElementById('slctJawLBTN').classList.contains('btn-outline-primary')){
                                                                        selected_teeth_5 = ["UPPERJAW"];
                                                                        document.getElementById('SelectedJawText').innerHTML = "کل فک بالا";
                                                                    }
                                                                    else{
                                                                        if(document.getElementById('slctJawUBTN').classList.contains('btn-outline-primary')){
                                                                            selected_teeth_5 = ["LOWERJAW"];
                                                                            document.getElementById('SelectedJawText').innerHTML = "کل فک پایین";
                                                                        }
                                                                    }
                                                                    document.getElementById('add-treatment-plan-message').classList.add('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.remove('d-none');
                                                                }
                                                                document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                            }
                                                            function change_dentition(btn){
                                                                if(selected_dentition === "SECONDARY"){
                                                                    document.getElementById('PrimaryDentition').classList.remove('d-none');
                                                                    document.getElementById('SecondaryDentition').classList.add('d-none');
                                                                    document.getElementById('secondarybtn').classList.remove('btn-primary');
                                                                    document.getElementById('primarybtn').classList.add('btn-primary');
                                                                    selected_dentition = "PRIMARY";
                                                                }
                                                                else {
                                                                    document.getElementById('PrimaryDentition').classList.add('d-none');
                                                                    document.getElementById('SecondaryDentition').classList.remove('d-none');
                                                                    document.getElementById('secondarybtn').classList.add('btn-primary');
                                                                    document.getElementById('primarybtn').classList.remove('btn-primary');
                                                                    selected_dentition = "SECONDARY";
                                                                }
                                                                document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                            }
                                                            function sort_dental_chart(text) {
                                                                return text.split('').sort().join('');
                                                            }
                                                            function sort_dental_chart_reverse(text) {
                                                                return text.split('').sort().reverse().join('');
                                                            }
                                                            var ur = "";
                                                            var ul = "";
                                                            var lr = "";
                                                            var ll = "";

                                                            var cur = "";
                                                            var cul = "";
                                                            var clr = "";
                                                            var cll = "";
                                                            var selected_teeth_5 = [];
                                                            var selected_dentition = "SECONDARY";
                                                            function tooth_select(tooth){
                                                                document.getElementById('SelectedJawText').style.display = "none";
                                                                document.getElementById('dentChartPrimary').style.display = "block";
                                                                document.getElementById('dentChartSecondary').style.display = "block";
                                                                document.getElementById('slctJawUBTN').classList.add('btn-outline-primary');
                                                                document.getElementById('slctJawUBTN').classList.remove('btn-primary');
                                                                document.getElementById('slctJawLBTN').classList.add('btn-outline-primary');
                                                                document.getElementById('slctJawLBTN').classList.remove('btn-primary');

                                                                if($(tooth).attr('fill') === "#ffffff"){
                                                                    $(tooth).attr('fill','#6236FF');
                                                                    $(tooth).attr('stroke','#6236FF');
                                                                    $('#t' + tooth.id).css('fill','#ffffff');
                                                                    //secondary dentition
                                                                    if(tooth.id[0] + tooth.id[1] === "ur"){
                                                                        ur += tooth.id[2];
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ul"){
                                                                        ul += tooth.id[2];
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "lr"){
                                                                        lr += tooth.id[2];
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ll"){
                                                                        ll += tooth.id[2];
                                                                    }
                                                                    //primary dentition
                                                                    if(tooth.id[1] + tooth.id[2] === "ur"){
                                                                        cur += tooth.id[3];
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ul"){
                                                                        cul += tooth.id[3];
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "lr"){
                                                                        clr += tooth.id[3];
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ll"){
                                                                        cll += tooth.id[3];
                                                                    }
                                                                }
                                                                else {
                                                                    $(tooth).attr('fill','#ffffff');
                                                                    $(tooth).attr('stroke','#000000');
                                                                    $('#t' + tooth.id).css('fill','#000000');

                                                                    //secondary dentition
                                                                    if(tooth.id[0] + tooth.id[1] === "ur"){
                                                                        ur = ur.replace(tooth.id[2],'');
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ul"){
                                                                        ul = ul.replace(tooth.id[2],'');
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "lr"){
                                                                        lr = lr.replace(tooth.id[2],'');
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ll"){
                                                                        ll = ll.replace(tooth.id[2],'');
                                                                    }
                                                                    //primary dentition
                                                                    if(tooth.id[1] + tooth.id[2] === "ur"){
                                                                        cur = cur.replace(tooth.id[3],'');
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ul"){
                                                                        cul = cul.replace(tooth.id[3],'');
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "lr"){
                                                                        clr = clr.replace(tooth.id[3],'');
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ll"){
                                                                        cll = cll.replace(tooth.id[3],'');
                                                                    }
                                                                }
                                                                ur = sort_dental_chart_reverse(ur);
                                                                ul = sort_dental_chart(ul);
                                                                lr = sort_dental_chart_reverse(lr);
                                                                ll = sort_dental_chart(ll);

                                                                cur = sort_dental_chart_reverse(cur);
                                                                cul = sort_dental_chart(cul);
                                                                clr = sort_dental_chart_reverse(clr);
                                                                cll = sort_dental_chart(cll);

                                                                document.getElementById('dentChartUpLeft').innerHTML = ul;
                                                                document.getElementById('dentChartUpRight').innerHTML = ur;
                                                                document.getElementById('dentChartLowLeft').innerHTML = ll;
                                                                document.getElementById('dentChartLowRight').innerHTML = lr;

                                                                function change_child_teeth_to_ABCD(text){
                                                                    text = text.replace('1','A');
                                                                    text = text.replace('2','B');
                                                                    text = text.replace('3','C');
                                                                    text = text.replace('4','D');
                                                                    text = text.replace('5','E');
                                                                    return text;
                                                                }
                                                                document.getElementById('dentChartChildUpLeft').innerHTML = change_child_teeth_to_ABCD(cul);
                                                                document.getElementById('dentChartChildUpRight').innerHTML = change_child_teeth_to_ABCD(cur);
                                                                document.getElementById('dentChartChildLowLeft').innerHTML = change_child_teeth_to_ABCD(cll);
                                                                document.getElementById('dentChartChildLowRight').innerHTML = change_child_teeth_to_ABCD(clr);

                                                                var arr_ur = ur.split('');
                                                                var arr_ul = ul.split('');
                                                                var arr_lr = lr.split('');
                                                                var arr_ll = ll.split('');

                                                                var arr_cur = cur.split('');
                                                                var arr_cul = cul.split('');
                                                                var arr_clr = clr.split('');
                                                                var arr_cll = cll.split('');
                                                                selected_teeth_5 = [];

                                                                for (const string of arr_ur) {
                                                                    selected_teeth_5.push('ur' + string);
                                                                }
                                                                for (const string of arr_ul) {
                                                                    selected_teeth_5.push('ul' + string);
                                                                }
                                                                for (const string of arr_lr) {
                                                                    selected_teeth_5.push('lr' + string);
                                                                }
                                                                for (const string of arr_ll) {
                                                                    selected_teeth_5.push('ll' + string);
                                                                }

                                                                for (const string of arr_cur) {
                                                                    selected_teeth_5.push('cur' + string);
                                                                }
                                                                for (const string of arr_cul) {
                                                                    selected_teeth_5.push('cul' + string);
                                                                }
                                                                for (const string of arr_clr) {
                                                                    selected_teeth_5.push('clr' + string);
                                                                }
                                                                for (const string of arr_cll) {
                                                                    selected_teeth_5.push('cll' + string);
                                                                }
                                                                if(ul === "" && ur === "" && ll === "" && lr === "" && cul === "" && cur === "" && cll === "" && clr === ""){
                                                                    document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.add('d-none');
                                                                }
                                                                else {
                                                                    if(ul !== "" || ur !== "" || ll !== "" || lr !== ""){
                                                                        document.getElementById('dentChartSecondary').style.display = 'block';
                                                                    }
                                                                    else {
                                                                        document.getElementById('dentChartSecondary').style.display = 'none';
                                                                    }
                                                                    if(cul !== "" || cur !== "" || cll !== "" || clr !== ""){
                                                                        document.getElementById('dentChartPrimary').style.display = 'block';
                                                                    }
                                                                    else {
                                                                        document.getElementById('dentChartPrimary').style.display = 'none';
                                                                    }
                                                                    document.getElementById('add-treatment-plan-message').classList.add('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.remove('d-none');
                                                                }
                                                                document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                            }
                                                        </script>
                                                        <style>
                                                            .rotate90 {
                                                                -webkit-transform: rotate(180deg);
                                                                -moz-transform: rotate(180deg);
                                                                -o-transform: rotate(180deg);
                                                                -ms-transform: rotate(180deg);
                                                                transform: rotate(180deg);
                                                            }
                                                        </style>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-8">
                                            <div class="container">
                                                <div class="row">
                                                    <label class="form-label">دندان های انتخاب شده</label>
                                                    <h6 id="add-treatment-plan-message">لطفا در ابتدا یک یا چند دندان را انتخاب نمایید</h6>
                                                    <div id="add-treatment-plan-box" class="d-none">
                                                        <div class="row p-3">
                                                            <div class="col-12">
                                                                <div class="row">
                                                                    <div id="dentChartSecondary" class="col-6 col-md-6 ">
                                                                        <h6>دندان های دائمی</h6>
                                                                        <table class="mt-3 mb-3">
                                                                            <tr>
                                                                                <td id="dentChartUpLeft" style="border-bottom: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td id="dentChartLeft">
                                                                                <td id="dentChartUpRight" style="border-bottom: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td id="dentChartLowLeft" style="border-top: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td>
                                                                                <td id="dentChartLowRight" style="border-top: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div id="dentChartPrimary" class="col-6 col-md-6 ">
                                                                        <h6>دندان های شیری</h6>
                                                                        <table class="mt-3 mb-3">
                                                                            <tr>
                                                                                <td id="dentChartChildUpLeft" style="border-bottom: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td id="dentChartLeft">
                                                                                <td id="dentChartChildUpRight" style="border-bottom: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td id="dentChartChildLowLeft" style="border-top: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td>
                                                                                <td id="dentChartChildLowRight" style="border-top: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>

                                                                </div>
                                                                <h6 id="SelectedJawText" class="mt-3 mb-3">فک بالا</h6>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <form id="add-treatment-plan-form" method="post" action="<?=ROOT . 'cases/' . $patient_code . '?tab=treatmentPlans'?>">
                                                    <div class="row">
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label">پزشک معاینه کننده*</label>
                                                            <!-- Dentist Selection Type -->
                                                            <div class="mb-2">
                                                                <div class="form-check form-check-inline">
                                                                    <input class="form-check-input" type="radio" name="dentist_selection_type" id="existing_dentist" value="existing" checked>
                                                                    <label class="form-check-label" for="existing_dentist">انتخاب پزشک</label>
                                                                </div>
                                                                <div class="form-check form-check-inline">
                                                                    <input class="form-check-input" type="radio" name="dentist_selection_type" id="manual_dentist" value="manual">
                                                                    <label class="form-check-label" for="manual_dentist">وارد کردن پزشک به صورت دلخواه</label>
                                                                </div>
                                                            </div>

                                                            <!-- Existing Dentist Dropdown -->
                                                            <div id="existing_dentist_container">
                                                                <select name="dentist_code" id="dentist_select" class="form-select" onchange="dentist_change(this)">
                                                                    <option value="">انتخاب کنید</option>
                                                                    <?php foreach ($dentists as $dentist): ?>
                                                                        <option data-cut="<?=$dentist['cut']?>" value="<?= htmlspecialchars($dentist['dentist_code']) ?>">
                                                                            <?= htmlspecialchars($dentist['dentist_fullname_encrypted']) ?>
                                                                        </option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </div>

                                                            <!-- Manual Dentist Input -->
                                                            <div id="manual_dentist_container" style="display: none;">
                                                                <input type="text" name="manual_dentist_name" id="manual_dentist_input" class="form-control" placeholder="نام پزشک معاینه کننده را وارد کنید">
                                                            </div>
                                                        </div>
                                                        <div class="row mt-2">
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label">درمان*</label>
                                                                <select name="service_code" id="services_select" class="form-select" onchange="treatment_change(this)" required>
                                                                    <option value="">انتخاب کنید</option>
                                                                    <?php
                                                                    foreach ($service_categories as $service_category){
                                                                        ?>
                                                                        <optgroup label="<?=$service_category['category_title'];?>">
                                                                            <?php
                                                                            foreach ($services as $service){
                                                                                if ($service['service_category_code'] == $service_category['service_category_code']){
                                                                                    ?>
                                                                                    <option value="<?=$service['service_code'];?>"><?=$service['service_title'];?></option>
                                                                                    <?php
                                                                                }
                                                                            }
                                                                            ?>
                                                                        </optgroup>
                                                                        <?php
                                                                    }
                                                                    ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="row mt-2">
                                                            <div class="row mt-2">
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label">هزینه (تومان)*</label>
                                                                    <input type="text" name="treatment_cost" id="treatment_cost" class="form-control" onkeyup="thousand_sepr(this);" placeholder="2,550,000" value="0">
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label">هزینه اضافی</label>
                                                                    <input type="text" name="additionalTreatment_cost" id="additionalTreatment_cost" onkeyup="thousand_sepr(this);" class="form-control" placeholder="550,000" value="0">
                                                                </div>
                                                                <div class="col-12 col-md-3 mt-2">
                                                                    <label class="form-label">سهم دندانپزشک (درصد)</label>
                                                                    <input type=number" name="dentist_cut_percentage" id="dentist_cut_percentage" class="form-control" onkeyup="dentist_cut_funcs(this);thousand_sepr(this);" placeholder="50" value="0">
                                                                </div>
                                                                <div class="col-12 col-md-3 mt-2">
                                                                    <label class="form-label">مقدار سهم دندانپزشک</label>
                                                                    <input type="text" name="dentist_cut_amount" id="dentist_cut_amount" onkeyup="dentist_cut_funcs(this);thousand_sepr(this);" class="form-control" placeholder="550,000" value="0">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <script>
                                                            function dentist_cut_funcs(input){
                                                                const treatment_cost = parseFloat(document.getElementById('treatment_cost').value.replaceAll(',',''));
                                                                const additionalTreatment_cost = parseFloat(document.getElementById('additionalTreatment_cost').value.replaceAll(',',''));
                                                                const dentist_cut_percentage = parseFloat(document.getElementById('dentist_cut_percentage').value.replaceAll(',',''));
                                                                const dentist_cut_amount = parseFloat(document.getElementById('dentist_cut_amount').value.replaceAll(',',''));
                                                                if(input.id === "dentist_cut_percentage"){
                                                                    document.getElementById('dentist_cut_amount').value = (treatment_cost + additionalTreatment_cost) * ((dentist_cut_percentage/100));
                                                                }
                                                                if(input.id === "dentist_cut_amount"){
                                                                    document.getElementById('dentist_cut_percentage').value = ((dentist_cut_amount)/(treatment_cost + additionalTreatment_cost))*100;
                                                                }
                                                                thousand_sepr(document.getElementById('dentist_cut_amount'));
                                                            }

                                                            function dentist_change(select){
                                                                const dentist_cut = select.selectedOptions[0].dataset.cut;
                                                                document.getElementById('dentist_cut_percentage').value = dentist_cut;
                                                                dentist_cut_funcs(document.getElementById('dentist_cut_percentage'));
                                                            }
                                                        </script>
                                                        <div class="row mt-2">
                                                            <div class="row mt-2">
                                                                <div class="col-12 mt-3">
                                                                    <label class="form-label">توضیحات</label>
                                                                    <textarea id="treatmentNote" name="treatmentNote" class="form-control" rows="4" placeholder="توضیحات تکمیلی در مورد طرح درمان را وارد کنید..."></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <input type="hidden" name="selected_teeth" id="selected_teeth_hidden">
                                                        <input type="hidden" name="selected_dentition" id="selected_dentition_hidden" value="PRIMARY">
                                                        <div class="row">
                                                            <div class="row p-1 pe-4 ps-4">
                                                                <button type="submit" id="" name="add-treatment-plan-submit" class="btn btn-primary mt-3 mb-3">ثبت طرح درمان</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php
                            }
                            ?>
                            <?php
                            if($addDoneServicesActiveBtn == "active"){
                                ?>
                                <div id="addDoneServicesBox" class="card mb-4" style="display: <?=$addDoneServicesTabDisplay?>">
                                    <div class="row g-3 mt-2">
                                        <div class="col-12 col-md-6 col-lg-4">
                                            <h6 class="mt-5 text-center">انتخاب دندان یا فک</h6>
                                            <div class="large-6 columns chart">
                                                <div class="row">
                                                    <div class="position-relative d-flex justify-content-center align-items-center" style="height: 432px;">
                                                        <button id="secondarybtn" class="btn btn-primary" type="button" onclick="change_dentition(this)" style="position: absolute;top:45%;transform: translate(-50%, -50%);right: 0;">اصلی</button>
                                                        <button id="primarybtn" class="btn" type="button" onclick="change_dentition(this)" style="position: absolute;top:55%;transform: translate(-50%, -50%);right: 0;">شیری</button>
                                                        <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
                                                        <div style="margin-right: 100px;">
                                                            <button id="slctJawUBTN" class="btn btn-outline-primary" type="button" onclick="select_jaw(this,'u')" style="font-size: 12px;position: absolute;top: 30%;right: 50%;">کل فک بالا</button>
                                                            <button id="slctJawLBTN" class="btn btn-outline-primary" type="button" onclick="select_jaw(this,'l')" style="font-size: 12px;position: absolute;top: 60%;right: 49%;">کل فک پایین</button>
                                                            <div id="SecondaryDentition">
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="222" style="shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 395 371">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>

                                                                    <g>
                                                                        <path id="ur1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 170.5,16.5 C 176.176,16.3339 181.843,16.5006 187.5,17C 194.813,17.6524 197.313,21.4858 195,28.5C 191.465,54.1863 179.298,59.353 158.5,44C 154.248,40.4187 150.748,36.252 148,31.5C 146.707,27.4179 147.874,24.2513 151.5,22C 157.736,19.3625 164.069,17.5292 170.5,16.5 Z" />
                                                                        <text id="tur1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="170" y="35">1</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 206.5,16.5 C 218.151,15.7122 229.485,17.2122 240.5,21C 247.535,25.0465 248.369,30.2131 243,36.5C 236.929,43.2457 229.762,48.4123 221.5,52C 213.996,54.1593 208.163,51.9927 204,45.5C 200.074,37.6072 198.407,29.2739 199,20.5C 201.255,18.5012 203.755,17.1679 206.5,16.5 Z" />
                                                                        <text id="tul1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="220" y="35">1</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 136.5,32.5 C 140.516,31.8999 144.016,32.8999 147,35.5C 151.264,43.8106 152.264,52.4773 150,61.5C 146.345,68.0702 140.845,70.2368 133.5,68C 103.245,53.5208 104.245,41.6875 136.5,32.5 Z" />
                                                                        <text id="tur2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="140" y="50">2</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 250.5,32.5 C 262.156,32.8822 272.323,36.8822 281,44.5C 282.894,48.8494 282.227,52.8494 279,56.5C 272.387,62.9587 264.554,66.9587 255.5,68.5C 246.388,67.5425 242.055,62.3758 242.5,53C 242.947,48.4299 243.781,43.9299 245,39.5C 245.967,36.3794 247.8,34.046 250.5,32.5 Z" />
                                                                        <text id="tul2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="265" y="50">2</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 100.5,55.5 C 114.509,57.6616 124.342,65.3282 130,78.5C 130.956,82.572 130.456,86.4054 128.5,90C 118.12,93.3327 107.787,92.9994 97.5,89C 88.9226,83.3861 86.756,75.8861 91,66.5C 92.654,61.3576 95.8207,57.6909 100.5,55.5 Z" />
                                                                        <text id="tur3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="110" y="75">3</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 288.5,55.5 C 293.247,55.1357 297.081,56.8023 300,60.5C 304.379,67.452 305.712,74.7853 304,82.5C 294.496,90.9458 283.329,94.1125 270.5,92C 265.294,91.2621 262.961,88.2621 263.5,83C 263.517,79.6171 264.35,76.4505 266,73.5C 271.673,64.9703 279.173,58.9703 288.5,55.5 Z" />
                                                                        <text id="tul3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="285" y="75">3</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 94.5,90.5 C 106.243,98.3422 108.743,108.676 102,121.5C 97.5757,129.958 90.7423,132.791 81.5,130C 73.5614,127.391 67.3947,122.558 63,115.5C 59.0218,103.742 62.8551,95.9087 74.5,92C 81.3125,90.5394 87.9792,90.0394 94.5,90.5 Z" />
                                                                        <text id="tur4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="90" y="110">4</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 299.5,90.5 C 306.021,90.0394 312.688,90.5394 319.5,92C 331.145,95.9087 334.978,103.742 331,115.5C 323.988,126.922 313.822,131.755 300.5,130C 294.285,125.775 290.451,119.942 289,112.5C 287.41,102.681 290.91,95.3481 299.5,90.5 Z" />
                                                                        <text id="tul4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="305" y="110">4</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 61.5,127.5 C 86.831,126.631 95.331,137.964 87,161.5C 80.2346,171.502 71.0679,174.336 59.5,170C 44.2257,164.287 39.059,153.787 44,138.5C 48.5194,132.661 54.3527,128.995 61.5,127.5 Z" />
                                                                        <text id="tur5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="65" y="150">5</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 323.5,127.5 C 332.881,126.604 341.048,129.271 348,135.5C 355.609,148.351 353.109,158.851 340.5,167C 321.514,177.248 309.348,172.081 304,151.5C 302.052,144.135 303.885,137.968 309.5,133C 314.017,130.445 318.684,128.612 323.5,127.5 Z" />
                                                                        <text id="tul5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="330" y="150">5</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 50.5,171.5 C 56.5281,172.077 62.5281,172.911 68.5,174C 76.1223,175.999 78.6223,180.832 76,188.5C 74.1229,198.248 71.1229,207.582 67,216.5C 62.2191,219.363 57.0524,220.196 51.5,219C 44.0164,217.698 37.0164,215.031 30.5,211C 27.6107,205.879 26.7773,200.379 28,194.5C 29.0376,186.587 32.5376,180.087 38.5,175C 42.6227,173.808 46.6227,172.641 50.5,171.5 Z" />
                                                                        <text id="tur6" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="50" y="195">6</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 339.5,171.5 C 355.091,171.379 363.924,179.046 366,194.5C 368.888,205.903 364.721,213.07 353.5,216C 349.634,216.502 345.967,217.502 342.5,219C 337.232,220.068 332.232,219.401 327.5,217C 326.789,215.745 325.956,214.579 325,213.5C 320.902,202.119 318.568,190.452 318,178.5C 319.952,176.106 322.452,174.606 325.5,174C 330.315,173.197 334.981,172.363 339.5,171.5 Z" />
                                                                        <text id="tul6" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="340" y="195">6</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 31.5,219.5 C 42.8799,219.809 53.8799,221.976 64.5,226C 67.8575,228.693 69.1908,232.193 68.5,236.5C 68.037,245.877 67.2036,255.21 66,264.5C 63.538,270.487 59.038,273.654 52.5,274C 43.3932,274.793 34.3932,274.126 25.5,272C 22.0879,270.545 18.9212,268.712 16,266.5C 14.0771,263.456 13.2438,260.123 13.5,256.5C 13.8723,245.121 16.7056,234.454 22,224.5C 24.9074,222.132 28.0741,220.465 31.5,219.5 Z" />
                                                                        <text id="tur7" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="40" y="245">7</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 355.5,219.5 C 363.317,218.646 369.483,221.312 374,227.5C 378.702,238.714 380.702,250.381 380,262.5C 376.551,268.324 371.384,271.824 364.5,273C 355.152,274.869 345.819,274.869 336.5,273C 332.333,271.5 329.5,268.667 328,264.5C 326.395,253.217 325.728,241.884 326,230.5C 327.167,228 329,226.167 331.5,225C 339.5,222.57 347.5,220.737 355.5,219.5 Z" />
                                                                        <text id="tul7" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="355" y="245">7</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 14.5,278.5 C 24.8387,278.334 35.172,278.5 45.5,279C 52.5535,279.721 56.7202,283.554 58,290.5C 58.2785,296.957 59.2785,303.29 61,309.5C 63.2901,316.64 61.1234,321.807 54.5,325C 43.0487,328.264 31.3821,329.264 19.5,328C 10.3639,325.948 5.86392,320.114 6,310.5C 5.33333,303.5 5.33333,296.5 6,289.5C 6.8138,284.196 9.64713,280.529 14.5,278.5 Z" />
                                                                        <text id="tur8" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="30" y="300">8</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 348.5,278.5 C 358.839,278.334 369.172,278.5 379.5,279C 384.551,280.717 387.385,284.217 388,289.5C 389.042,299.635 388.375,309.635 386,319.5C 383.934,324.626 380.1,327.459 374.5,328C 362.618,329.264 350.951,328.264 339.5,325C 332.877,321.807 330.71,316.64 333,309.5C 334.661,301.894 335.994,294.227 337,286.5C 339.485,281.749 343.319,279.082 348.5,278.5 Z" />
                                                                        <text id="tul8" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="360" y="300">8</text>
                                                                    </g>

                                                                </svg>
                                                                <br>
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="222" style="margin-top: -36px;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 395 371">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>
                                                                    <!-- Rotated teeth paths -->
                                                                    <g transform="rotate(180 197.5 185.5)">
                                                                        <path id="ll1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 170.5,16.5 C 176.176,16.3339 181.843,16.5006 187.5,17C 194.813,17.6524 197.313,21.4858 195,28.5C 191.465,54.1863 179.298,59.353 158.5,44C 154.248,40.4187 150.748,36.252 148,31.5C 146.707,27.4179 147.874,24.2513 151.5,22C 157.736,19.3625 164.069,17.5292 170.5,16.5 Z" />
                                                                        <path id="lr1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 206.5,16.5 C 218.151,15.7122 229.485,17.2122 240.5,21C 247.535,25.0465 248.369,30.2131 243,36.5C 236.929,43.2457 229.762,48.4123 221.5,52C 213.996,54.1593 208.163,51.9927 204,45.5C 200.074,37.6072 198.407,29.2739 199,20.5C 201.255,18.5012 203.755,17.1679 206.5,16.5 Z" />
                                                                        <path id="ll2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 136.5,32.5 C 140.516,31.8999 144.016,32.8999 147,35.5C 151.264,43.8106 152.264,52.4773 150,61.5C 146.345,68.0702 140.845,70.2368 133.5,68C 103.245,53.5208 104.245,41.6875 136.5,32.5 Z" />
                                                                        <path id="lr2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 250.5,32.5 C 262.156,32.8822 272.323,36.8822 281,44.5C 282.894,48.8494 282.227,52.8494 279,56.5C 272.387,62.9587 264.554,66.9587 255.5,68.5C 246.388,67.5425 242.055,62.3758 242.5,53C 242.947,48.4299 243.781,43.9299 245,39.5C 245.967,36.3794 247.8,34.046 250.5,32.5 Z" />
                                                                        <path id="ll3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 100.5,55.5 C 114.509,57.6616 124.342,65.3282 130,78.5C 130.956,82.572 130.456,86.4054 128.5,90C 118.12,93.3327 107.787,92.9994 97.5,89C 88.9226,83.3861 86.756,75.8861 91,66.5C 92.654,61.3576 95.8207,57.6909 100.5,55.5 Z" />
                                                                        <path id="lr3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 288.5,55.5 C 293.247,55.1357 297.081,56.8023 300,60.5C 304.379,67.452 305.712,74.7853 304,82.5C 294.496,90.9458 283.329,94.1125 270.5,92C 265.294,91.2621 262.961,88.2621 263.5,83C 263.517,79.6171 264.35,76.4505 266,73.5C 271.673,64.9703 279.173,58.9703 288.5,55.5 Z" />
                                                                        <path id="ll4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 94.5,90.5 C 106.243,98.3422 108.743,108.676 102,121.5C 97.5757,129.958 90.7423,132.791 81.5,130C 73.5614,127.391 67.3947,122.558 63,115.5C 59.0218,103.742 62.8551,95.9087 74.5,92C 81.3125,90.5394 87.9792,90.0394 94.5,90.5 Z" />
                                                                        <path id="lr4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 299.5,90.5 C 306.021,90.0394 312.688,90.5394 319.5,92C 331.145,95.9087 334.978,103.742 331,115.5C 323.988,126.922 313.822,131.755 300.5,130C 294.285,125.775 290.451,119.942 289,112.5C 287.41,102.681 290.91,95.3481 299.5,90.5 Z" />
                                                                        <path id="ll5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 61.5,127.5 C 86.831,126.631 95.331,137.964 87,161.5C 80.2346,171.502 71.0679,174.336 59.5,170C 44.2257,164.287 39.059,153.787 44,138.5C 48.5194,132.661 54.3527,128.995 61.5,127.5 Z" />
                                                                        <path id="lr5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 323.5,127.5 C 332.881,126.604 341.048,129.271 348,135.5C 355.609,148.351 353.109,158.851 340.5,167C 321.514,177.248 309.348,172.081 304,151.5C 302.052,144.135 303.885,137.968 309.5,133C 314.017,130.445 318.684,128.612 323.5,127.5 Z" />
                                                                        <path id="ll6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 50.5,171.5 C 56.5281,172.077 62.5281,172.911 68.5,174C 76.1223,175.999 78.6223,180.832 76,188.5C 74.1229,198.248 71.1229,207.582 67,216.5C 62.2191,219.363 57.0524,220.196 51.5,219C 44.0164,217.698 37.0164,215.031 30.5,211C 27.6107,205.879 26.7773,200.379 28,194.5C 29.0376,186.587 32.5376,180.087 38.5,175C 42.6227,173.808 46.6227,172.641 50.5,171.5 Z" />
                                                                        <path id="lr6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 339.5,171.5 C 355.091,171.379 363.924,179.046 366,194.5C 368.888,205.903 364.721,213.07 353.5,216C 349.634,216.502 345.967,217.502 342.5,219C 337.232,220.068 332.232,219.401 327.5,217C 326.789,215.745 325.956,214.579 325,213.5C 320.902,202.119 318.568,190.452 318,178.5C 319.952,176.106 322.452,174.606 325.5,174C 330.315,173.197 334.981,172.363 339.5,171.5 Z" />
                                                                        <path id="ll7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 31.5,219.5 C 42.8799,219.809 53.8799,221.976 64.5,226C 67.8575,228.693 69.1908,232.193 68.5,236.5C 68.037,245.877 67.2036,255.21 66,264.5C 63.538,270.487 59.038,273.654 52.5,274C 43.3932,274.793 34.3932,274.126 25.5,272C 22.0879,270.545 18.9212,268.712 16,266.5C 14.0771,263.456 13.2438,260.123 13.5,256.5C 13.8723,245.121 16.7056,234.454 22,224.5C 24.9074,222.132 28.0741,220.465 31.5,219.5 Z" />
                                                                        <path id="lr7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 355.5,219.5 C 363.317,218.646 369.483,221.312 374,227.5C 378.702,238.714 380.702,250.381 380,262.5C 376.551,268.324 371.384,271.824 364.5,273C 355.152,274.869 345.819,274.869 336.5,273C 332.333,271.5 329.5,268.667 328,264.5C 326.395,253.217 325.728,241.884 326,230.5C 327.167,228 329,226.167 331.5,225C 339.5,222.57 347.5,220.737 355.5,219.5 Z" />
                                                                        <path id="ll8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 14.5,278.5 C 24.8387,278.334 35.172,278.5 45.5,279C 52.5535,279.721 56.7202,283.554 58,290.5C 58.2785,296.957 59.2785,303.29 61,309.5C 63.2901,316.64 61.1234,321.807 54.5,325C 43.0487,328.264 31.3821,329.264 19.5,328C 10.3639,325.948 5.86392,320.114 6,310.5C 5.33333,303.5 5.33333,296.5 6,289.5C 6.8138,284.196 9.64713,280.529 14.5,278.5 Z" />
                                                                        <path id="lr8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 348.5,278.5 C 358.839,278.334 369.172,278.5 379.5,279C 384.551,280.717 387.385,284.217 388,289.5C 389.042,299.635 388.375,309.635 386,319.5C 383.934,324.626 380.1,327.459 374.5,328C 362.618,329.264 350.951,328.264 339.5,325C 332.877,321.807 330.71,316.64 333,309.5C 334.661,301.894 335.994,294.227 337,286.5C 339.485,281.749 343.319,279.082 348.5,278.5 Z" />
                                                                    </g>

                                                                    <!-- Upright text labels -->
                                                                    <text id="tll1" onclick="tooth_select(document.getElementById('ll1'))" x="224.5" y="344.5" style="cursor:pointer;">1</text>
                                                                    <text id="tlr1" onclick="tooth_select(document.getElementById('lr1'))" x="174.5" y="344.5" style="cursor:pointer;">1</text>
                                                                    <text id="tll2" onclick="tooth_select(document.getElementById('ll2'))" x="260.5" y="328.5" style="cursor:pointer;">2</text>
                                                                    <text id="tlr2" onclick="tooth_select(document.getElementById('lr2'))" x="134.5" y="328.5" style="cursor:pointer;">2</text>
                                                                    <text id="tll3" onclick="tooth_select(document.getElementById('ll3'))" x="284.5" y="298.5" style="cursor:pointer;">3</text>
                                                                    <text id="tlr3" onclick="tooth_select(document.getElementById('lr3'))" x="110.5" y="298.5" style="cursor:pointer;">3</text>
                                                                    <text id="tll4" onclick="tooth_select(document.getElementById('ll4'))" x="310.5" y="260.5" style="cursor:pointer;">4</text>
                                                                    <text id="tlr4" onclick="tooth_select(document.getElementById('lr4'))" x="84.5" y="260.5" style="cursor:pointer;">4</text>
                                                                    <text id="tll5" onclick="tooth_select(document.getElementById('ll5'))" x="330.5" y="223.5" style="cursor:pointer;">5</text>
                                                                    <text id="tlr5" onclick="tooth_select(document.getElementById('lr5'))" x="64.5" y="223.5" style="cursor:pointer;">5</text>
                                                                    <text id="tll6" onclick="tooth_select(document.getElementById('ll6'))" x="344.5" y="180.5" style="cursor:pointer;">6</text>
                                                                    <text id="tlr6" onclick="tooth_select(document.getElementById('lr6'))" x="50.5" y="180.5" style="cursor:pointer;">6</text>
                                                                    <text id="tll7" onclick="tooth_select(document.getElementById('ll7'))" x="355.5" y="127.5" style="cursor:pointer;">7</text>
                                                                    <text id="tlr7" onclick="tooth_select(document.getElementById('lr7'))" x="39.5" y="127.5" style="cursor:pointer;">7</text>
                                                                    <text id="tll8" onclick="tooth_select(document.getElementById('ll8'))" x="365.5" y="71.5" style="cursor:pointer;">8</text>
                                                                    <text id="tlr8" onclick="tooth_select(document.getElementById('lr8'))" x="29.5" y="71.5" style="cursor:pointer;">8</text>
                                                                </svg>
                                                            </div>
                                                            <div id="PrimaryDentition" class="d-none">
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="161" style="z-index: 9999;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 237 161">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>

                                                                    <g>
                                                                        <path id="cur1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 101.5,12.5 C 107.061,11.8024 112.227,12.8024 117,15.5C 117.692,24.0905 115.192,31.5905 109.5,38C 98.9657,37.8431 91.1324,33.0097 86,23.5C 85.0799,20.6917 85.9133,18.5251 88.5,17C 92.8335,15.181 97.1668,13.681 101.5,12.5 Z"/>
                                                                        <text id="tcur1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="101" y="25">A</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 123.5,12.5 C 130.327,12.1241 136.994,12.9574 143.5,15C 146.249,16.1227 148.749,17.6227 151,19.5C 151.667,20.8333 151.667,22.1667 151,23.5C 146.737,29.7647 141.237,34.598 134.5,38C 130.495,39.0981 126.995,38.2648 124,35.5C 120.613,29.2317 119.28,22.565 120,15.5C 121.145,14.3636 122.312,13.3636 123.5,12.5 Z"/>
                                                                        <text id="tcul1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="135" y="25">A</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 75.5,21.5 C 77.8568,21.3367 80.1902,21.5034 82.5,22C 87.1827,28.4194 88.6827,35.586 87,43.5C 86.1667,45.6667 84.6667,47.1667 82.5,48C 79.0717,48.7011 75.7383,48.3677 72.5,47C 67.6977,44.1927 63.531,40.6927 60,36.5C 58.8238,32.7399 59.9904,29.9066 63.5,28C 67.4339,25.5361 71.4339,23.3694 75.5,21.5 Z"/>
                                                                        <text id="tcur2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="75" y="35">B</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 154.5,21.5 C 163.565,22.1165 171.065,25.7831 177,32.5C 177.667,33.8333 177.667,35.1667 177,36.5C 172.457,41.1866 167.291,45.02 161.5,48C 156.269,49.7238 152.435,48.2238 150,43.5C 148.255,35.3554 149.755,28.0221 154.5,21.5 Z"/>
                                                                        <text id="tcul2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="165" y="35">B</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 53.5,41.5 C 66.1955,41.0255 71.6955,47.0255 70,59.5C 69.0794,64.2609 66.246,66.5942 61.5,66.5C 52.1421,65.2939 44.6421,60.9606 39,53.5C 38.3131,51.0797 38.8131,48.913 40.5,47C 44.7239,44.7065 49.0572,42.8731 53.5,41.5 Z"/>
                                                                        <text id="tcur3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="55" y="55">C</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 174.5,41.5 C 181.446,41.7364 188.113,43.2364 194.5,46C 197.29,48.2103 198.123,51.0437 197,54.5C 190.087,62.8758 181.253,66.7092 170.5,66C 168.959,64.4207 167.792,62.5873 167,60.5C 164.359,51.8685 166.859,45.5352 174.5,41.5 Z"/>
                                                                        <text id="tcul3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="180" y="55">C</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 29.5,98.5 C 28.0697,97.4625 26.403,96.7959 24.5,96.5C 22.563,95.0686 20.7297,93.4019 19,91.5C 18.3333,89.1667 18.3333,86.8333 19,84.5C 22.5766,78.1077 25.5766,71.4411 28,64.5C 29.8333,62.6667 31.6667,60.8333 33.5,59C 35.5,58.3333 37.5,58.3333 39.5,59C 44.6037,61.7734 49.437,64.9401 54,68.5C 56.4839,80.0585 53.3172,89.8919 44.5,98C 39.5806,99.7781 34.5806,99.9448 29.5,98.5 Z"/>
                                                                        <text id="tcur4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="35" y="85">D</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 196.5,58.5 C 201.347,57.8404 205.181,59.5071 208,63.5C 211.397,71.7846 214.897,79.9513 218.5,88C 218.481,91.0334 217.148,93.3667 214.5,95C 207.87,98.4089 200.87,99.7422 193.5,99C 184.829,91.4893 180.662,81.9893 181,70.5C 185.784,65.8752 190.951,61.8752 196.5,58.5 Z"/>
                                                                        <text id="tcul4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="200" y="75">D</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 16.5,98.5 C 20.5483,98.3946 24.5483,98.7279 28.5,99.5C 32.6546,100.099 36.6546,101.265 40.5,103C 42.0412,104.579 43.2078,106.413 44,108.5C 42.4797,117.737 42.1464,127.07 43,136.5C 41.1667,141 38,144.167 33.5,146C 22.8381,148.532 13.6715,146.032 6,138.5C 4.94295,135.793 4.44295,132.96 4.5,130C 6.37616,122.313 7.54283,114.479 8,106.5C 9.44748,102.215 12.2808,99.5484 16.5,98.5 Z"/>
                                                                        <text id="tcur5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="20" y="120">E</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 214.5,97.5 C 220.957,96.9749 225.457,99.6416 228,105.5C 229.043,112.213 230.377,118.88 232,125.5C 233.968,138.209 228.468,145.042 215.5,146C 197.04,147.979 190.04,139.813 194.5,121.5C 190.959,114.151 191.959,107.651 197.5,102C 203.343,100.673 209.01,99.1727 214.5,97.5 Z"/>
                                                                        <text id="tcul5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="215" y="120">E</text>
                                                                    </g>
                                                                </svg>
                                                                <br>
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="161" style="margin-top: -20px;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 237 161">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>

                                                                    <!-- Rotated teeth paths -->
                                                                    <g transform="rotate(180 118.5 80.5)">
                                                                        <path id="cll1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 101.5,12.5 C 107.061,11.8024 112.227,12.8024 117,15.5C 117.692,24.0905 115.192,31.5905 109.5,38C 98.9657,37.8431 91.1324,33.0097 86,23.5C 85.0799,20.6917 85.9133,18.5251 88.5,17C 92.8335,15.181 97.1668,13.681 101.5,12.5 Z"/>
                                                                        <path id="clr1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 123.5,12.5 C 130.327,12.1241 136.994,12.9574 143.5,15C 146.249,16.1227 148.749,17.6227 151,19.5C 151.667,20.8333 151.667,22.1667 151,23.5C 146.737,29.7647 141.237,34.598 134.5,38C 130.495,39.0981 126.995,38.2648 124,35.5C 120.613,29.2317 119.28,22.565 120,15.5C 121.145,14.3636 122.312,13.3636 123.5,12.5 Z"/>
                                                                        <path id="cll2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 75.5,21.5 C 77.8568,21.3367 80.1902,21.5034 82.5,22C 87.1827,28.4194 88.6827,35.586 87,43.5C 86.1667,45.6667 84.6667,47.1667 82.5,48C 79.0717,48.7011 75.7383,48.3677 72.5,47C 67.6977,44.1927 63.531,40.6927 60,36.5C 58.8238,32.7399 59.9904,29.9066 63.5,28C 67.4339,25.5361 71.4339,23.3694 75.5,21.5 Z"/>
                                                                        <path id="clr2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 154.5,21.5 C 163.565,22.1165 171.065,25.7831 177,32.5C 177.667,33.8333 177.667,35.1667 177,36.5C 172.457,41.1866 167.291,45.02 161.5,48C 156.269,49.7238 152.435,48.2238 150,43.5C 148.255,35.3554 149.755,28.0221 154.5,21.5 Z"/>
                                                                        <path id="cll3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 53.5,41.5 C 66.1955,41.0255 71.6955,47.0255 70,59.5C 69.0794,64.2609 66.246,66.5942 61.5,66.5C 52.1421,65.2939 44.6421,60.9606 39,53.5C 38.3131,51.0797 38.8131,48.913 40.5,47C 44.7239,44.7065 49.0572,42.8731 53.5,41.5 Z"/>
                                                                        <path id="clr3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 174.5,41.5 C 181.446,41.7364 188.113,43.2364 194.5,46C 197.29,48.2103 198.123,51.0437 197,54.5C 190.087,62.8758 181.253,66.7092 170.5,66C 168.959,64.4207 167.792,62.5873 167,60.5C 164.359,51.8685 166.859,45.5352 174.5,41.5 Z"/>
                                                                        <path id="cll4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 29.5,98.5 C 28.0697,97.4625 26.403,96.7959 24.5,96.5C 22.563,95.0686 20.7297,93.4019 19,91.5C 18.3333,89.1667 18.3333,86.8333 19,84.5C 22.5766,78.1077 25.5766,71.4411 28,64.5C 29.8333,62.6667 31.6667,60.8333 33.5,59C 35.5,58.3333 37.5,58.3333 39.5,59C 44.6037,61.7734 49.437,64.9401 54,68.5C 56.4839,80.0585 53.3172,89.8919 44.5,98C 39.5806,99.7781 34.5806,99.9448 29.5,98.5 Z"/>
                                                                        <path id="clr4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 196.5,58.5 C 201.347,57.8404 205.181,59.5071 208,63.5C 211.397,71.7846 214.897,79.9513 218.5,88C 218.481,91.0334 217.148,93.3667 214.5,95C 207.87,98.4089 200.87,99.7422 193.5,99C 184.829,91.4893 180.662,81.9893 181,70.5C 185.784,65.8752 190.951,61.8752 196.5,58.5 Z"/>
                                                                        <path id="cll5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 16.5,98.5 C 20.5483,98.3946 24.5483,98.7279 28.5,99.5C 32.6546,100.099 36.6546,101.265 40.5,103C 42.0412,104.579 43.2078,106.413 44,108.5C 42.4797,117.737 42.1464,127.07 43,136.5C 41.1667,141 38,144.167 33.5,146C 22.8381,148.532 13.6715,146.032 6,138.5C 4.94295,135.793 4.44295,132.96 4.5,130C 6.37616,122.313 7.54283,114.479 8,106.5C 9.44748,102.215 12.2808,99.5484 16.5,98.5 Z"/>
                                                                        <path id="clr5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 214.5,97.5 C 220.957,96.9749 225.457,99.6416 228,105.5C 229.043,112.213 230.377,118.88 232,125.5C 233.968,138.209 228.468,145.042 215.5,146C 197.04,147.979 190.04,139.813 194.5,121.5C 190.959,114.151 191.959,107.651 197.5,102C 203.343,100.673 209.01,99.1727 214.5,97.5 Z"/>
                                                                    </g>

                                                                    <!-- Upright text labels -->
                                                                    <text id="tcll1" onclick="tooth_select(document.getElementById('cll1'))" x="135" y="140" style="cursor:pointer;">A</text>
                                                                    <text id="tclr1" onclick="tooth_select(document.getElementById('clr1'))" x="101" y="140" style="cursor:pointer;">A</text>
                                                                    <text id="tcll2" onclick="tooth_select(document.getElementById('cll2'))" x="165" y="130" style="cursor:pointer;">B</text>
                                                                    <text id="tclr2" onclick="tooth_select(document.getElementById('clr2'))" x="75" y="130" style="cursor:pointer;">B</text>
                                                                    <text id="tcll3" onclick="tooth_select(document.getElementById('cll3'))" x="180" y="110" style="cursor:pointer;">C</text>
                                                                    <text id="tclr3" onclick="tooth_select(document.getElementById('clr3'))" x="55" y="110" style="cursor:pointer;">C</text>
                                                                    <text id="tcll4" onclick="tooth_select(document.getElementById('cll4'))" x="200" y="80" style="cursor:pointer;">D</text>
                                                                    <text id="tclr4" onclick="tooth_select(document.getElementById('clr4'))" x="35" y="80" style="cursor:pointer;">D</text>
                                                                    <text id="tcll5" onclick="tooth_select(document.getElementById('cll5'))" x="215" y="40" style="cursor:pointer;">E</text>
                                                                    <text id="tclr5" onclick="tooth_select(document.getElementById('clr5'))" x="20" y="40" style="cursor:pointer;">E</text>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <script>
                                                            let selected_jaw = "";
                                                            function select_jaw(btn,jaw){
                                                                selected_teeth_5 = [];
                                                                if(btn.classList.contains('btn-primary')){
                                                                    //BARAYE IN K DANDUNAYE ENTEKHABI RESET BESHAN
                                                                    btn.classList.add('btn-outline-primary');
                                                                    btn.classList.remove('btn-primary');

                                                                    if(document.getElementById('slctJawUBTN').classList.contains('btn-outline-primary') && document.getElementById('slctJawLBTN').classList.contains('btn-outline-primary')){
                                                                        document.getElementById('SelectedJawText').style.display = "none";
                                                                        document.getElementById('dentChartSecondary').style.display = "none";
                                                                        document.getElementById('dentChartPrimary').style.display = "none";

                                                                        document.getElementById('SelectedJawText').innerHTML = "";
                                                                        document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                        document.getElementById('add-treatment-plan-box').classList.add('d-none');
                                                                    }
                                                                    else {
                                                                        if(document.getElementById('slctJawUBTN').classList.contains('btn-primary')){
                                                                            selected_teeth_5 = ["UPPERJAW"];
                                                                            document.getElementById('SelectedJawText').innerHTML = "کل فک بالا";
                                                                        }
                                                                        else {
                                                                            if(document.getElementById('slctJawLBTN').classList.contains('btn-primary')){
                                                                                selected_teeth_5 = ["LOWERJAW"];
                                                                                document.getElementById('SelectedJawText').innerHTML = "کل فک پایین";
                                                                            }
                                                                        }
                                                                    }

                                                                }
                                                                else {
                                                                    //BARAYE IN K DANDUNAYE ENTEKHABI RESET BESHAN

                                                                    ur = "";
                                                                    ul = "";
                                                                    lr = "";
                                                                    ll = "";

                                                                    cur = "";
                                                                    cul = "";
                                                                    clr = "";
                                                                    cll = "";

                                                                    document.getElementById('dentChartUpLeft').innerHTML = ul;
                                                                    document.getElementById('dentChartUpRight').innerHTML = ur;
                                                                    document.getElementById('dentChartLowLeft').innerHTML = ll;
                                                                    document.getElementById('dentChartLowRight').innerHTML = lr;

                                                                    document.getElementById('dentChartChildUpLeft').innerHTML = cul;
                                                                    document.getElementById('dentChartChildUpRight').innerHTML = cur;
                                                                    document.getElementById('dentChartChildLowLeft').innerHTML = cll;
                                                                    document.getElementById('dentChartChildLowRight').innerHTML = clr;

                                                                    var tmp45 = document.getElementsByTagName('path');
                                                                    for (const tmp45Element of tmp45) {
                                                                        $(tmp45Element).attr('fill','#ffffff');
                                                                        $(tmp45Element).attr('stroke','#000000');
                                                                        $('#t' + tmp45Element.id).css('fill','#000000');
                                                                    }
                                                                    document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.add('d-none');

                                                                    btn.classList.remove('btn-outline-primary');
                                                                    btn.classList.add('btn-primary');

                                                                    document.getElementById('SelectedJawText').style.display = "block";
                                                                    document.getElementById('dentChartSecondary').style.display = "none";
                                                                    document.getElementById('dentChartPrimary').style.display = "none";
                                                                    selected_teeth_5 = ["BOTHJAWS"];
                                                                    document.getElementById('SelectedJawText').innerHTML = "فک بالا و فک پایین";
                                                                    if(jaw === "u" && document.getElementById('slctJawLBTN').classList.contains('btn-outline-primary')){
                                                                        selected_teeth_5 = ["UPPERJAW"];
                                                                        document.getElementById('SelectedJawText').innerHTML = "کل فک بالا";
                                                                    }
                                                                    else{
                                                                        if(document.getElementById('slctJawUBTN').classList.contains('btn-outline-primary')){
                                                                            selected_teeth_5 = ["LOWERJAW"];
                                                                            document.getElementById('SelectedJawText').innerHTML = "کل فک پایین";
                                                                        }
                                                                    }
                                                                    document.getElementById('add-treatment-plan-message').classList.add('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.remove('d-none');
                                                                }
                                                                document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                            }
                                                            function change_dentition(btn){
                                                                if(selected_dentition === "SECONDARY"){
                                                                    document.getElementById('PrimaryDentition').classList.remove('d-none');
                                                                    document.getElementById('SecondaryDentition').classList.add('d-none');
                                                                    document.getElementById('secondarybtn').classList.remove('btn-primary');
                                                                    document.getElementById('primarybtn').classList.add('btn-primary');
                                                                    selected_dentition = "PRIMARY";
                                                                }
                                                                else {
                                                                    document.getElementById('PrimaryDentition').classList.add('d-none');
                                                                    document.getElementById('SecondaryDentition').classList.remove('d-none');
                                                                    document.getElementById('secondarybtn').classList.add('btn-primary');
                                                                    document.getElementById('primarybtn').classList.remove('btn-primary');
                                                                    selected_dentition = "SECONDARY";
                                                                }
                                                                document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                            }
                                                            function sort_dental_chart(text) {
                                                                return text.split('').sort().join('');
                                                            }
                                                            function sort_dental_chart_reverse(text) {
                                                                return text.split('').sort().reverse().join('');
                                                            }
                                                            var ur = "";
                                                            var ul = "";
                                                            var lr = "";
                                                            var ll = "";

                                                            var cur = "";
                                                            var cul = "";
                                                            var clr = "";
                                                            var cll = "";
                                                            var selected_teeth_5 = [];
                                                            var selected_dentition = "SECONDARY";
                                                            function tooth_select(tooth){
                                                                document.getElementById('SelectedJawText').style.display = "none";
                                                                document.getElementById('dentChartPrimary').style.display = "block";
                                                                document.getElementById('dentChartSecondary').style.display = "block";
                                                                document.getElementById('slctJawUBTN').classList.add('btn-outline-primary');
                                                                document.getElementById('slctJawUBTN').classList.remove('btn-primary');
                                                                document.getElementById('slctJawLBTN').classList.add('btn-outline-primary');
                                                                document.getElementById('slctJawLBTN').classList.remove('btn-primary');

                                                                if($(tooth).attr('fill') === "#ffffff"){
                                                                    $(tooth).attr('fill','#6236FF');
                                                                    $(tooth).attr('stroke','#6236FF');
                                                                    $('#t' + tooth.id).css('fill','#ffffff');
                                                                    //secondary dentition
                                                                    if(tooth.id[0] + tooth.id[1] === "ur"){
                                                                        ur += tooth.id[2];
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ul"){
                                                                        ul += tooth.id[2];
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "lr"){
                                                                        lr += tooth.id[2];
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ll"){
                                                                        ll += tooth.id[2];
                                                                    }
                                                                    //primary dentition
                                                                    if(tooth.id[1] + tooth.id[2] === "ur"){
                                                                        cur += tooth.id[3];
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ul"){
                                                                        cul += tooth.id[3];
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "lr"){
                                                                        clr += tooth.id[3];
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ll"){
                                                                        cll += tooth.id[3];
                                                                    }
                                                                }
                                                                else {
                                                                    $(tooth).attr('fill','#ffffff');
                                                                    $(tooth).attr('stroke','#000000');
                                                                    $('#t' + tooth.id).css('fill','#000000');

                                                                    //secondary dentition
                                                                    if(tooth.id[0] + tooth.id[1] === "ur"){
                                                                        ur = ur.replace(tooth.id[2],'');
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ul"){
                                                                        ul = ul.replace(tooth.id[2],'');
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "lr"){
                                                                        lr = lr.replace(tooth.id[2],'');
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ll"){
                                                                        ll = ll.replace(tooth.id[2],'');
                                                                    }
                                                                    //primary dentition
                                                                    if(tooth.id[1] + tooth.id[2] === "ur"){
                                                                        cur = cur.replace(tooth.id[3],'');
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ul"){
                                                                        cul = cul.replace(tooth.id[3],'');
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "lr"){
                                                                        clr = clr.replace(tooth.id[3],'');
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ll"){
                                                                        cll = cll.replace(tooth.id[3],'');
                                                                    }
                                                                }
                                                                ur = sort_dental_chart_reverse(ur);
                                                                ul = sort_dental_chart(ul);
                                                                lr = sort_dental_chart_reverse(lr);
                                                                ll = sort_dental_chart(ll);

                                                                cur = sort_dental_chart_reverse(cur);
                                                                cul = sort_dental_chart(cul);
                                                                clr = sort_dental_chart_reverse(clr);
                                                                cll = sort_dental_chart(cll);

                                                                document.getElementById('dentChartUpLeft').innerHTML = ul;
                                                                document.getElementById('dentChartUpRight').innerHTML = ur;
                                                                document.getElementById('dentChartLowLeft').innerHTML = ll;
                                                                document.getElementById('dentChartLowRight').innerHTML = lr;

                                                                function change_child_teeth_to_ABCD(text){
                                                                    text = text.replace('1','A');
                                                                    text = text.replace('2','B');
                                                                    text = text.replace('3','C');
                                                                    text = text.replace('4','D');
                                                                    text = text.replace('5','E');
                                                                    return text;
                                                                }
                                                                document.getElementById('dentChartChildUpLeft').innerHTML = change_child_teeth_to_ABCD(cul);
                                                                document.getElementById('dentChartChildUpRight').innerHTML = change_child_teeth_to_ABCD(cur);
                                                                document.getElementById('dentChartChildLowLeft').innerHTML = change_child_teeth_to_ABCD(cll);
                                                                document.getElementById('dentChartChildLowRight').innerHTML = change_child_teeth_to_ABCD(clr);

                                                                var arr_ur = ur.split('');
                                                                var arr_ul = ul.split('');
                                                                var arr_lr = lr.split('');
                                                                var arr_ll = ll.split('');

                                                                var arr_cur = cur.split('');
                                                                var arr_cul = cul.split('');
                                                                var arr_clr = clr.split('');
                                                                var arr_cll = cll.split('');
                                                                selected_teeth_5 = [];

                                                                for (const string of arr_ur) {
                                                                    selected_teeth_5.push('ur' + string);
                                                                }
                                                                for (const string of arr_ul) {
                                                                    selected_teeth_5.push('ul' + string);
                                                                }
                                                                for (const string of arr_lr) {
                                                                    selected_teeth_5.push('lr' + string);
                                                                }
                                                                for (const string of arr_ll) {
                                                                    selected_teeth_5.push('ll' + string);
                                                                }

                                                                for (const string of arr_cur) {
                                                                    selected_teeth_5.push('cur' + string);
                                                                }
                                                                for (const string of arr_cul) {
                                                                    selected_teeth_5.push('cul' + string);
                                                                }
                                                                for (const string of arr_clr) {
                                                                    selected_teeth_5.push('clr' + string);
                                                                }
                                                                for (const string of arr_cll) {
                                                                    selected_teeth_5.push('cll' + string);
                                                                }
                                                                if(ul === "" && ur === "" && ll === "" && lr === "" && cul === "" && cur === "" && cll === "" && clr === ""){
                                                                    document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.add('d-none');
                                                                }
                                                                else {
                                                                    if(ul !== "" || ur !== "" || ll !== "" || lr !== ""){
                                                                        document.getElementById('dentChartSecondary').style.display = 'block';
                                                                    }
                                                                    else {
                                                                        document.getElementById('dentChartSecondary').style.display = 'none';
                                                                    }
                                                                    if(cul !== "" || cur !== "" || cll !== "" || clr !== ""){
                                                                        document.getElementById('dentChartPrimary').style.display = 'block';
                                                                    }
                                                                    else {
                                                                        document.getElementById('dentChartPrimary').style.display = 'none';
                                                                    }
                                                                    document.getElementById('add-treatment-plan-message').classList.add('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.remove('d-none');
                                                                }
                                                                document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                            }
                                                        </script>
                                                        <style>
                                                            .rotate90 {
                                                                -webkit-transform: rotate(180deg);
                                                                -moz-transform: rotate(180deg);
                                                                -o-transform: rotate(180deg);
                                                                -ms-transform: rotate(180deg);
                                                                transform: rotate(180deg);
                                                            }
                                                        </style>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-8">
                                            <div class="container">
                                                <div class="row">
                                                    <label class="form-label">دندان های انتخاب شده</label>
                                                    <h6 id="add-treatment-plan-message">لطفا در ابتدا یک یا چند دندان را انتخاب نمایید</h6>
                                                    <div id="add-treatment-plan-box" class="d-none">
                                                        <div class="row p-3">
                                                            <div class="col-12">
                                                                <div class="row">
                                                                    <div id="dentChartSecondary" class="col-6 col-md-6 ">
                                                                        <h6>دندان های دائمی</h6>
                                                                        <table class="mt-3 mb-3">
                                                                            <tr>
                                                                                <td id="dentChartUpLeft" style="border-bottom: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td id="dentChartLeft">
                                                                                <td id="dentChartUpRight" style="border-bottom: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td id="dentChartLowLeft" style="border-top: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td>
                                                                                <td id="dentChartLowRight" style="border-top: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div id="dentChartPrimary" class="col-6 col-md-6 ">
                                                                        <h6>دندان های شیری</h6>
                                                                        <table class="mt-3 mb-3">
                                                                            <tr>
                                                                                <td id="dentChartChildUpLeft" style="border-bottom: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td id="dentChartLeft">
                                                                                <td id="dentChartChildUpRight" style="border-bottom: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td id="dentChartChildLowLeft" style="border-top: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td>
                                                                                <td id="dentChartChildLowRight" style="border-top: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>

                                                                </div>
                                                                <h6 id="SelectedJawText" class="mt-3 mb-3">فک بالا</h6>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php
                                                $service2 = "NOTAPPLICATED";
                                                $service2 = "NOTAPPLICATED";
                                                if(isset($_GET['treatment-plan'])){
                                                    $treatment_code2 = $_GET['treatment-plan'];
                                                    $stmt = $pdo->prepare("
                                                        SELECT *
                                                        FROM treatments
                                                        WHERE clinic_code = :office_code
                                                          AND patient_code = :patient_code AND treatment_code = :treatment_code
                                                    ");
                                                    $stmt->execute([':office_code' => $officeCode, ':patient_code' => $patient_code,':treatment_code' => $treatment_code2]);
                                                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                                                }
                                                ?>
                                                <form id="add-done-services-form" method="post" action="<?=ROOT . 'cases/' . $patient_code . '?tab=doneServices'?>">
                                                    <div class="row">
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label">پزشک معالج*</label>
                                                            <!-- Dentist Selection Type -->
                                                            <div class="mb-2">
                                                                <div class="form-check form-check-inline">
                                                                    <input class="form-check-input" type="radio" name="dentist_selection_type" id="existing_dentist" value="existing" checked>
                                                                    <label class="form-check-label" for="existing_dentist">انتخاب پزشک</label>
                                                                </div>
                                                                <div class="form-check form-check-inline">
                                                                    <input class="form-check-input" type="radio" name="dentist_selection_type" id="manual_dentist" value="manual">
                                                                    <label class="form-check-label" for="manual_dentist">وارد کردن پزشک به صورت دلخواه</label>
                                                                </div>
                                                            </div>

                                                            <!-- Existing Dentist Dropdown -->
                                                            <div id="existing_dentist_container">
                                                                <select name="dentist_code" id="dentist_select" class="form-select" onchange="dentist_change(this)">
                                                                    <option value="">انتخاب کنید</option>
                                                                    <?php foreach ($dentists as $dentist): ?>
                                                                        <option data-cut="<?=$dentist['cut']?>" value="<?= htmlspecialchars($dentist['dentist_code']) ?>">
                                                                            <?= htmlspecialchars($dentist['dentist_fullname_encrypted']) ?>
                                                                        </option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </div>

                                                            <!-- Manual Dentist Input -->
                                                            <div id="manual_dentist_container" style="display: none;">
                                                                <input type="text" name="manual_dentist_name" id="manual_dentist_input" class="form-control" placeholder="نام پزشک معالج را وارد کنید">
                                                            </div>
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <label class="form-label" for="paymentTime">تاریخ شروع درمان</label>
                                                                    <input class="form-control bdi flatpickr-input active" name="start-date" id="flatpickr-datetime2" placeholder="YYYY-MM-DD HH:MM" type="text" readonly="readonly">
                                                                </div>
                                                                <div class="col-12">
                                                                    <label class="form-label" for="paymentTime">تاریخ آخرین جلسه</label>
                                                                    <input class="form-control bdi flatpickr-input active" name="last-date" id="flatpickr-datetime3" placeholder="YYYY-MM-DD HH:MM" type="text" readonly="readonly">
                                                                </div>
                                                            </div>
                                                            <label class="form-label">وضعیت درمان*</label><br>
                                                            <button onclick="done_services_status(this)" type="button" class="doneServicesStatusBtn btn btn-primary waves-effect mt-2" data-status="NOTDONE">ناتمام</button>
                                                            <button onclick="done_services_status(this)" type="button" class="doneServicesStatusBtn btn btn-outline-primary waves-effect mt-2" data-status="MIDTREATMENT">حین درمان</button>
                                                            <button onclick="done_services_status(this)" type="button" class="doneServicesStatusBtn btn btn-outline-primary waves-effect mt-2" data-status="DONE">تمام شده</button>
                                                            <button onclick="done_services_status(this)" type="button" class="doneServicesStatusBtn btn btn-outline-primary waves-effect mt-2" data-status="CANCELED">کنسل شده</button>
                                                            <button onclick="done_services_status(this)" type="button" class="doneServicesStatusBtn btn btn-outline-primary waves-effect mt-2" data-status="REFERED">ارجاع</button>
                                                        </div>
                                                        <input type="text" id="statusInput" name="statusInput" value="NOTDONE" hidden="hidden" />
                                                        <script>
                                                            function done_services_status(btn){
                                                                const btns = document.getElementsByClassName('doneServicesStatusBtn');
                                                                for (const btn1 of btns) {
                                                                    btn1.classList.remove('btn-primary');
                                                                    btn1.classList.add('btn-outline-primary');
                                                                }
                                                                btn.classList.add('btn-primary');
                                                                btn.classList.remove('btn-outline-primary');
                                                                document.getElementById('statusInput').value = btn.dataset.status;
                                                            }
                                                        </script>
                                                        <div class="row mt-2">
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label">درمان*</label>
                                                                <select name="service_code" id="services_select" class="form-select" onchange="treatment_change(this);update_costs();" required>
                                                                    <option value="">انتخاب کنید</option>
                                                                    <?php
                                                                    foreach ($service_categories as $service_category){
                                                                        ?>
                                                                        <optgroup label="<?=$service_category['category_title'];?>">
                                                                            <?php
                                                                            foreach ($services as $service){
                                                                                if ($service['service_category_code'] == $service_category['service_category_code']){
                                                                                    ?>
                                                                                    <option value="<?=$service['service_code'];?>"><?=$service['service_title'];?></option>
                                                                                    <?php
                                                                                }
                                                                            }
                                                                            ?>
                                                                        </optgroup>
                                                                        <?php
                                                                    }
                                                                    ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <hr class="mt-3">
                                                        <div class="row mt-1">
                                                            <h6>
                                                                هزینه ها
                                                            </h6>

                                                            <div class="row mt-2">
                                                                <div class="col-12 col-md-6">
                                                                    <div class="col-12">
                                                                        <label class="form-label">هزینه (تومان)*</label>
                                                                        <input type="text" name="treatment_cost" id="treatment_cost" class="form-control" onkeyup="thousand_sepr(this);update_costs();" placeholder="2,550,000" value="0">
                                                                    </div>
                                                                    <div class="col-12">
                                                                        <label class="form-label">هزینه اضافی</label>
                                                                        <input type="text" name="additionalTreatment_cost" id="additionalTreatment_cost" onkeyup="thousand_sepr(this);update_costs();" class="form-control" placeholder="550,000" value="0">
                                                                    </div>
                                                                    <div class="col-12">
                                                                        <label class="form-label">سهم بیمار</label>
                                                                        <input type="text" name="patientPrimary_cost" id="patientPrimary_cost" onkeyup="thousand_sepr(this);" class="form-control" value="0" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <div class="row">
                                                                        <div class="col-6">
                                                                            <label class="form-label">تخفیف مجموعه(درصد)</label>
                                                                            <input type="text" name="clinicDiscount" id="clinicDiscount" onkeyup="update_costs();" class="form-control" placeholder="10" value="0">
                                                                        </div>
                                                                        <div class="col-6" style="padding-top: 36px;">
                                                                            <span id="clinicDiscountAmount">0</span> تومان
                                                                        </div>
                                                                        <div class="col-6">
                                                                            <label class="form-label">تخفیف دندانپزشک(درصد)</label>
                                                                            <input type="text" name="dentistDiscount" id="dentistDiscount" onkeyup="update_costs();" class="form-control" placeholder="10" value="0">
                                                                        </div>
                                                                        <div class="col-6" style="padding-top: 36px;">
                                                                            <span id="dentistDiscountAmount">0</span> تومان
                                                                        </div>
                                                                        <div class="col-12">
                                                                            <label class="form-label">قابل پرداخت</label>
                                                                            <input type="text" name="patientFinal_cost" id="patientFinal_cost" class="form-control" placeholder="550,000" value="0" readonly>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <input type="text" id="paidJson" name="paidJson" value="[]" hidden="hidden" />
                                                        <!--
                                                        <hr class="mt-3">
                                                        <div class="row mt-1">
                                                            <div class="row mt-2">
                                                                <h6>
                                                                    پرداخت بیمار
                                                                </h6>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label">باقی مانده</label>
                                                                    <input type="text" name="patientDept" id="patientDept" class="form-control" placeholder="550,000" value="0" disabled>
                                                                </div>
                                                                <h6 class="mt-3">
                                                                    افزودن پرداخت
                                                                </h6>
                                                                <div class="col-12">
                                                                    <div class="row">
                                                                        <div class="col-3">
                                                                            <label class="form-label" for="paymentAmount">مقدار (تومان)</label>
                                                                            <input class="form-control" id="paymentAmount" onkeyup="thousand_sepr(this)" placeholder="550,000"/>
                                                                        </div>
                                                                        <div class="col-4">
                                                                            <label class="form-label" for="paymentMethod">روش</label>
                                                                            <select class="form-control" id="paymentMethod">
                                                                                <option value="NA">انتخاب کنید.</option>
                                                                                <option value="کارتخوان">کارتخوان</option>
                                                                                <option value="کارت به کارت">کارت به کارت</option>
                                                                                <option value="دلار">به صورت دلار</option>
                                                                                <option value="یورو">به صورت یورو</option>
                                                                                <option value="دینار">به صورت دینار</option>
                                                                                <option value="درهم">به صورت درهم</option>
                                                                                <option value="سایر">سایر</option>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-3">
                                                                            <label class="form-label" for="paymentTime">زمان پرداخت</label>
                                                                            <input class="form-control bdi flatpickr-input active" id="flatpickr-datetime" placeholder="YYYY-MM-DD HH:MM" type="text" readonly="readonly">
                                                                        </div>
                                                                        <div class="col-2" style="padding-top: 28px;">
                                                                            <button class="btn btn-primary" type="button" onclick="add_payment()">+</button>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-12 pe-4 ps-4" id="paymentsBox">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        -->
                                                        <script>
                                                            let paid = 0;
                                                            let payments = [];
                                                            function update_costs(){
                                                                let treatment_cost = parseFloat(document.getElementById('treatment_cost').value.replaceAll(',',''));
                                                                let additionalTreatment_cost = parseFloat(document.getElementById('additionalTreatment_cost').value.replaceAll(',',''));
                                                                let clinicDiscount = parseFloat(document.getElementById('clinicDiscount').value.replaceAll(',',''));
                                                                let dentistDiscount = parseFloat(document.getElementById('dentistDiscount').value.replaceAll(',',''));

                                                                let patientFinal_cost = document.getElementById('patientFinal_cost');
                                                                let patientPrimary_cost = document.getElementById('patientPrimary_cost');
                                                                let clinicDiscountAmount = document.getElementById('clinicDiscountAmount');
                                                                let dentistDiscountAmount = document.getElementById('dentistDiscountAmount');

                                                                clinicDiscountAmount.innerHTML = ((clinicDiscount / 100)*(treatment_cost + additionalTreatment_cost))
                                                                dentistDiscountAmount.innerHTML = ((dentistDiscount / 100)*(treatment_cost + additionalTreatment_cost))
                                                                thousand_sepr_span(clinicDiscountAmount);
                                                                thousand_sepr_span(dentistDiscountAmount);
                                                                patientPrimary_cost.value = (treatment_cost + additionalTreatment_cost);
                                                                patientFinal_cost.value = (treatment_cost + additionalTreatment_cost) - ((clinicDiscount / 100)*(treatment_cost + additionalTreatment_cost)) - ((dentistDiscount / 100)*(treatment_cost + additionalTreatment_cost));
                                                                //document.getElementById('patientDept').value = parseFloat(patientFinal_cost.value.replaceAll(',','')) - paid;
                                                                thousand_sepr(patientFinal_cost);thousand_sepr(patientPrimary_cost);//thousand_sepr(patientDept);
                                                            }
                                                            function delete_payment(btn){
                                                                const code2 = btn.dataset.code;
                                                                const price2 = btn.dataset.price;
                                                                document.getElementById(code2).remove();
                                                                paid = paid - parseFloat(price2);
                                                                update_costs();
                                                                let temp_payments = []
                                                                for (const payment of payments) {
                                                                    if(payment['code'] === code2){

                                                                    }
                                                                    else {
                                                                        temp_payments.push(payment)
                                                                    }
                                                                }
                                                                payments = temp_payments;
                                                                document.getElementById('paidJson').value = JSON.stringify(payments);
                                                            }
                                                        </script>
                                                        <div class="row mt-1 d-none">
                                                            <div class="col-12 col-md-3 mt-2">
                                                                <label class="form-label">سهم دندانپزشک (درصد)</label>
                                                                <input type=number" name="dentist_cut_percentage" id="dentist_cut_percentage" class="form-control" onkeyup="dentist_cut_funcs(this);thousand_sepr(this);" placeholder="50" value="0">
                                                            </div>
                                                            <div class="col-12 col-md-3 mt-2">
                                                                <label class="form-label">مقدار سهم دندانپزشک</label>
                                                                <input type="text" name="dentist_cut_amount" id="dentist_cut_amount" onkeyup="dentist_cut_funcs(this);thousand_sepr(this);" class="form-control" placeholder="550,000" value="0">
                                                            </div>
                                                        </div>
                                                        <script>
                                                            function dentist_cut_funcs(input){
                                                                const treatment_cost = parseFloat(document.getElementById('treatment_cost').value.replaceAll(',',''));
                                                                const additionalTreatment_cost = parseFloat(document.getElementById('additionalTreatment_cost').value.replaceAll(',',''));
                                                                const dentist_cut_percentage = parseFloat(document.getElementById('dentist_cut_percentage').value.replaceAll(',',''));
                                                                const dentist_cut_amount = parseFloat(document.getElementById('dentist_cut_amount').value.replaceAll(',',''));
                                                                if(input.id === "dentist_cut_percentage"){
                                                                    document.getElementById('dentist_cut_amount').value = (treatment_cost + additionalTreatment_cost) * ((dentist_cut_percentage/100));
                                                                }
                                                                if(input.id === "dentist_cut_amount"){
                                                                    document.getElementById('dentist_cut_percentage').value = ((dentist_cut_amount)/(treatment_cost + additionalTreatment_cost))*100;
                                                                }
                                                                thousand_sepr(document.getElementById('dentist_cut_amount'));
                                                            }

                                                            function dentist_change(select){
                                                                const dentist_cut = select.selectedOptions[0].dataset.cut;
                                                                document.getElementById('dentist_cut_percentage').value = dentist_cut;
                                                                dentist_cut_funcs(document.getElementById('dentist_cut_percentage'));
                                                            }
                                                        </script>
                                                        <div class="row mt-2">
                                                            <div class="row mt-2">
                                                                <div class="col-12 mt-3">
                                                                    <label class="form-label">توضیحات</label>
                                                                    <textarea id="treatmentNote" name="treatmentNote" class="form-control" rows="4" placeholder="توضیحات تکمیلی در مورد طرح درمان را وارد کنید..."></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <input type="hidden" name="selected_teeth" id="selected_teeth_hidden">
                                                        <input type="hidden" name="selected_dentition" id="selected_dentition_hidden" value="PRIMARY">
                                                        <div class="row">
                                                            <div class="row p-1 pe-4 ps-4">
                                                                <button type="submit" id="done-services-submit-btn" name="add-done-services-submit" class="btn btn-primary mt-3 mb-3">ثبت درمان</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php
                            }
                            ?>
                            <div class="card mb-4" style="display: <?=$appointmentsTabDisplay?>">
                                <div class="table-responsive mb-3">
                                    <table class="table datatable-appointments border-top">
                                        <thead>
                                        <tr>
                                            <th>ردیف</th>
                                            <th>تاریخ</th>
                                            <th>ساعت</th>
                                            <th>درمان</th>
                                            <th>دندانپزشک</th>
                                            <th>وضعیت</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                                <script>
                                    $(document).ready(function () {
                                        $('.datatable-appointments').DataTable({
                                            processing: true,
                                            ajax: {
                                                url: '<?=ROOT?>functions/cases_funcs.php',
                                                type: 'POST',
                                                data: { action: 'load_appointments' , code: '<?=htmlspecialchars($patient_code)?>' },
                                                dataSrc: function(json) {
                                                    console.log("JSON response from server:", json); // <-- show the response
                                                    return json.data; // DataTables expects an array here
                                                },
                                                error: function(xhr, status, error) {
                                                    console.error("AJAX error:", status, error);
                                                    console.log("Response text:", xhr.responseText);
                                                }
                                            },
                                            columns: [
                                                { data: 'radif' },
                                                { data: 'date' },
                                                { data: 'hour' },
                                                { data: 'service' },
                                                { data: 'dentist' },
                                                { data: 'status' }
                                            ]
                                        });
                                    });
                                </script>
                            </div>
                            <div class="card mb-4" style="display: <?=$messagesTabDisplay?>">
                                <div class="table-responsive mb-3">
                                    <table class="table datatable-messages border-top">
                                        <thead>
                                        <tr>
                                            <th>ردیف</th>
                                            <th>تاریخ</th>
                                            <th>ساعت</th>
                                            <th>متن پیام</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                                <script>
                                    $(document).ready(function () {
                                        $('.datatable-messages').DataTable({
                                            processing: true,
                                            ajax: {
                                                url: '<?=ROOT?>functions/cases_funcs.php',
                                                type: 'POST',
                                                data: { action: 'load_messages', code: '<?=htmlspecialchars($patient_code)?>' },
                                                dataSrc: function(json) {
                                                    console.log("JSON response from server:", json); // <-- show the response
                                                    return json.data; // DataTables expects an array here
                                                },
                                                error: function(xhr, status, error) {
                                                    console.error("AJAX error:", status, error);
                                                    console.log("Response text:", xhr.responseText);
                                                }
                                            },
                                            columns: [
                                                { data: 'radif' },
                                                { data: 'date' },
                                                { data: 'hour' },
                                                {
                                                    data: 'message',
                                                    render: function (data, type, row) {
                                                        if (type === 'display') {
                                                            return data.replace(/\\n/g, '<br>');
                                                        }
                                                        return data;
                                                    }
                                                }
                                            ]
                                        });
                                    });
                                </script>
                            </div>
                            <div class="mb-4" style="display: <?=$patientRecordsTabDisplay?>">
                                <button class="btn btn-primary mb-2" data-bs-target="#addNewRecord" data-bs-toggle="modal" type="button">افزودن رکورد</button>
                                <div class="card mb-4">
                                    <div class="table-responsive mb-3">
                                        <table class="table datatable-records border-top">
                                            <thead>
                                            <tr>
                                                <th>ردیف</th>
                                                <th>نوع رکورد</th>
                                                <th>تعداد</th>
                                                <th>تاریخ</th>
                                                <th>عملیات</th>
                                            </tr>
                                            </thead>
                                        </table>
                                    </div>
                                    <script>
                                        $(document).ready(function () {
                                            $('.datatable-records').DataTable({
                                                processing: true,
                                                ajax: {
                                                    url: '<?=ROOT?>functions/cases_funcs.php',
                                                    type: 'POST',
                                                    data: { action: 'load_records', code: '<?=htmlspecialchars($patient_code)?>' },
                                                    dataSrc: function(json) {
                                                        console.log("JSON response from server:", json); // <-- show the response
                                                        return json.data; // DataTables expects an array here
                                                    },
                                                    error: function(xhr, status, error) {
                                                        console.error("AJAX error:", status, error);
                                                        console.log("Response text:", xhr.responseText);
                                                    }
                                                },
                                                columns: [
                                                    { data: 'radif' },
                                                    { data: 'type' },
                                                    { data: 'count' },
                                                    { data: 'date' },
                                                    { data: 'actions', orderable: false, searchable: false }
                                                ]
                                            });
                                        });
                                    </script>
                                </div>

                            </div>
                            <div class="mb-4" style="display: <?=$accountingTabDisplay?>">
                                <?php
                                $stmt = $pdo->prepare("SELECT * FROM done_treatments WHERE clinic_code = ? AND patient_code = ? AND status != 'DELETED'");
                                $stmt->execute([$officeCode,$patient_code]);
                                $patient_final_cost = 0;
                                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                    $patient_final_cost += floatval($row['patientFinal_cost']);
                                }
                                $patient_paid = 0;
                                $patient_pending_installments = 0;
                                $stmt = $pdo->prepare("SELECT * FROM patients_payments WHERE office_code = ? AND patient_code = ? AND status != 'DELETED'");
                                $stmt->execute([$officeCode,$patient_code]);
                                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                    if($row['payment_method'] == "اقساط"){
                                        $installments = json_decode($row['installments'], true);
                                        foreach ($installments as $installment) {
                                            if ($installment['status'] == "پرداخت شده") {
                                                $patient_paid += floatval($installment['amount']);
                                            }
                                            else{
                                                if($installment['status'] == "پرداخت نشده" || $installment['status'] == "تاخیر"){
                                                    $patient_pending_installments += floatval($installment['amount']);
                                                }
                                            }
                                        }
                                    }
                                    else{
                                        if($row['status'] == "DONE"){
                                            $patient_paid += floatval($row['final_amount']);
                                            $patient_paid += floatval($row['discount_amount']);
                                        }
                                    }
                                }
                                ?>
                                <div class="row">
                                    <div class="col-md-3 col-6">
                                        <div class="card shadow-none bg-transparent border border-primary mb-3">
                                            <div class="card-body">
                                                <h5 class="card-title">مجموع هزینه ها</h5>
                                                <p class="card-text"><?=thousand_sepr($patient_final_cost)?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-6">
                                        <div class="card shadow-none bg-transparent border border-primary mb-3">
                                            <div class="card-body">
                                                <h5 class="card-title">بدهی بیمار</h5>
                                                <?php
                                                if(($patient_final_cost-$patient_paid) < 0){
                                                    ?>
                                                    <p class="card-text">- <?=thousand_sepr($patient_final_cost-$patient_paid)?> (بستانکار)</p>
                                                    <?php
                                                }
                                                else{
                                                    ?>
                                                    <p class="card-text"><?=thousand_sepr($patient_final_cost-$patient_paid)?></p>
                                                    <?php
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-6">
                                        <div class="card shadow-none bg-transparent border border-primary mb-3">
                                            <div class="card-body">
                                                <h5 class="card-title">پرداختی های بیمار</h5>
                                                <p class="card-text"><?=thousand_sepr($patient_paid)?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-6">
                                        <div class="card shadow-none bg-transparent border border-primary mb-3">
                                            <div class="card-body">
                                                <h5 class="card-title">اقساط باقی مانده</h5>
                                                <p class="card-text"><?=thousand_sepr($patient_pending_installments);?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <button class="btn btn-primary mb-2" onclick="load_add_payment_modal()" type="button">افزودن پرداختی</button>
                                <div class="card mb-4">
                                    <div class="table-responsive mb-3">
                                        <table class="table datatable-invoices border-top">
                                            <thead>
                                            <tr>
                                                <th>ردیف</th>
                                                <th>روش</th>
                                                <th>مبلغ کل</th>
                                                <th>تخفیف</th>
                                                <th>قابل پرداخت</th>
                                                <th>قسط بعدی</th>
                                                <th>تاریخ</th>
                                                <th>وضعیت</th>
                                                <th>عملیات</th>
                                            </tr>
                                            </thead>
                                        </table>
                                    </div>
                                    <script>
                                        $(document).ready(function () {
                                            $('.datatable-invoices').DataTable({
                                                processing: true,
                                                ajax: {
                                                    url: '<?=ROOT?>functions/cases_funcs.php',
                                                    type: 'POST',
                                                    data: { action: 'load_payments', code: '<?=htmlspecialchars($patient_code)?>' },
                                                    dataSrc: function(json) {
                                                        console.log("JSON response from server:", json); // <-- show the response
                                                        return json.data; // DataTables expects an array here
                                                    },
                                                    error: function(xhr, status, error) {
                                                        console.error("AJAX error:", status, error);
                                                        console.log("Response text:", xhr.responseText);
                                                    }
                                                },
                                                columns: [
                                                    { data: 'radif' },
                                                    { data: 'method' },
                                                    { data: 'primary_amount' },
                                                    { data: 'discount' },
                                                    { data: 'final_amount' },
                                                    { data: 'next_installment' },
                                                    { data: 'date' },
                                                    { data: 'status' },
                                                    { data: 'actions', orderable: false, searchable: false }
                                                ]
                                            });
                                        });
                                    </script>
                                </div>

                            </div>
                            <!-- /Invoice table -->
                        </div>
                        <!--/ User Content -->
                    </div>
                    <div aria-hidden="true" class="modal fade" id="addNewRecord" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
                            <div class="modal-content p-3 p-md-5">
                                <div class="modal-body">
                                    <button aria-label="بستن" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                    <div class="text-center mb-4">
                                        <h3 class="mb-2">افزودن رکورد جدید</h3>
                                    </div>
                                    <form class="row g-3" id="addNewRecordForm" onsubmit="return false">
                                        <div class="col-12">
                                            <label class="form-label w-100" for="modalAddCardName">نام رکورد (اجباری)
                                                <select id="record_type" name="record_type" class="form-control w-100">
                                                    <option value="NA">انختاب کنید</option>
                                                    <option value="LINK">لینک</option>
                                                    <option value="OPG">Panoramic(OPG)</option>
                                                    <option value="PA">PA</option>
                                                    <option value="BITE">Bitewing</option>
                                                    <option value="OCCLUSAL">Occlusal</option>
                                                    <option value="CBCT">CBCT</option>
                                                    <option value="PHOTO">عکس</option>
                                                    <option value="AVATAR">عکس پروفایل</option>
                                                    <option value="DIGITALFILES">فایل دیجیتال</option>
                                                    <option value="OTHER">OTHER</option>
                                                </select>
                                            </label>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label w-100" for="record_link">لینک
                                                <input class="form-control w-100" id="record_link" name="record_link" placeholder="" type="text"/>
                                            </label>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">فایل ضمیمه</label>
                                            <input type="file" id="upload_file" oninput="" name="uploaded_file[]" class="form-control" multiple>
                                            <div id="uploaded_files_box">
                                            </div>
                                        </div>
                                        <div aria-hidden="true" class="modal fade" id="modalCenter" tabindex="-1" data-bs-backdrop="static">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="modalCenterTitle">آپلود فایل</h5>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row">
                                                            <div class="col mb-3 text-center">
                                                                <h2 class="form-label" for="nameWithTitle">در حال آپلود فایل ...</h2>
                                                                <div class="progress mt-3">
                                                                    <div id="uploadProgress"
                                                                         class="progress-bar progress-bar-striped progress-bar-animated bg-primary"
                                                                         role="progressbar"
                                                                         aria-valuemin="0"
                                                                         aria-valuemax="100"
                                                                         aria-valuenow="0"
                                                                         style="width: 20%">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label w-100" for="record_name">نام رکورد (اختیاری)
                                                <input class="form-control w-100" id="record_name" name="record_name" placeholder="برای مثال رادیوگرافی بعد از درمان" type="text"/>
                                            </label>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label w-100" for="record_name">توضیحات (اختیاری)
                                                <textarea class="form-control w-100" id="record_note"></textarea>
                                            </label>
                                        </div>
                                        <div class="col-12 text-center">
                                            <button class="btn btn-primary me-sm-3 me-1" type="button" onclick="add_record();">ارسال اطلاعات</button>
                                            <button aria-label="" class="btn btn-label-secondary btn-reset" data-bs-dismiss="modal" type="reset">بازگشت</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script>
                            let upld_fls_codes = [];
                            function delay(ms) {
                            return new Promise(resolve => setTimeout(resolve, ms));
                        }
                            function truncateWithDots(str) {
                            if (str.length <= 10) return str; // nothing to truncate
                            return str.slice(0, 10) + '...';
                        }
                            $(function () {
                            $("#upload_file").on("input", function () {
                                let files = $("#upload_file")[0].files;
                                if (!files.length) {
                                    alert("لطفا یک یا چند فایل انتخاب کنید.");
                                    return;
                                }
                                else {
                                    $('#modalCenter').modal('show');
                                }

                                let formData = new FormData();
                                $.each(files, function (i, file) {
                                    formData.append("uploaded_file[]", file);
                                });

                                $.ajax({
                                    url: "<?=ROOT?>functions/add_order_upload_funcs.php", // مرحله اول: به لوکال
                                    type: "POST",
                                    data: formData,
                                    processData: false,
                                    contentType: false,
                                    xhr: function () {
                                        let xhr = new window.XMLHttpRequest();
                                        xhr.upload.addEventListener("progress", function (evt) {
                                            if (evt.lengthComputable) {
                                                let percent = (evt.loaded / evt.total) * 100;
                                                $("#uploadProgress")
                                                    .css("width", percent.toFixed(2) + "%")
                                                    .attr("aria-valuenow", percent.toFixed(2))
                                                    .text(percent.toFixed(0) + "%");
                                            }
                                        }, false);
                                        return xhr;
                                    },
                                    success: function (response) {
                                        const results = response.results;
                                        document.getElementById('uploaded_files_box').innerHTML = "";
                                        for (const result of results) {
                                            let arr = JSON.parse(result['server_response']);
                                            const code = arr.files[0].name;
                                            const name = arr.files[0].original_name;
                                            let arr2 = [code,name]
                                            upld_fls_codes.push(arr2);
                                        }
                                        for (const upld_fls_code of upld_fls_codes) {
                                            let tmpstring =  '\n' + '<button onclick="remove_file(\'' + upld_fls_code[0] + '\')" class="btn btn-label-primary waves-effect mt-2" type="button"><span class="ti-xs ti ti-x me-1"></span>' + truncateWithDots(upld_fls_code[1]) + '</button>'
                                            document.getElementById('uploaded_files_box').innerHTML += tmpstring;
                                        }
                                        if (response.status === "ok") {
                                            console.log(response);
                                            delay(1000).then(() => {
                                                let modalEl = document.getElementById('modalCenter');
                                                let modalInstance = bootstrap.Modal.getOrCreateInstance(modalEl);
                                                modalInstance.hide(); // بستن یا اجرای عمل
                                                let new_tmp = [];
                                                for (const upld_fls_code of upld_fls_codes) {
                                                    console.log(upld_fls_code);
                                                    new_tmp.push(upld_fls_code[0]);
                                                }
                                                console.log(new_tmp);
                                                document.getElementById('add-file-codes').value = JSON.stringify(new_tmp);
                                                console.log(upld_fls_codes);
                                            });
                                        } else {
                                            alert("خطا: " + response.message);
                                        }
                                    },
                                    error: function () {
                                        alert("خطا در ارسال به functions/upload.php");
                                    }
                                });
                            });
                        });
                            function remove_file(code){
                            let tmp = [];
                            document.getElementById('uploaded_files_box').innerHTML = "";
                            for (const upld_fls_code of upld_fls_codes) {
                            if(upld_fls_code[0] !== code){
                            tmp.push(upld_fls_code);
                            let tmpstring =  "\n" + '<button onclick="remove_file(\'' + upld_fls_code[0] + '\')" class="btn btn-label-primary waves-effect mt-2" type="button"><span class="ti-xs ti ti-x me-1"></span>' + truncateWithDots(upld_fls_code[1]) + '</button>'
                            document.getElementById('uploaded_files_box').innerHTML += tmpstring;
                        }
                        }
                            upld_fls_codes = tmp;
                            let new_tmp = [];
                            for (const upld_fls_code of upld_fls_codes) {
                            new_tmp.push(upld_fls_code[0]);
                        }
                            document.getElementById('add-file-codes').value = JSON.stringify(new_tmp);
                            console.log(upld_fls_codes);
                        }
                    </script>
                    <div aria-hidden="true" class="modal fade" id="addNewPayment" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-simple modal-edit-user">
                            <div class="modal-content p-3 p-md-5">
                                <div class="modal-body">
                                    <button aria-label="بستن" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                    <div class="text-center mb-4">
                                        <h3 id="modal_title" class="mb-2">افزودن پرداختی جدید</h3>
                                    </div>
                                    <form class="row g-3" id="addNewPaymentForm" onsubmit="return false">
                                        <input hidden="hidden" value="" id="payment_code">
                                        <div class="col-12 col-md-6">
                                            <div class="row">
                                                <div class="col-12">
                                                    <label class="form-label" for="paymentMethod">روش</label>
                                                    <select class="form-control" id="paymentMethod">
                                                        <option value="NA">انتخاب کنید.</option>
                                                        <option value="کارتخوان">کارتخوان</option>
                                                        <option value="کارت به کارت">کارت به کارت</option>
                                                        <option value="اقساط">اقساط</option>
                                                        <option value="دلار">به صورت دلار</option>
                                                        <option value="یورو">به صورت یورو</option>
                                                        <option value="دینار">به صورت دینار</option>
                                                        <option value="درهم">به صورت درهم</option>
                                                        <option value="سایر">سایر</option>
                                                    </select>
                                                </div>
                                                <div class="col-12">
                                                    <label class="form-label w-100" for="primaryAmount">مبلغ کل (به تومان)
                                                        <input class="form-control w-100" id="primaryAmount" name="primaryAmount" placeholder="12,000,000" onkeyup="thousand_sepr(this);paymentAmount_change(this);" type="text"/>
                                                    </label>
                                                </div>
                                                <div class="col-12">
                                                    <label class="form-label w-100" for="paymentDiscount">تخفیف (به تومان)
                                                        <input class="form-control w-100" id="paymentDiscount" name="paymentDiscount" placeholder="2,000,000" onkeyup="thousand_sepr(this);paymentAmount_change(this);" type="text"/>
                                                    </label>
                                                </div>
                                                <div class="col-12">
                                                    <label class="form-label w-100" for="paymentAmount">قابل پرداخت (به تومان)
                                                        <input class="form-control w-100" id="paymentAmount" name="paymentAmount" placeholder="10,000,000" onkeyup="thousand_sepr(this);paymentAmount_change(this);" type="text"/>
                                                    </label>
                                                </div>
                                                <div class="col-12">
                                                    <label class="form-label w-100" for="flatpickr-datetime4">تاریخ پرداخت
                                                        <input class="form-control bdi flatpickr-input active" name="start-date" id="flatpickr-datetime4" placeholder="YYYY-MM-DD HH:MM" type="text" readonly="readonly">
                                                    </label>
                                                </div>
                                                <!-- Installments container -->
                                                <div class="col-12 d-none" id="installmentsWrapper">
                                                    <label class="form-label">اقساط</label>

                                                    <div id="installmentsList"></div>

                                                    <button type="button" class="btn btn-sm btn-outline-primary mt-2" onclick="addInstallmentRow()">
                                                        افزودن قسط
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="row">
                                                <div class="col-12 p-4">
                                                    <small class="text-light fw-medium">درمان‌ها</small>

                                                    <div class="treatment-box mt-2 p-3">
                                                        <?php
                                                        $stmt = $pdo->prepare("
        SELECT service_code, service_title, service_category_code
        FROM services
        WHERE status = 'ACTIVE' AND COALESCE(hide_default_for, '') NOT LIKE :pattern
          AND (office_code = :office_code OR office_code = 'DEFAULT')
    ");
                                                        $stmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
                                                        $services = [];
                                                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                            $services[] = $row;
                                                        }

                                                        $stmt = $pdo->prepare("SELECT * FROM dentists WHERE office_code = ? AND  status = 'ACTIVE'");
                                                        $stmt->execute([$officeCode]);
                                                        $dentists = [];
                                                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                            $dentists[$row['dentist_code']] = $row;
                                                        }

                                                        $service_title = "نامشخص";
                                                        $stmt = $pdo->prepare("SELECT * FROM done_treatments WHERE clinic_code = ? AND patient_code = ? AND status != 'DELETED'");
                                                        $stmt->execute([$officeCode,$patient_code]);
                                                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                            $service_cat = "";
                                                            foreach ($services as $service){
                                                                if($service['service_code'] == $row['service_code']){
                                                                    $service_title = $service['service_title'];
                                                                    $service_cat = $service['service_category_code'];
                                                                }
                                                            }
                                                            $status_code = $row['status'];
                                                            $dentist_name = "نامشخص";
                                                            if($row['dentist_code'] == "MANUAL"){
                                                                $dentist_name = $row['manual_dentist_name'];
                                                            }
                                                            else{
                                                                $dentist_name_enc = decryptData($dentists[$row['dentist_code']]['dentist_fullname_encrypted']);
                                                                $dentist_encrypted = ['dentist_fullname_encrypted'=>$dentist_name_enc];
                                                                $iv = $dentists[$row['dentist_code']]['iv'];
                                                                $salt = $dentists[$row['dentist_code']]['salt'];
                                                                $enc_code = $dentists[$row['dentist_code']]['enc_code'];
                                                                $tmp_dentist = get_decrypted_data($dentist_encrypted,$iv,$salt,$enc_code);
                                                            }
                                                            ?>
                                                            <div class="form-check mb-2">
                                                                <input class="form-check-input done_treatment_select" id="<?=$row['done_code'];?>" type="checkbox">
                                                                <label class="form-check-label" for="<?=$row['done_code'];?>">
                                                                    <?=$service_title .  ' - ' . $row['done_code_number'] . ' - ' . 'دکتر ' . $tmp_dentist['dentist_fullname_encrypted']?>
                                                                </label>
                                                            </div>
                                                        <?php
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                                <style>
                                                    .treatment-box {
                                                        max-height: 200px;          /* ارتفاع باکس */
                                                        overflow-y: auto;           /* اسکرول عمودی */
                                                        border: 1px solid #ddd;
                                                        border-radius: 8px;
                                                        background-color: #fff;
                                                    }

                                                    /* اسکرول نرم‌تر (اختیاری) */
                                                    .treatment-box::-webkit-scrollbar {
                                                        width: 6px;
                                                    }
                                                    .treatment-box::-webkit-scrollbar-thumb {
                                                        background-color: rgba(0,0,0,0.3);
                                                        border-radius: 6px;
                                                    }

                                                </style>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label w-100" for="paymentNote">توضیحات</label>
                                                <textarea class="form-control w-100" id="paymentNote"></textarea>
                                        </div>
                                        <div class="col-12 text-center">
                                            <button id="modal_btn" class="btn btn-primary me-sm-3 me-1" type="button" onclick="add_payment();">افزودن</button>
                                            <button aria-label="" class="btn btn-label-secondary btn-reset" data-bs-dismiss="modal" type="reset">بازگشت</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script>
                        let installments = []
                        document.addEventListener('DOMContentLoaded', function () {

                            const paymentMethod = document.getElementById('paymentMethod');
                            const installmentsWrapper = document.getElementById('installmentsWrapper');
                            const installmentsList = document.getElementById('installmentsList');

                            paymentMethod.addEventListener('change', function () {
                                if (this.value === 'اقساط') {
                                    installmentsWrapper.classList.remove('d-none');
                                } else {
                                    installmentsWrapper.classList.add('d-none');
                                    installmentsList.innerHTML = '';
                                }
                            });

                        });

                        /* افزودن قسط */
                        function addInstallmentRow() {
                            const index = document.querySelectorAll('.installment-row').length;

                            const row = document.createElement('div');
                            row.className = 'row g-2 align-items-end mb-2 installment-row';

                            row.innerHTML = `
        <div class="col-4">
            <input type="text"
                   class="form-control installment_amount"
                   name="installments[${index}][amount]"
                   placeholder="مبلغ قسط"
                   onkeyup="thousand_sepr(this);">
        </div>

        <div class="col-4">
            <input type="text"
                   class="form-control installment_due_date"
                   name="installments[${index}][date]"
                   placeholder="1404/10/20"
                  >
        </div>
        <div class="col-3">
            <select
                   class="form-control installment_status"
                   name="installments[${index}][status]"
                  >
<option value="پرداخت نشده">پرداخت نشده</option>
<option value="پرداخت شده">پرداخت شده</option>
<option value="تاخیر">تاخیر</option>
<option value="لغو">لغو</option>
</select>
        </div>

        <div class="col-1 text-center">
            <button type="button"
                    class="btn btn-sm btn-danger"
                    onclick="removeInstallment(this)">
                ×
            </button>
        </div>
    `;

                            document.getElementById('installmentsList').appendChild(row);
                        }

                        /* حذف قسط */
                        function removeInstallment(btn) {
                            btn.closest('.installment-row').remove();
                        }

                        /* فعال‌سازی flatpickr */
                        function initInstallmentFlatpickr(el) {
                            flatpickr(el, {
                                enableTime: true,
                                dateFormat: "Y-m-d H:i",
                                time_24hr: true
                            });
                        }
                    </script>

                    <!-- Modal -->
                    <script>
                        let edit_payment_mode = false;
                        function load_edit_modal_data(btn){
                            const teeth_json = btn.dataset.teeth;
                            const dentition = btn.dataset.dentition;
                            const serivce_code = btn.dataset.servicecode;
                            const serivce_note = btn.dataset.note;
                            const status = btn.dataset.status;
                            const treatment_code = btn.dataset.code;
                            const teeth = JSON.parse(teeth_json.replace(' ',''));
                            document.getElementById('slctJawUBTN').classList.add('btn-outline-primary');
                            document.getElementById('slctJawUBTN').classList.remove('btn-primary');
                            document.getElementById('slctJawLBTN').classList.add('btn-outline-primary');
                            document.getElementById('slctJawLBTN').classList.remove('btn-primary');
                            selected_teeth_5 = [];
                            if(teeth_json.includes("JAW")){
                                if(teeth_json.includes("UPPERJAW") || teeth_json.includes("BOTHJAW")){
                                    select_jaw(document.getElementById('slctJawUBTN'),'u');
                                }
                                if(teeth_json.includes("LOWERJAW") || teeth_json.includes("BOTHJAW")){
                                    select_jaw(document.getElementById('slctJawLBTN'),'l');
                                }
                                selected_dentition = dentition;
                                change_dentition();
                                change_dentition();
                                document.getElementById('services_select_edit').value = serivce_code;
                                document.getElementById('status_edit').value = status;
                                document.getElementById('treatmentNoteEdit').value = serivce_note;
                                document.getElementById('treatment_code_edit').value = treatment_code;
                            }
                            else {
                                for (const tooth of teeth) {
                                    tooth_select(document.getElementById(tooth));
                                    selected_dentition = dentition;
                                    change_dentition();
                                    change_dentition();
                                    document.getElementById('services_select_edit').value = serivce_code;
                                    document.getElementById('status_edit').value = status;
                                    document.getElementById('treatmentNoteEdit').value = serivce_note;
                                    document.getElementById('treatment_code_edit').value = treatment_code;
                                }
                            }
                        }
                        function load_add_payment_modal(){
                            edit_payment_mode = false;
                            document.getElementById('modal_title').innerHTML = "افزودن پرداختی جدید";
                            document.getElementById('modal_btn').innerHTML = "افزودن";
                            document.getElementById('modal_btn').onclick = function () {
                                add_payment();
                            };
                            document.getElementById('payment_code').value = "";
                            document.getElementById('primaryAmount').value = 0;
                            document.getElementById('paymentDiscount').value = 0;
                            document.getElementById('paymentAmount').value = 0;
                            document.getElementById('paymentNote').value = "";
                            const select = document.getElementById('paymentMethod');
                            select.value = "NA";
                            select.dispatchEvent(new Event('change'));
                            let donetreatments = document.querySelectorAll('.done_treatment_select');
                            for (const donetreatment of donetreatments) {
                                donetreatment.checked = false;
                            }

                            const modalEl = document.getElementById('addNewPayment');
                            const modal = new bootstrap.Modal(modalEl);
                            modal.show();
                        }
                        function load_edit_payment_modal_data(btn){
                            edit_payment_mode = true;

                            document.getElementById('modal_title').value = "افزودن پرداختی جدید";
                            document.getElementById('modal_btn').value = "افزودن";
                            document.getElementById('modal_btn').onclick = function () {
                                add_payment();
                            };
                            document.getElementById('payment_code').value = "";
                            document.getElementById('primaryAmount').value = 0;
                            document.getElementById('paymentDiscount').value = 0;
                            document.getElementById('paymentAmount').value = 0;
                            document.getElementById('paymentNote').value = "";
                            const select = document.getElementById('paymentMethod');
                            select.value = "NA";
                            select.dispatchEvent(new Event('change'));
                            let donetreatments = document.querySelectorAll('.done_treatment_select');
                            for (const donetreatment of donetreatments) {
                                donetreatment.checked = false;
                            }

                            document.getElementById('modal_title').innerHTML = "ویرایش پرداختی";
                            document.getElementById('modal_btn').innerHTML = "ویرایش";
                            document.getElementById('modal_btn').onclick = function () {
                                edit_payment();
                            };
                            const method = btn.dataset.method;
                            const primaryAmount = btn.dataset.primaryamount;
                            const finalAmount = btn.dataset.finalamount;
                            const discount = btn.dataset.discount;
                            const installments_data = btn.dataset.installments;
                            const donetreatmentscodes_data = btn.dataset.donetreatmentscodes;
                            const status = btn.dataset.status;
                            const code = btn.dataset.code;
                            const notes = btn.dataset.notes;
                            const paid_date = btn.dataset.paiddate;
                            select.value = method;
                            select.dispatchEvent(new Event('change'));
                            document.getElementById('payment_code').value = code;
                            document.getElementById('primaryAmount').value = primaryAmount;
                            document.getElementById('paymentDiscount').value = discount;
                            document.getElementById('paymentAmount').value = finalAmount;
                            document.getElementById('paymentNote').value = notes;
                            const fp3 = document.getElementById('flatpickr-datetime4')._flatpickr;
                            fp3.setDate(paid_date, true);
                            installments = JSON.parse(installments_data);
                            for (const installment1 of installments) {
                                const index = document.querySelectorAll('.installment-row').length;

                                const row = document.createElement('div');
                                row.className = 'row g-2 align-items-end mb-2 installment-row';

                                row.innerHTML = `
        <div class="col-4">
            <input type="text"
                   class="form-control installment_amount"
                   name="installments[${index}][amount]"
                   value="${installment1.amount}"
                   placeholder="مبلغ قسط"
                   onkeyup="thousand_sepr(this);">
        </div>

        <div class="col-4">
            <input type="text"
                   class="form-control installment_due_date"
                   name="installments[${index}][date]"
                   value="${installment1.date}"
                   placeholder="1404/10/20"
                  >
        </div>
        <div class="col-3">
            <select
                   class="form-control installment_status"
                   value="${installment1.status}"
                   name="installments[${index}][status]"
                  >
<option value="پرداخت نشده">پرداخت نشده</option>
<option value="پرداخت شده">پرداخت شده</option>
<option value="تاخیر">تاخیر</option>
<option value="لغو">لغو</option>
</select>
        </div>

        <div class="col-1 text-center">
            <button type="button"
                    class="btn btn-sm btn-danger"
                    onclick="removeInstallment(this)">
                ×
            </button>
        </div>
    `;
                                row.querySelector('.installment_status').value = installment1.status;

                                document.getElementById('installmentsList').appendChild(row);
                            }
                            let donetreatmentscodes = JSON.parse(donetreatmentscodes_data);
                            for (const donetreatmentscode of donetreatmentscodes) {
                                document.getElementById(donetreatmentscode).checked = true;
                            }
                            thousand_sepr(document.getElementById('primaryAmount'));
                            thousand_sepr(document.getElementById('paymentDiscount'));
                            thousand_sepr(document.getElementById('paymentAmount'));
                            const modalEl = document.getElementById('addNewPayment');
                            const modal = new bootstrap.Modal(modalEl);
                            modal.show();
                        }
                    </script>
                    <script>

                        function add_record(){
                            const record_name = document.getElementById('record_name').value;
                            const record_type = document.getElementById('record_type').value;
                            const record_link = document.getElementById('record_link').value;
                            const record_notes = document.getElementById('record_link').value;
                            const record_files = JSON.stringify(upld_fls_codes);
                            let error = "";
                            if(record_type === null || record_type === "NA"){
                                error = "نوع رکورد مشخص نشده است.";
                            }
                            if(record_type === "LINK" && record_link === ""){
                                error = "لینک وارد نشده است.";
                            }
                            if(record_type !== "LINK" && upld_fls_codes.length === 0){
                                error = "فایلی وارد نشده است.";
                            }
                            console.log(record_type);
                            if(error === ""){
                                const formData = new FormData();
                                formData.append('action', 'add_record');
                                formData.append('name', record_name);
                                formData.append('type', record_type);
                                formData.append('link', record_link);
                                formData.append('notes', record_notes);
                                formData.append('pcode', '<?=htmlspecialchars($patient_code)?>');
                                formData.append('files', record_files);

                                fetch('<?=ROOT?>functions/cases_funcs.php', {
                                    method: 'POST',
                                    body: formData
                                })
                                    .then(r => r.json())
                                    .then(data => {
                                        console.log(data);
                                        if (data.data === "success") {
                                            Swal.fire({
                                                icon: 'success',
                                                title: 'موفق!',
                                                text: data.message || 'رکورد با موفقیت افزوده شد.',
                                                confirmButtonText: 'باشه',
                                                customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                            });
                                            $('.datatable-records').DataTable().ajax.reload();
                                            form.reset();
                                        } else {
                                            Swal.fire({
                                                icon: 'error',
                                                title: 'خطا',
                                                text: data.error || 'خطا در ذخیره رکورد',
                                                confirmButtonText: 'باشه',
                                                customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                            });
                                        }
                                    })
                                    .catch(() => {

                                    });
                                Swal.fire({
                                    icon: 'success',
                                    title: 'موفق!',
                                    text: 'بیمار با موفقیت اضافه شد.',
                                    confirmButtonText: 'باشه',
                                    customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                });
                            }
                            else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'خطا!',
                                    text: error,
                                    confirmButtonText: 'باشه',
                                    customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                });
                            }

                        }
                        function paymentAmount_change(input){
                            const primaryAmount = document.getElementById('primaryAmount');
                            const paymentAmount = document.getElementById('paymentAmount');
                            const paymentDiscount = document.getElementById('paymentDiscount');
                            const primaryAmountValue = parseFloat(document.getElementById('primaryAmount').value.replaceAll(',',''));
                            const paymentAmountValue = parseFloat(document.getElementById('paymentAmount').value.replaceAll(',',''));
                            const paymentDiscountValue = parseFloat(document.getElementById('paymentDiscount').value.replaceAll(',',''));

                            if(input.id === primaryAmount.id){
                                paymentAmount.value = primaryAmountValue - paymentDiscountValue;
                            }
                            if(input.id === paymentAmount.id){
                                paymentDiscount.value = primaryAmountValue - paymentAmountValue;
                            }
                            if(input.id === paymentDiscount.id){
                                paymentAmount.value = primaryAmountValue - paymentDiscountValue;
                            }
                            thousand_sepr(primaryAmount);
                            thousand_sepr(paymentAmount);
                            thousand_sepr(paymentDiscount);

                        }
                        function add_payment(){
                            let error = "";

                            const paymentMethod = document.getElementById('paymentMethod').value;
                            const primaryAmount = parseFloat(document.getElementById('primaryAmount').value.replaceAll(',',''));
                            const paymentAmount = parseFloat(document.getElementById('paymentAmount').value.replaceAll(',',''));
                            const paymentDiscount = parseFloat(document.getElementById('paymentDiscount').value.replaceAll(',',''));

                            if(paymentMethod === "" || paymentMethod === null || paymentMethod === "انتخاب کنید." || paymentMethod === "NA"){
                                error = "روش مشخص نشده است.";
                            }
                            if(paymentDiscount > primaryAmount){
                                error = "تخفیف بیشتر از مبلغ کل هست.";
                            }
                            installments = [];
                            if(document.getElementById('paymentMethod').value === "اقساط"){
                                console.log('dddddd');
                                for (const rowElement of document.querySelectorAll('.installment-row')) {
                                    let installment = {}
                                    installment['amount'] = parseFloat(rowElement.querySelector('.installment_amount').value.replaceAll(',',''));
                                    installment['date'] = rowElement.querySelector('.installment_due_date').value;
                                    installment['status'] = rowElement.querySelector('.installment_status').value;
                                    installments.push(installment);
                                }
                                let installmentsAmount = 0;
                                for (const installment of installments) {
                                    installmentsAmount += installment['amount']
                                }
                                if(installmentsAmount === 0 || installmentsAmount === null || installmentsAmount === undefined || isNaN(installmentsAmount)){
                                    error =  "قسطی وارد نشده است."
                                }
                                if(installmentsAmount < paymentAmount){
                                    error = "مجموع مبالغ اقساط از مبلغ قابل پرداخت بیمار کمتر است."
                                }
                                if(installmentsAmount > paymentAmount){
                                    error = "مجموع مبالغ اقساط از مبلغ قابل پرداخت بیمار بیشتر است."
                                }
                            }
                            else {

                            }
                            if(error === ""){
                                let done_treatments_selected = [];
                                let checkboxes = document.querySelectorAll('.done_treatment_select');
                                for (const checkbox of checkboxes) {
                                    if (checkbox.checked) {
                                        done_treatments_selected.push(checkbox.id);
                                    }
                                }
                                const formData = new FormData();
                                formData.append('action', 'add_payment');
                                formData.append('method', paymentMethod);
                                formData.append('primaryAmount', primaryAmount);
                                formData.append('finalAmount', paymentAmount);
                                formData.append('discountAmount', paymentDiscount);
                                formData.append('done_treatments_codes', JSON.stringify(done_treatments_selected));
                                formData.append('installments', JSON.stringify(installments));
                                formData.append('notes', document.getElementById('paymentNote').value);
                                formData.append('paid_date', document.getElementById('flatpickr-datetime4').value);
                                formData.append('pcode', '<?=htmlspecialchars($patient_code)?>');

                                fetch('<?=ROOT?>functions/cases_funcs.php', {
                                    method: 'POST',
                                    body: formData
                                })
                                    .then(r => r.json())
                                    .then(data => {
                                        console.log(data);
                                        if (data.data === "success") {
                                            Swal.fire({
                                                icon: 'success',
                                                title: 'موفق!',
                                                text: data.message || 'پرداختی با موفقیت افزوده شد.',
                                                confirmButtonText: 'باشه',
                                                customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                            });
                                            $('.datatable-invoices').DataTable().ajax.reload();
                                            const modalEl = document.getElementById('addNewPayment');
                                            const modal = bootstrap.Modal.getOrCreateInstance(modalEl);
                                            modal.hide();
                                            form.reset();
                                        } else {
                                            Swal.fire({
                                                icon: 'error',
                                                title: 'خطا',
                                                text: data.error || 'خطا در ذخیره پرداختی',
                                                confirmButtonText: 'باشه',
                                                customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                            });
                                        }
                                    })
                                    .catch(() => {

                                    });
                            }
                            else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'خطا!',
                                    text: error,
                                    confirmButtonText: 'باشه',
                                    customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                });
                            }

                        }
                        function edit_payment(){
                            let error = "";

                            const payment_code = document.getElementById('payment_code').value;
                            const paymentMethod = document.getElementById('paymentMethod').value;
                            const primaryAmount = parseFloat(document.getElementById('primaryAmount').value.replaceAll(',',''));
                            const paymentAmount = parseFloat(document.getElementById('paymentAmount').value.replaceAll(',',''));
                            const paymentDiscount = parseFloat(document.getElementById('paymentDiscount').value.replaceAll(',',''));

                            if(paymentMethod === "" || paymentMethod === null || paymentMethod === "انتخاب کنید." || paymentMethod === "NA"){
                                error = "روش مشخص نشده است.";
                            }
                            if(paymentDiscount > primaryAmount){
                                error = "تخفیف بیشتر از مبلغ کل هست.";
                            }
                            installments = [];
                            if(document.getElementById('paymentMethod').value === "اقساط"){
                                console.log('dddddd');
                                for (const rowElement of document.querySelectorAll('.installment-row')) {
                                    let installment = {}
                                    installment['amount'] = parseFloat(rowElement.querySelector('.installment_amount').value.replaceAll(',',''));
                                    installment['date'] = rowElement.querySelector('.installment_due_date').value;
                                    installment['status'] = rowElement.querySelector('.installment_status').value;
                                    installments.push(installment);
                                }
                                let installmentsAmount = 0;
                                for (const installment of installments) {
                                    installmentsAmount += installment['amount']
                                }
                                if(installmentsAmount === 0 || installmentsAmount === null || installmentsAmount === undefined || isNaN(installmentsAmount)){
                                    error =  "قسطی وارد نشده است."
                                }
                                if(installmentsAmount < paymentAmount){
                                    error = "مجموع مبالغ اقساط از مبلغ قابل پرداخت بیمار کمتر است."
                                }
                                if(installmentsAmount > paymentAmount){
                                    error = "مجموع مبالغ اقساط از مبلغ قابل پرداخت بیمار بیشتر است."
                                }
                            }
                            else {

                            }
                            if(error === ""){
                                let done_treatments_selected = [];
                                let checkboxes = document.querySelectorAll('.done_treatment_select');
                                for (const checkbox of checkboxes) {
                                    if (checkbox.checked) {
                                        done_treatments_selected.push(checkbox.id);
                                    }
                                }
                                const formData = new FormData();
                                formData.append('action', 'edit_payment');
                                formData.append('payment_code', payment_code);
                                formData.append('method', paymentMethod);
                                formData.append('primaryAmount', primaryAmount);
                                formData.append('finalAmount', paymentAmount);
                                formData.append('discountAmount', paymentDiscount);
                                formData.append('done_treatments_codes', JSON.stringify(done_treatments_selected));
                                formData.append('installments', JSON.stringify(installments));
                                formData.append('notes', document.getElementById('paymentNote').value);
                                formData.append('paid_date', document.getElementById('flatpickr-datetime4').value);
                                formData.append('pcode', '<?=htmlspecialchars($patient_code)?>');

                                fetch('<?=ROOT?>functions/cases_funcs.php', {
                                    method: 'POST',
                                    body: formData
                                })
                                    .then(r => r.json())
                                    .then(data => {
                                        console.log(data);
                                        if (data.data === "success") {
                                            Swal.fire({
                                                icon: 'success',
                                                title: 'موفق!',
                                                text: data.message || 'پرداختی با موفقیت ویرایش شد.',
                                                confirmButtonText: 'باشه',
                                                customClass: { confirmButton: 'btn btn-success waves-effect waves-light' }
                                            });
                                            $('.datatable-invoices').DataTable().ajax.reload();
                                            const modalEl = document.getElementById('addNewPayment');
                                            const modal = bootstrap.Modal.getOrCreateInstance(modalEl);
                                            modal.hide();
                                            form.reset();
                                        } else {
                                            Swal.fire({
                                                icon: 'error',
                                                title: 'خطا',
                                                text: data.error || 'خطا در ذخیره پرداختی',
                                                confirmButtonText: 'باشه',
                                                customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                            });
                                        }
                                    })
                                    .catch(() => {

                                    });
                            }
                            else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'خطا!',
                                    text: error,
                                    confirmButtonText: 'باشه',
                                    customClass: { confirmButton: 'btn btn-danger waves-effect waves-light' }
                                });
                            }

                        }
                    </script>
                    <div aria-hidden="true" class="modal fade" id="editTreatmentModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="modalCenterTitle">ویرایش طرح درمان</h5>
                                    <button aria-label="بستن" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="row g-3 mt-2">
                                        <div class="col-12 col-md-6 col-lg-6">
                                            <h6 class="mt-5 text-center">انتخاب دندان یا فک</h6>
                                            <div class="large-6 columns chart">
                                                <div class="row">
                                                    <div class="position-relative d-flex justify-content-center align-items-center" style="height: 432px;">
                                                        <button id="secondarybtn" class="btn btn-primary" type="button" onclick="change_dentition(this)" style="position: absolute;top:45%;transform: translate(-50%, -50%);right: 0;">اصلی</button>
                                                        <button id="primarybtn" class="btn" type="button" onclick="change_dentition(this)" style="position: absolute;top:55%;transform: translate(-50%, -50%);right: 0;">شیری</button>
                                                        <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
                                                        <div style="margin-right: 100px;">
                                                            <button id="slctJawUBTN" class="btn btn-outline-primary" type="button" onclick="select_jaw(this,'u')" style="font-size: 12px;position: absolute;top: 30%;right: 50%;">کل فک بالا</button>
                                                            <button id="slctJawLBTN" class="btn btn-outline-primary" type="button" onclick="select_jaw(this,'l')" style="font-size: 12px;position: absolute;top: 60%;right: 49%;">کل فک پایین</button>
                                                            <div id="SecondaryDentition">
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="222" style="shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 395 371">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>

                                                                    <g>
                                                                        <path id="ur1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 170.5,16.5 C 176.176,16.3339 181.843,16.5006 187.5,17C 194.813,17.6524 197.313,21.4858 195,28.5C 191.465,54.1863 179.298,59.353 158.5,44C 154.248,40.4187 150.748,36.252 148,31.5C 146.707,27.4179 147.874,24.2513 151.5,22C 157.736,19.3625 164.069,17.5292 170.5,16.5 Z" />
                                                                        <text id="tur1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="170" y="35">1</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 206.5,16.5 C 218.151,15.7122 229.485,17.2122 240.5,21C 247.535,25.0465 248.369,30.2131 243,36.5C 236.929,43.2457 229.762,48.4123 221.5,52C 213.996,54.1593 208.163,51.9927 204,45.5C 200.074,37.6072 198.407,29.2739 199,20.5C 201.255,18.5012 203.755,17.1679 206.5,16.5 Z" />
                                                                        <text id="tul1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="220" y="35">1</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 136.5,32.5 C 140.516,31.8999 144.016,32.8999 147,35.5C 151.264,43.8106 152.264,52.4773 150,61.5C 146.345,68.0702 140.845,70.2368 133.5,68C 103.245,53.5208 104.245,41.6875 136.5,32.5 Z" />
                                                                        <text id="tur2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="140" y="50">2</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 250.5,32.5 C 262.156,32.8822 272.323,36.8822 281,44.5C 282.894,48.8494 282.227,52.8494 279,56.5C 272.387,62.9587 264.554,66.9587 255.5,68.5C 246.388,67.5425 242.055,62.3758 242.5,53C 242.947,48.4299 243.781,43.9299 245,39.5C 245.967,36.3794 247.8,34.046 250.5,32.5 Z" />
                                                                        <text id="tul2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="265" y="50">2</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 100.5,55.5 C 114.509,57.6616 124.342,65.3282 130,78.5C 130.956,82.572 130.456,86.4054 128.5,90C 118.12,93.3327 107.787,92.9994 97.5,89C 88.9226,83.3861 86.756,75.8861 91,66.5C 92.654,61.3576 95.8207,57.6909 100.5,55.5 Z" />
                                                                        <text id="tur3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="110" y="75">3</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 288.5,55.5 C 293.247,55.1357 297.081,56.8023 300,60.5C 304.379,67.452 305.712,74.7853 304,82.5C 294.496,90.9458 283.329,94.1125 270.5,92C 265.294,91.2621 262.961,88.2621 263.5,83C 263.517,79.6171 264.35,76.4505 266,73.5C 271.673,64.9703 279.173,58.9703 288.5,55.5 Z" />
                                                                        <text id="tul3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="285" y="75">3</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 94.5,90.5 C 106.243,98.3422 108.743,108.676 102,121.5C 97.5757,129.958 90.7423,132.791 81.5,130C 73.5614,127.391 67.3947,122.558 63,115.5C 59.0218,103.742 62.8551,95.9087 74.5,92C 81.3125,90.5394 87.9792,90.0394 94.5,90.5 Z" />
                                                                        <text id="tur4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="90" y="110">4</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 299.5,90.5 C 306.021,90.0394 312.688,90.5394 319.5,92C 331.145,95.9087 334.978,103.742 331,115.5C 323.988,126.922 313.822,131.755 300.5,130C 294.285,125.775 290.451,119.942 289,112.5C 287.41,102.681 290.91,95.3481 299.5,90.5 Z" />
                                                                        <text id="tul4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="305" y="110">4</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 61.5,127.5 C 86.831,126.631 95.331,137.964 87,161.5C 80.2346,171.502 71.0679,174.336 59.5,170C 44.2257,164.287 39.059,153.787 44,138.5C 48.5194,132.661 54.3527,128.995 61.5,127.5 Z" />
                                                                        <text id="tur5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="65" y="150">5</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 323.5,127.5 C 332.881,126.604 341.048,129.271 348,135.5C 355.609,148.351 353.109,158.851 340.5,167C 321.514,177.248 309.348,172.081 304,151.5C 302.052,144.135 303.885,137.968 309.5,133C 314.017,130.445 318.684,128.612 323.5,127.5 Z" />
                                                                        <text id="tul5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="330" y="150">5</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 50.5,171.5 C 56.5281,172.077 62.5281,172.911 68.5,174C 76.1223,175.999 78.6223,180.832 76,188.5C 74.1229,198.248 71.1229,207.582 67,216.5C 62.2191,219.363 57.0524,220.196 51.5,219C 44.0164,217.698 37.0164,215.031 30.5,211C 27.6107,205.879 26.7773,200.379 28,194.5C 29.0376,186.587 32.5376,180.087 38.5,175C 42.6227,173.808 46.6227,172.641 50.5,171.5 Z" />
                                                                        <text id="tur6" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="50" y="195">6</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 339.5,171.5 C 355.091,171.379 363.924,179.046 366,194.5C 368.888,205.903 364.721,213.07 353.5,216C 349.634,216.502 345.967,217.502 342.5,219C 337.232,220.068 332.232,219.401 327.5,217C 326.789,215.745 325.956,214.579 325,213.5C 320.902,202.119 318.568,190.452 318,178.5C 319.952,176.106 322.452,174.606 325.5,174C 330.315,173.197 334.981,172.363 339.5,171.5 Z" />
                                                                        <text id="tul6" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="340" y="195">6</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 31.5,219.5 C 42.8799,219.809 53.8799,221.976 64.5,226C 67.8575,228.693 69.1908,232.193 68.5,236.5C 68.037,245.877 67.2036,255.21 66,264.5C 63.538,270.487 59.038,273.654 52.5,274C 43.3932,274.793 34.3932,274.126 25.5,272C 22.0879,270.545 18.9212,268.712 16,266.5C 14.0771,263.456 13.2438,260.123 13.5,256.5C 13.8723,245.121 16.7056,234.454 22,224.5C 24.9074,222.132 28.0741,220.465 31.5,219.5 Z" />
                                                                        <text id="tur7" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="40" y="245">7</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 355.5,219.5 C 363.317,218.646 369.483,221.312 374,227.5C 378.702,238.714 380.702,250.381 380,262.5C 376.551,268.324 371.384,271.824 364.5,273C 355.152,274.869 345.819,274.869 336.5,273C 332.333,271.5 329.5,268.667 328,264.5C 326.395,253.217 325.728,241.884 326,230.5C 327.167,228 329,226.167 331.5,225C 339.5,222.57 347.5,220.737 355.5,219.5 Z" />
                                                                        <text id="tul7" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="355" y="245">7</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ur8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 14.5,278.5 C 24.8387,278.334 35.172,278.5 45.5,279C 52.5535,279.721 56.7202,283.554 58,290.5C 58.2785,296.957 59.2785,303.29 61,309.5C 63.2901,316.64 61.1234,321.807 54.5,325C 43.0487,328.264 31.3821,329.264 19.5,328C 10.3639,325.948 5.86392,320.114 6,310.5C 5.33333,303.5 5.33333,296.5 6,289.5C 6.8138,284.196 9.64713,280.529 14.5,278.5 Z" />
                                                                        <text id="tur8" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="30" y="300">8</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="ul8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 348.5,278.5 C 358.839,278.334 369.172,278.5 379.5,279C 384.551,280.717 387.385,284.217 388,289.5C 389.042,299.635 388.375,309.635 386,319.5C 383.934,324.626 380.1,327.459 374.5,328C 362.618,329.264 350.951,328.264 339.5,325C 332.877,321.807 330.71,316.64 333,309.5C 334.661,301.894 335.994,294.227 337,286.5C 339.485,281.749 343.319,279.082 348.5,278.5 Z" />
                                                                        <text id="tul8" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="360" y="300">8</text>
                                                                    </g>

                                                                </svg>
                                                                <br>
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="222" style="margin-top: -36px;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 395 371">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>
                                                                    <!-- Rotated teeth paths -->
                                                                    <g transform="rotate(180 197.5 185.5)">
                                                                        <path id="ll1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 170.5,16.5 C 176.176,16.3339 181.843,16.5006 187.5,17C 194.813,17.6524 197.313,21.4858 195,28.5C 191.465,54.1863 179.298,59.353 158.5,44C 154.248,40.4187 150.748,36.252 148,31.5C 146.707,27.4179 147.874,24.2513 151.5,22C 157.736,19.3625 164.069,17.5292 170.5,16.5 Z" />
                                                                        <path id="lr1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 206.5,16.5 C 218.151,15.7122 229.485,17.2122 240.5,21C 247.535,25.0465 248.369,30.2131 243,36.5C 236.929,43.2457 229.762,48.4123 221.5,52C 213.996,54.1593 208.163,51.9927 204,45.5C 200.074,37.6072 198.407,29.2739 199,20.5C 201.255,18.5012 203.755,17.1679 206.5,16.5 Z" />
                                                                        <path id="ll2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 136.5,32.5 C 140.516,31.8999 144.016,32.8999 147,35.5C 151.264,43.8106 152.264,52.4773 150,61.5C 146.345,68.0702 140.845,70.2368 133.5,68C 103.245,53.5208 104.245,41.6875 136.5,32.5 Z" />
                                                                        <path id="lr2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 250.5,32.5 C 262.156,32.8822 272.323,36.8822 281,44.5C 282.894,48.8494 282.227,52.8494 279,56.5C 272.387,62.9587 264.554,66.9587 255.5,68.5C 246.388,67.5425 242.055,62.3758 242.5,53C 242.947,48.4299 243.781,43.9299 245,39.5C 245.967,36.3794 247.8,34.046 250.5,32.5 Z" />
                                                                        <path id="ll3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 100.5,55.5 C 114.509,57.6616 124.342,65.3282 130,78.5C 130.956,82.572 130.456,86.4054 128.5,90C 118.12,93.3327 107.787,92.9994 97.5,89C 88.9226,83.3861 86.756,75.8861 91,66.5C 92.654,61.3576 95.8207,57.6909 100.5,55.5 Z" />
                                                                        <path id="lr3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 288.5,55.5 C 293.247,55.1357 297.081,56.8023 300,60.5C 304.379,67.452 305.712,74.7853 304,82.5C 294.496,90.9458 283.329,94.1125 270.5,92C 265.294,91.2621 262.961,88.2621 263.5,83C 263.517,79.6171 264.35,76.4505 266,73.5C 271.673,64.9703 279.173,58.9703 288.5,55.5 Z" />
                                                                        <path id="ll4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 94.5,90.5 C 106.243,98.3422 108.743,108.676 102,121.5C 97.5757,129.958 90.7423,132.791 81.5,130C 73.5614,127.391 67.3947,122.558 63,115.5C 59.0218,103.742 62.8551,95.9087 74.5,92C 81.3125,90.5394 87.9792,90.0394 94.5,90.5 Z" />
                                                                        <path id="lr4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 299.5,90.5 C 306.021,90.0394 312.688,90.5394 319.5,92C 331.145,95.9087 334.978,103.742 331,115.5C 323.988,126.922 313.822,131.755 300.5,130C 294.285,125.775 290.451,119.942 289,112.5C 287.41,102.681 290.91,95.3481 299.5,90.5 Z" />
                                                                        <path id="ll5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 61.5,127.5 C 86.831,126.631 95.331,137.964 87,161.5C 80.2346,171.502 71.0679,174.336 59.5,170C 44.2257,164.287 39.059,153.787 44,138.5C 48.5194,132.661 54.3527,128.995 61.5,127.5 Z" />
                                                                        <path id="lr5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 323.5,127.5 C 332.881,126.604 341.048,129.271 348,135.5C 355.609,148.351 353.109,158.851 340.5,167C 321.514,177.248 309.348,172.081 304,151.5C 302.052,144.135 303.885,137.968 309.5,133C 314.017,130.445 318.684,128.612 323.5,127.5 Z" />
                                                                        <path id="ll6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 50.5,171.5 C 56.5281,172.077 62.5281,172.911 68.5,174C 76.1223,175.999 78.6223,180.832 76,188.5C 74.1229,198.248 71.1229,207.582 67,216.5C 62.2191,219.363 57.0524,220.196 51.5,219C 44.0164,217.698 37.0164,215.031 30.5,211C 27.6107,205.879 26.7773,200.379 28,194.5C 29.0376,186.587 32.5376,180.087 38.5,175C 42.6227,173.808 46.6227,172.641 50.5,171.5 Z" />
                                                                        <path id="lr6" onclick="tooth_select(this)" style="opacity:0.958;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 339.5,171.5 C 355.091,171.379 363.924,179.046 366,194.5C 368.888,205.903 364.721,213.07 353.5,216C 349.634,216.502 345.967,217.502 342.5,219C 337.232,220.068 332.232,219.401 327.5,217C 326.789,215.745 325.956,214.579 325,213.5C 320.902,202.119 318.568,190.452 318,178.5C 319.952,176.106 322.452,174.606 325.5,174C 330.315,173.197 334.981,172.363 339.5,171.5 Z" />
                                                                        <path id="ll7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 31.5,219.5 C 42.8799,219.809 53.8799,221.976 64.5,226C 67.8575,228.693 69.1908,232.193 68.5,236.5C 68.037,245.877 67.2036,255.21 66,264.5C 63.538,270.487 59.038,273.654 52.5,274C 43.3932,274.793 34.3932,274.126 25.5,272C 22.0879,270.545 18.9212,268.712 16,266.5C 14.0771,263.456 13.2438,260.123 13.5,256.5C 13.8723,245.121 16.7056,234.454 22,224.5C 24.9074,222.132 28.0741,220.465 31.5,219.5 Z" />
                                                                        <path id="lr7" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 355.5,219.5 C 363.317,218.646 369.483,221.312 374,227.5C 378.702,238.714 380.702,250.381 380,262.5C 376.551,268.324 371.384,271.824 364.5,273C 355.152,274.869 345.819,274.869 336.5,273C 332.333,271.5 329.5,268.667 328,264.5C 326.395,253.217 325.728,241.884 326,230.5C 327.167,228 329,226.167 331.5,225C 339.5,222.57 347.5,220.737 355.5,219.5 Z" />
                                                                        <path id="ll8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 14.5,278.5 C 24.8387,278.334 35.172,278.5 45.5,279C 52.5535,279.721 56.7202,283.554 58,290.5C 58.2785,296.957 59.2785,303.29 61,309.5C 63.2901,316.64 61.1234,321.807 54.5,325C 43.0487,328.264 31.3821,329.264 19.5,328C 10.3639,325.948 5.86392,320.114 6,310.5C 5.33333,303.5 5.33333,296.5 6,289.5C 6.8138,284.196 9.64713,280.529 14.5,278.5 Z" />
                                                                        <path id="lr8" onclick="tooth_select(this)" style="opacity:0.954;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="3" d="M 348.5,278.5 C 358.839,278.334 369.172,278.5 379.5,279C 384.551,280.717 387.385,284.217 388,289.5C 389.042,299.635 388.375,309.635 386,319.5C 383.934,324.626 380.1,327.459 374.5,328C 362.618,329.264 350.951,328.264 339.5,325C 332.877,321.807 330.71,316.64 333,309.5C 334.661,301.894 335.994,294.227 337,286.5C 339.485,281.749 343.319,279.082 348.5,278.5 Z" />
                                                                    </g>

                                                                    <!-- Upright text labels -->
                                                                    <text id="tll1" onclick="tooth_select(document.getElementById('ll1'))" x="224.5" y="344.5" style="cursor:pointer;">1</text>
                                                                    <text id="tlr1" onclick="tooth_select(document.getElementById('lr1'))" x="174.5" y="344.5" style="cursor:pointer;">1</text>
                                                                    <text id="tll2" onclick="tooth_select(document.getElementById('ll2'))" x="260.5" y="328.5" style="cursor:pointer;">2</text>
                                                                    <text id="tlr2" onclick="tooth_select(document.getElementById('lr2'))" x="134.5" y="328.5" style="cursor:pointer;">2</text>
                                                                    <text id="tll3" onclick="tooth_select(document.getElementById('ll3'))" x="284.5" y="298.5" style="cursor:pointer;">3</text>
                                                                    <text id="tlr3" onclick="tooth_select(document.getElementById('lr3'))" x="110.5" y="298.5" style="cursor:pointer;">3</text>
                                                                    <text id="tll4" onclick="tooth_select(document.getElementById('ll4'))" x="310.5" y="260.5" style="cursor:pointer;">4</text>
                                                                    <text id="tlr4" onclick="tooth_select(document.getElementById('lr4'))" x="84.5" y="260.5" style="cursor:pointer;">4</text>
                                                                    <text id="tll5" onclick="tooth_select(document.getElementById('ll5'))" x="330.5" y="223.5" style="cursor:pointer;">5</text>
                                                                    <text id="tlr5" onclick="tooth_select(document.getElementById('lr5'))" x="64.5" y="223.5" style="cursor:pointer;">5</text>
                                                                    <text id="tll6" onclick="tooth_select(document.getElementById('ll6'))" x="344.5" y="180.5" style="cursor:pointer;">6</text>
                                                                    <text id="tlr6" onclick="tooth_select(document.getElementById('lr6'))" x="50.5" y="180.5" style="cursor:pointer;">6</text>
                                                                    <text id="tll7" onclick="tooth_select(document.getElementById('ll7'))" x="355.5" y="127.5" style="cursor:pointer;">7</text>
                                                                    <text id="tlr7" onclick="tooth_select(document.getElementById('lr7'))" x="39.5" y="127.5" style="cursor:pointer;">7</text>
                                                                    <text id="tll8" onclick="tooth_select(document.getElementById('ll8'))" x="365.5" y="71.5" style="cursor:pointer;">8</text>
                                                                    <text id="tlr8" onclick="tooth_select(document.getElementById('lr8'))" x="29.5" y="71.5" style="cursor:pointer;">8</text>
                                                                </svg>
                                                            </div>
                                                            <div id="PrimaryDentition" class="d-none">
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="161" style="z-index: 9999;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 237 161">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>

                                                                    <g>
                                                                        <path id="cur1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 101.5,12.5 C 107.061,11.8024 112.227,12.8024 117,15.5C 117.692,24.0905 115.192,31.5905 109.5,38C 98.9657,37.8431 91.1324,33.0097 86,23.5C 85.0799,20.6917 85.9133,18.5251 88.5,17C 92.8335,15.181 97.1668,13.681 101.5,12.5 Z"/>
                                                                        <text id="tcur1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="101" y="25">A</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 123.5,12.5 C 130.327,12.1241 136.994,12.9574 143.5,15C 146.249,16.1227 148.749,17.6227 151,19.5C 151.667,20.8333 151.667,22.1667 151,23.5C 146.737,29.7647 141.237,34.598 134.5,38C 130.495,39.0981 126.995,38.2648 124,35.5C 120.613,29.2317 119.28,22.565 120,15.5C 121.145,14.3636 122.312,13.3636 123.5,12.5 Z"/>
                                                                        <text id="tcul1" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="135" y="25">A</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 75.5,21.5 C 77.8568,21.3367 80.1902,21.5034 82.5,22C 87.1827,28.4194 88.6827,35.586 87,43.5C 86.1667,45.6667 84.6667,47.1667 82.5,48C 79.0717,48.7011 75.7383,48.3677 72.5,47C 67.6977,44.1927 63.531,40.6927 60,36.5C 58.8238,32.7399 59.9904,29.9066 63.5,28C 67.4339,25.5361 71.4339,23.3694 75.5,21.5 Z"/>
                                                                        <text id="tcur2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="75" y="35">B</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 154.5,21.5 C 163.565,22.1165 171.065,25.7831 177,32.5C 177.667,33.8333 177.667,35.1667 177,36.5C 172.457,41.1866 167.291,45.02 161.5,48C 156.269,49.7238 152.435,48.2238 150,43.5C 148.255,35.3554 149.755,28.0221 154.5,21.5 Z"/>
                                                                        <text id="tcul2" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="165" y="35">B</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 53.5,41.5 C 66.1955,41.0255 71.6955,47.0255 70,59.5C 69.0794,64.2609 66.246,66.5942 61.5,66.5C 52.1421,65.2939 44.6421,60.9606 39,53.5C 38.3131,51.0797 38.8131,48.913 40.5,47C 44.7239,44.7065 49.0572,42.8731 53.5,41.5 Z"/>
                                                                        <text id="tcur3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="55" y="55">C</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 174.5,41.5 C 181.446,41.7364 188.113,43.2364 194.5,46C 197.29,48.2103 198.123,51.0437 197,54.5C 190.087,62.8758 181.253,66.7092 170.5,66C 168.959,64.4207 167.792,62.5873 167,60.5C 164.359,51.8685 166.859,45.5352 174.5,41.5 Z"/>
                                                                        <text id="tcul3" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="180" y="55">C</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 29.5,98.5 C 28.0697,97.4625 26.403,96.7959 24.5,96.5C 22.563,95.0686 20.7297,93.4019 19,91.5C 18.3333,89.1667 18.3333,86.8333 19,84.5C 22.5766,78.1077 25.5766,71.4411 28,64.5C 29.8333,62.6667 31.6667,60.8333 33.5,59C 35.5,58.3333 37.5,58.3333 39.5,59C 44.6037,61.7734 49.437,64.9401 54,68.5C 56.4839,80.0585 53.3172,89.8919 44.5,98C 39.5806,99.7781 34.5806,99.9448 29.5,98.5 Z"/>
                                                                        <text id="tcur4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="35" y="85">D</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 196.5,58.5 C 201.347,57.8404 205.181,59.5071 208,63.5C 211.397,71.7846 214.897,79.9513 218.5,88C 218.481,91.0334 217.148,93.3667 214.5,95C 207.87,98.4089 200.87,99.7422 193.5,99C 184.829,91.4893 180.662,81.9893 181,70.5C 185.784,65.8752 190.951,61.8752 196.5,58.5 Z"/>
                                                                        <text id="tcul4" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="200" y="75">D</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cur5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 16.5,98.5 C 20.5483,98.3946 24.5483,98.7279 28.5,99.5C 32.6546,100.099 36.6546,101.265 40.5,103C 42.0412,104.579 43.2078,106.413 44,108.5C 42.4797,117.737 42.1464,127.07 43,136.5C 41.1667,141 38,144.167 33.5,146C 22.8381,148.532 13.6715,146.032 6,138.5C 4.94295,135.793 4.44295,132.96 4.5,130C 6.37616,122.313 7.54283,114.479 8,106.5C 9.44748,102.215 12.2808,99.5484 16.5,98.5 Z"/>
                                                                        <text id="tcur5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="20" y="120">E</text>
                                                                    </g>

                                                                    <g>
                                                                        <path id="cul5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 214.5,97.5 C 220.957,96.9749 225.457,99.6416 228,105.5C 229.043,112.213 230.377,118.88 232,125.5C 233.968,138.209 228.468,145.042 215.5,146C 197.04,147.979 190.04,139.813 194.5,121.5C 190.959,114.151 191.959,107.651 197.5,102C 203.343,100.673 209.01,99.1727 214.5,97.5 Z"/>
                                                                        <text id="tcul5" style="cursor:pointer;" onclick="tooth_select(this.parentElement.children[0])" x="215" y="120">E</text>
                                                                    </g>
                                                                </svg>
                                                                <br>
                                                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="237" height="161" style="margin-top: -20px;shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 237 161">
                                                                    <style>
                                                                        text {
                                                                            font-family: Arial;
                                                                            font-size: 16px;
                                                                            font-weight: bold;
                                                                            fill: black;
                                                                            text-anchor: middle;
                                                                            dominant-baseline: middle;
                                                                        }
                                                                    </style>

                                                                    <!-- Rotated teeth paths -->
                                                                    <g transform="rotate(180 118.5 80.5)">
                                                                        <path id="cll1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 101.5,12.5 C 107.061,11.8024 112.227,12.8024 117,15.5C 117.692,24.0905 115.192,31.5905 109.5,38C 98.9657,37.8431 91.1324,33.0097 86,23.5C 85.0799,20.6917 85.9133,18.5251 88.5,17C 92.8335,15.181 97.1668,13.681 101.5,12.5 Z"/>
                                                                        <path id="clr1" onclick="tooth_select(this)" style="opacity:0.936;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 123.5,12.5 C 130.327,12.1241 136.994,12.9574 143.5,15C 146.249,16.1227 148.749,17.6227 151,19.5C 151.667,20.8333 151.667,22.1667 151,23.5C 146.737,29.7647 141.237,34.598 134.5,38C 130.495,39.0981 126.995,38.2648 124,35.5C 120.613,29.2317 119.28,22.565 120,15.5C 121.145,14.3636 122.312,13.3636 123.5,12.5 Z"/>
                                                                        <path id="cll2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 75.5,21.5 C 77.8568,21.3367 80.1902,21.5034 82.5,22C 87.1827,28.4194 88.6827,35.586 87,43.5C 86.1667,45.6667 84.6667,47.1667 82.5,48C 79.0717,48.7011 75.7383,48.3677 72.5,47C 67.6977,44.1927 63.531,40.6927 60,36.5C 58.8238,32.7399 59.9904,29.9066 63.5,28C 67.4339,25.5361 71.4339,23.3694 75.5,21.5 Z"/>
                                                                        <path id="clr2" onclick="tooth_select(this)" style="opacity:0.93;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 154.5,21.5 C 163.565,22.1165 171.065,25.7831 177,32.5C 177.667,33.8333 177.667,35.1667 177,36.5C 172.457,41.1866 167.291,45.02 161.5,48C 156.269,49.7238 152.435,48.2238 150,43.5C 148.255,35.3554 149.755,28.0221 154.5,21.5 Z"/>
                                                                        <path id="cll3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 53.5,41.5 C 66.1955,41.0255 71.6955,47.0255 70,59.5C 69.0794,64.2609 66.246,66.5942 61.5,66.5C 52.1421,65.2939 44.6421,60.9606 39,53.5C 38.3131,51.0797 38.8131,48.913 40.5,47C 44.7239,44.7065 49.0572,42.8731 53.5,41.5 Z"/>
                                                                        <path id="clr3" onclick="tooth_select(this)" style="opacity:0.941;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 174.5,41.5 C 181.446,41.7364 188.113,43.2364 194.5,46C 197.29,48.2103 198.123,51.0437 197,54.5C 190.087,62.8758 181.253,66.7092 170.5,66C 168.959,64.4207 167.792,62.5873 167,60.5C 164.359,51.8685 166.859,45.5352 174.5,41.5 Z"/>
                                                                        <path id="cll4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 29.5,98.5 C 28.0697,97.4625 26.403,96.7959 24.5,96.5C 22.563,95.0686 20.7297,93.4019 19,91.5C 18.3333,89.1667 18.3333,86.8333 19,84.5C 22.5766,78.1077 25.5766,71.4411 28,64.5C 29.8333,62.6667 31.6667,60.8333 33.5,59C 35.5,58.3333 37.5,58.3333 39.5,59C 44.6037,61.7734 49.437,64.9401 54,68.5C 56.4839,80.0585 53.3172,89.8919 44.5,98C 39.5806,99.7781 34.5806,99.9448 29.5,98.5 Z"/>
                                                                        <path id="clr4" onclick="tooth_select(this)" style="opacity:0.953;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 196.5,58.5 C 201.347,57.8404 205.181,59.5071 208,63.5C 211.397,71.7846 214.897,79.9513 218.5,88C 218.481,91.0334 217.148,93.3667 214.5,95C 207.87,98.4089 200.87,99.7422 193.5,99C 184.829,91.4893 180.662,81.9893 181,70.5C 185.784,65.8752 190.951,61.8752 196.5,58.5 Z"/>
                                                                        <path id="cll5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 16.5,98.5 C 20.5483,98.3946 24.5483,98.7279 28.5,99.5C 32.6546,100.099 36.6546,101.265 40.5,103C 42.0412,104.579 43.2078,106.413 44,108.5C 42.4797,117.737 42.1464,127.07 43,136.5C 41.1667,141 38,144.167 33.5,146C 22.8381,148.532 13.6715,146.032 6,138.5C 4.94295,135.793 4.44295,132.96 4.5,130C 6.37616,122.313 7.54283,114.479 8,106.5C 9.44748,102.215 12.2808,99.5484 16.5,98.5 Z"/>
                                                                        <path id="clr5" onclick="tooth_select(this)" style="opacity:0.945;cursor: pointer;" fill="#ffffff" stroke="#000000" stroke-width="2" d="M 214.5,97.5 C 220.957,96.9749 225.457,99.6416 228,105.5C 229.043,112.213 230.377,118.88 232,125.5C 233.968,138.209 228.468,145.042 215.5,146C 197.04,147.979 190.04,139.813 194.5,121.5C 190.959,114.151 191.959,107.651 197.5,102C 203.343,100.673 209.01,99.1727 214.5,97.5 Z"/>
                                                                    </g>

                                                                    <!-- Upright text labels -->
                                                                    <text id="tcll1" onclick="tooth_select(document.getElementById('cll1'))" x="135" y="140" style="cursor:pointer;">A</text>
                                                                    <text id="tclr1" onclick="tooth_select(document.getElementById('clr1'))" x="101" y="140" style="cursor:pointer;">A</text>
                                                                    <text id="tcll2" onclick="tooth_select(document.getElementById('cll2'))" x="165" y="130" style="cursor:pointer;">B</text>
                                                                    <text id="tclr2" onclick="tooth_select(document.getElementById('clr2'))" x="75" y="130" style="cursor:pointer;">B</text>
                                                                    <text id="tcll3" onclick="tooth_select(document.getElementById('cll3'))" x="180" y="110" style="cursor:pointer;">C</text>
                                                                    <text id="tclr3" onclick="tooth_select(document.getElementById('clr3'))" x="55" y="110" style="cursor:pointer;">C</text>
                                                                    <text id="tcll4" onclick="tooth_select(document.getElementById('cll4'))" x="200" y="80" style="cursor:pointer;">D</text>
                                                                    <text id="tclr4" onclick="tooth_select(document.getElementById('clr4'))" x="35" y="80" style="cursor:pointer;">D</text>
                                                                    <text id="tcll5" onclick="tooth_select(document.getElementById('cll5'))" x="215" y="40" style="cursor:pointer;">E</text>
                                                                    <text id="tclr5" onclick="tooth_select(document.getElementById('clr5'))" x="20" y="40" style="cursor:pointer;">E</text>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <script>
                                                            let selected_jaw = "";
                                                            function select_jaw(btn,jaw){
                                                                selected_teeth_5 = [];
                                                                if(btn.classList.contains('btn-primary')){
                                                                    //BARAYE IN K DANDUNAYE ENTEKHABI RESET BESHAN
                                                                    btn.classList.add('btn-outline-primary');
                                                                    btn.classList.remove('btn-primary');

                                                                    if(document.getElementById('slctJawUBTN').classList.contains('btn-outline-primary') && document.getElementById('slctJawLBTN').classList.contains('btn-outline-primary')){
                                                                        document.getElementById('SelectedJawText').style.display = "none";
                                                                        document.getElementById('dentChartSecondary').style.display = "none";
                                                                        document.getElementById('dentChartPrimary').style.display = "none";

                                                                        document.getElementById('SelectedJawText').innerHTML = "";
                                                                        document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                        document.getElementById('add-treatment-plan-box').classList.add('d-none');
                                                                    }
                                                                    else {
                                                                        if(document.getElementById('slctJawUBTN').classList.contains('btn-primary')){
                                                                            selected_teeth_5 = ["UPPERJAW"];
                                                                            document.getElementById('SelectedJawText').innerHTML = "کل فک بالا";
                                                                        }
                                                                        else {
                                                                            if(document.getElementById('slctJawLBTN').classList.contains('btn-primary')){
                                                                                selected_teeth_5 = ["LOWERJAW"];
                                                                                document.getElementById('SelectedJawText').innerHTML = "کل فک پایین";
                                                                            }
                                                                        }
                                                                    }

                                                                }
                                                                else {
                                                                    //BARAYE IN K DANDUNAYE ENTEKHABI RESET BESHAN

                                                                    ur = "";
                                                                    ul = "";
                                                                    lr = "";
                                                                    ll = "";

                                                                    cur = "";
                                                                    cul = "";
                                                                    clr = "";
                                                                    cll = "";

                                                                    document.getElementById('dentChartUpLeft').innerHTML = ul;
                                                                    document.getElementById('dentChartUpRight').innerHTML = ur;
                                                                    document.getElementById('dentChartLowLeft').innerHTML = ll;
                                                                    document.getElementById('dentChartLowRight').innerHTML = lr;

                                                                    document.getElementById('dentChartChildUpLeft').innerHTML = cul;
                                                                    document.getElementById('dentChartChildUpRight').innerHTML = cur;
                                                                    document.getElementById('dentChartChildLowLeft').innerHTML = cll;
                                                                    document.getElementById('dentChartChildLowRight').innerHTML = clr;

                                                                    var tmp45 = document.getElementsByTagName('path');
                                                                    for (const tmp45Element of tmp45) {
                                                                        $(tmp45Element).attr('fill','#ffffff');
                                                                        $(tmp45Element).attr('stroke','#000000');
                                                                        $('#t' + tmp45Element.id).css('fill','#000000');
                                                                    }
                                                                    document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.add('d-none');

                                                                    btn.classList.remove('btn-outline-primary');
                                                                    btn.classList.add('btn-primary');

                                                                    document.getElementById('SelectedJawText').style.display = "block";
                                                                    document.getElementById('dentChartSecondary').style.display = "none";
                                                                    document.getElementById('dentChartPrimary').style.display = "none";
                                                                    selected_teeth_5 = ["BOTHJAWS"];
                                                                    document.getElementById('SelectedJawText').innerHTML = "فک بالا و فک پایین";
                                                                    if(jaw === "u" && document.getElementById('slctJawLBTN').classList.contains('btn-outline-primary')){
                                                                        selected_teeth_5 = ["UPPERJAW"];
                                                                        document.getElementById('SelectedJawText').innerHTML = "کل فک بالا";
                                                                    }
                                                                    else{
                                                                        if(document.getElementById('slctJawUBTN').classList.contains('btn-outline-primary')){
                                                                            selected_teeth_5 = ["LOWERJAW"];
                                                                            document.getElementById('SelectedJawText').innerHTML = "کل فک پایین";
                                                                        }
                                                                    }
                                                                    document.getElementById('add-treatment-plan-message').classList.add('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.remove('d-none');
                                                                }
                                                                document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                            }
                                                            function change_dentition(btn){
                                                                if(selected_dentition === "SECONDARY"){
                                                                    document.getElementById('PrimaryDentition').classList.remove('d-none');
                                                                    document.getElementById('SecondaryDentition').classList.add('d-none');
                                                                    document.getElementById('secondarybtn').classList.remove('btn-primary');
                                                                    document.getElementById('primarybtn').classList.add('btn-primary');
                                                                    selected_dentition = "PRIMARY";
                                                                }
                                                                else {
                                                                    document.getElementById('PrimaryDentition').classList.add('d-none');
                                                                    document.getElementById('SecondaryDentition').classList.remove('d-none');
                                                                    document.getElementById('secondarybtn').classList.add('btn-primary');
                                                                    document.getElementById('primarybtn').classList.remove('btn-primary');
                                                                    selected_dentition = "SECONDARY";
                                                                }
                                                                document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                            }
                                                            function sort_dental_chart(text) {
                                                                return text.split('').sort().join('');
                                                            }
                                                            function sort_dental_chart_reverse(text) {
                                                                return text.split('').sort().reverse().join('');
                                                            }
                                                            var ur = "";
                                                            var ul = "";
                                                            var lr = "";
                                                            var ll = "";

                                                            var cur = "";
                                                            var cul = "";
                                                            var clr = "";
                                                            var cll = "";
                                                            var selected_teeth_5 = [];
                                                            var selected_dentition = "SECONDARY";
                                                            function tooth_select(tooth){
                                                                document.getElementById('SelectedJawText').style.display = "none";
                                                                document.getElementById('dentChartPrimary').style.display = "block";
                                                                document.getElementById('dentChartSecondary').style.display = "block";
                                                                document.getElementById('slctJawUBTN').classList.add('btn-outline-primary');
                                                                document.getElementById('slctJawUBTN').classList.remove('btn-primary');
                                                                document.getElementById('slctJawLBTN').classList.add('btn-outline-primary');
                                                                document.getElementById('slctJawLBTN').classList.remove('btn-primary');

                                                                if($(tooth).attr('fill') === "#ffffff"){
                                                                    $(tooth).attr('fill','#6236FF');
                                                                    $(tooth).attr('stroke','#6236FF');
                                                                    $('#t' + tooth.id).css('fill','#ffffff');
                                                                    //secondary dentition
                                                                    if(tooth.id[0] + tooth.id[1] === "ur"){
                                                                        ur += tooth.id[2];
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ul"){
                                                                        ul += tooth.id[2];
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "lr"){
                                                                        lr += tooth.id[2];
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ll"){
                                                                        ll += tooth.id[2];
                                                                    }
                                                                    //primary dentition
                                                                    if(tooth.id[1] + tooth.id[2] === "ur"){
                                                                        cur += tooth.id[3];
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ul"){
                                                                        cul += tooth.id[3];
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "lr"){
                                                                        clr += tooth.id[3];
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ll"){
                                                                        cll += tooth.id[3];
                                                                    }
                                                                }
                                                                else {
                                                                    $(tooth).attr('fill','#ffffff');
                                                                    $(tooth).attr('stroke','#000000');
                                                                    $('#t' + tooth.id).css('fill','#000000');

                                                                    //secondary dentition
                                                                    if(tooth.id[0] + tooth.id[1] === "ur"){
                                                                        ur = ur.replace(tooth.id[2],'');
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ul"){
                                                                        ul = ul.replace(tooth.id[2],'');
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "lr"){
                                                                        lr = lr.replace(tooth.id[2],'');
                                                                    }
                                                                    if(tooth.id[0] + tooth.id[1] === "ll"){
                                                                        ll = ll.replace(tooth.id[2],'');
                                                                    }
                                                                    //primary dentition
                                                                    if(tooth.id[1] + tooth.id[2] === "ur"){
                                                                        cur = cur.replace(tooth.id[3],'');
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ul"){
                                                                        cul = cul.replace(tooth.id[3],'');
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "lr"){
                                                                        clr = clr.replace(tooth.id[3],'');
                                                                    }
                                                                    if(tooth.id[1] + tooth.id[2] === "ll"){
                                                                        cll = cll.replace(tooth.id[3],'');
                                                                    }
                                                                }
                                                                ur = sort_dental_chart_reverse(ur);
                                                                ul = sort_dental_chart(ul);
                                                                lr = sort_dental_chart_reverse(lr);
                                                                ll = sort_dental_chart(ll);

                                                                cur = sort_dental_chart_reverse(cur);
                                                                cul = sort_dental_chart(cul);
                                                                clr = sort_dental_chart_reverse(clr);
                                                                cll = sort_dental_chart(cll);

                                                                document.getElementById('dentChartUpLeft').innerHTML = ul;
                                                                document.getElementById('dentChartUpRight').innerHTML = ur;
                                                                document.getElementById('dentChartLowLeft').innerHTML = ll;
                                                                document.getElementById('dentChartLowRight').innerHTML = lr;

                                                                function change_child_teeth_to_ABCD(text){
                                                                    text = text.replace('1','A');
                                                                    text = text.replace('2','B');
                                                                    text = text.replace('3','C');
                                                                    text = text.replace('4','D');
                                                                    text = text.replace('5','E');
                                                                    return text;
                                                                }
                                                                document.getElementById('dentChartChildUpLeft').innerHTML = change_child_teeth_to_ABCD(cul);
                                                                document.getElementById('dentChartChildUpRight').innerHTML = change_child_teeth_to_ABCD(cur);
                                                                document.getElementById('dentChartChildLowLeft').innerHTML = change_child_teeth_to_ABCD(cll);
                                                                document.getElementById('dentChartChildLowRight').innerHTML = change_child_teeth_to_ABCD(clr);

                                                                var arr_ur = ur.split('');
                                                                var arr_ul = ul.split('');
                                                                var arr_lr = lr.split('');
                                                                var arr_ll = ll.split('');

                                                                var arr_cur = cur.split('');
                                                                var arr_cul = cul.split('');
                                                                var arr_clr = clr.split('');
                                                                var arr_cll = cll.split('');
                                                                selected_teeth_5 = [];

                                                                for (const string of arr_ur) {
                                                                    selected_teeth_5.push('ur' + string);
                                                                }
                                                                for (const string of arr_ul) {
                                                                    selected_teeth_5.push('ul' + string);
                                                                }
                                                                for (const string of arr_lr) {
                                                                    selected_teeth_5.push('lr' + string);
                                                                }
                                                                for (const string of arr_ll) {
                                                                    selected_teeth_5.push('ll' + string);
                                                                }

                                                                for (const string of arr_cur) {
                                                                    selected_teeth_5.push('cur' + string);
                                                                }
                                                                for (const string of arr_cul) {
                                                                    selected_teeth_5.push('cul' + string);
                                                                }
                                                                for (const string of arr_clr) {
                                                                    selected_teeth_5.push('clr' + string);
                                                                }
                                                                for (const string of arr_cll) {
                                                                    selected_teeth_5.push('cll' + string);
                                                                }
                                                                if(ul === "" && ur === "" && ll === "" && lr === "" && cul === "" && cur === "" && cll === "" && clr === ""){
                                                                    document.getElementById('add-treatment-plan-message').classList.remove('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.add('d-none');
                                                                }
                                                                else {
                                                                    if(ul !== "" || ur !== "" || ll !== "" || lr !== ""){
                                                                        document.getElementById('dentChartSecondary').style.display = 'block';
                                                                    }
                                                                    else {
                                                                        document.getElementById('dentChartSecondary').style.display = 'none';
                                                                    }
                                                                    if(cul !== "" || cur !== "" || cll !== "" || clr !== ""){
                                                                        document.getElementById('dentChartPrimary').style.display = 'block';
                                                                    }
                                                                    else {
                                                                        document.getElementById('dentChartPrimary').style.display = 'none';
                                                                    }
                                                                    document.getElementById('add-treatment-plan-message').classList.add('d-none');
                                                                    document.getElementById('add-treatment-plan-box').classList.remove('d-none');
                                                                }
                                                                document.getElementById('selected_teeth_hidden').value = JSON.stringify(selected_teeth_5);
                                                                document.getElementById('selected_dentition_hidden').value = selected_dentition;
                                                            }
                                                        </script>
                                                        <style>
                                                            .rotate90 {
                                                                -webkit-transform: rotate(180deg);
                                                                -moz-transform: rotate(180deg);
                                                                -o-transform: rotate(180deg);
                                                                -ms-transform: rotate(180deg);
                                                                transform: rotate(180deg);
                                                            }
                                                        </style>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-6">
                                            <div class="container">
                                                <div class="row">
                                                    <label class="form-label">دندان های انتخاب شده</label>
                                                    <h6 id="add-treatment-plan-message">لطفا در ابتدا یک یا چند دندان را انتخاب نمایید</h6>
                                                    <div id="add-treatment-plan-box" class="d-none">
                                                        <div class="row p-3">
                                                            <div class="col-12">
                                                                <div class="row">
                                                                    <div id="dentChartSecondary" class="col-6 col-md-6 ">
                                                                        <h6>دندان های دائمی</h6>
                                                                        <table class="mt-3 mb-3">
                                                                            <tr>
                                                                                <td id="dentChartUpLeft" style="border-bottom: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td id="dentChartLeft">
                                                                                <td id="dentChartUpRight" style="border-bottom: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td id="dentChartLowLeft" style="border-top: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td>
                                                                                <td id="dentChartLowRight" style="border-top: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div id="dentChartPrimary" class="col-6 col-md-6 ">
                                                                        <h6>دندان های شیری</h6>
                                                                        <table class="mt-3 mb-3">
                                                                            <tr>
                                                                                <td id="dentChartChildUpLeft" style="border-bottom: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td id="dentChartLeft">
                                                                                <td id="dentChartChildUpRight" style="border-bottom: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td id="dentChartChildLowLeft" style="border-top: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;height: 50px;font-weight: bold;color: #000000;"></td>
                                                                                <td id="dentChartChildLowRight" style="border-top: 2px solid #000000;border-right: 2px solid #000000;padding: 12px;width: 50%;text-align: center;letter-spacing: 8px;font-weight: bold;color: #000000;"></td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>

                                                                </div>
                                                                <h6 id="SelectedJawText" class="mt-3 mb-3">فک بالا</h6>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <form id="edit-treatment-plan-form" method="post" action="<?=ROOT . 'cases/' . $patient_code . '?tab=treatmentPlans'?>">
                                                    <div class="row">
                                                        <div class="col-12 col-lg-6">
                                                            <label class="form-label">درمان*</label>
                                                            <select name="service_code_edit" id="services_select_edit" class="form-select" onchange="" required>
                                                                <option value="">انتخاب کنید</option>
                                                                <?php
                                                                $stmt = $pdo->prepare("
        SELECT service_code, service_title, service_category_code
        FROM services
        WHERE status = 'ACTIVE' AND COALESCE(hide_default_for, '') NOT LIKE :pattern
          AND (office_code = :office_code OR office_code = 'DEFAULT')
    ");
                                                                $stmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
                                                                $services = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                                                foreach ($services as $service){
                                                                    ?>
                                                                    <option value="<?=$service['service_code'];?>"><?=$service['service_title'];?></option>
                                                                    <?php
                                                                }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        <div class="col-12 col-lg-6">
                                                            <label class="form-label">وضعیت*</label>
                                                            <select name="status_edit" id="status_edit" class="form-select" onchange="" required>
                                                                <option value="NOTDONE">ناتمام</option>
                                                                <option value="MIDTREATMENT">حین درمان</option>
                                                                <option value="DONE">تمام شده</option>
                                                                <option value="CANCELED">لغو شده</option>
                                                            </select>
                                                        </div>

                                                    </div>
                                                    <div class="row mt-3">
                                                        <label class="form-label">توضیحات</label>
                                                        <textarea name="treatmentNoteEdit" id="treatmentNoteEdit" class="form-control" rows="4" placeholder="توضیحات تکمیلی در مورد طرح درمان را وارد کنید..."></textarea>
                                                    </div>
                                                    <input type="hidden" name="selected_teethEdit" id="selected_teeth_hidden">
                                                    <input type="hidden" name="selected_dentitionEdit" id="selected_dentition_hidden" value="PRIMARY">
                                                    <input type="hidden" name="treatment_code_edit" id="treatment_code_edit" value="">
                                                    <input type="hidden" name="edit-treatment-plan-submit">
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button class="btn btn-label-secondary" data-bs-dismiss="modal" type="button"> بستن</button>
                                    <button onclick="submit_edit_form();" class="btn btn-primary" type="button">ویرایش</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- / Content -->
                <!-- Footer -->
                <footer class="content-footer footer bg-footer-theme">
                    <div class="container-xxl">
                        <div class="footer-container d-flex align-items-center justify-content-between py-2 flex-md-row flex-column">
                            <div> ©
                                <script>
                                    document.write(new Date().getFullYear());

                                </script>
                                , ارائه شده توسط
                                <span class="text-danger byte-hover">بایت ‌مَستر</span>
                                در سایت
                                <a class="fw-medium" href="#support" target="_blank">راستچین</a>
                            </div>
                            <div class="d-none d-lg-inline-block">
                                <a class="footer-link me-4" href="#support" target="_blank">لایسنس</a>
                                <a class="footer-link me-4" href="#support" target="_blank">قالب‌های بیشتر</a>
                                <a class="footer-link me-4" href="https://demos.pixinvent.com/vuexy-html-admin-template/documentation/" target="_blank">مستندات</a>
                                <a class="footer-link d-none d-sm-inline-block" href="#support-theme" target="_blank">پشتیبانی</a>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- / Footer -->
                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>
    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    <!-- Drag Target Area To SlideIn Menu On Small Screens -->
    <div class="drag-target"></div>
</div>
<!-- / Layout wrapper -->
<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="../../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../../assets/vendor/js/bootstrap.js"></script>
<script src="../../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../../assets/vendor/js/menu.js"></script>
<!-- endbuild -->
<!-- Vendors JS -->
<script src="../../../assets/vendor/libs/moment/moment.js"></script>
<script src="../../../assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="../../../assets/vendor/libs/datatables-bs5/i18n/fa.js"></script>
<script src="../../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
<script src="../../../assets/vendor/libs/cleavejs/cleave.js"></script>
<script src="../../../assets/vendor/libs/cleavejs/cleave-phone.js"></script>
<script src="../../../assets/vendor/libs/select2/select2.js"></script>
<script src="../../../assets/vendor/libs/select2/i18n/fa.js"></script>
<script src="../../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../../assets/vendor/libs/@form-validation/auto-focus.js"></script>

<!-- Vendors JS -->
<script src="../../../assets/vendor/libs/tagify/tagify.js"></script>
<script src="../../../assets/vendor/libs/bootstrap-select/bootstrap-select.js"></script>
<script src="../../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../../assets/libs/jdate/jdate.js"></script>
<script src="../../../assets/libs/flatpickr/flatpickr-jalali.js"></script>
<script src="../../../assets/libs/flatpickr/l10n/fa.js"></script>
<script src="../../../assets/libs/jalali-datepicker/jalalidatepicker.js"></script>
<script src="../../../assets/libs/bootstrap-datepicker/bootstrap-datepicker-jdate.js"></script>
<script src="../../../assets/libs/bootstrap-datepicker/bootstrap-datepicker.js"></script>
<script src="../../../assets/libs/bootstrap-daterangepicker/bootstrap-daterangepicker-jdate.js"></script>
<script src="../../../assets/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"></script>
<script src="../../../assets/vendor/libs/jquery-timepicker/jquery-timepicker.js"></script>
<script src="../../../assets/vendor/libs/pickr/pickr.js"></script>
<!-- Main JS -->
<!-- Page JS -->
<script src="../../assets/js/forms-pickers-jalali.js?21"></script>
<!-- Main JS -->
<script src="../../../assets/js/main.js?12"></script>
<!-- Page JS -->
<script src="../../../assets/js/modal-edit-user.js"></script>
<script src="../../../assets/js/app-user-view.js"></script>
<script src="../../../assets/js/app-user-view-account.js"></script>
<script>
        $(document).ready(function() {
            $('#services_select').select2({
                width: '100%',
                placeholder: 'انتخاب کنید',
                allowClear: true,
                language: "fa"
            });
            // Dentist selection toggle
            $('input[name="dentist_selection_type"]').on('change', function() {
                const selectedType = $(this).val();
                if (selectedType === 'existing') {
                    $('#existing_dentist_container').show();
                    $('#manual_dentist_container').hide();
                    $('#dentist_select').prop('required', true);
                    $('#manual_dentist_input').prop('required', false);
                    $('#manual_dentist_input').val(''); // Clear manual input
                } else {
                    $('#existing_dentist_container').hide();
                    $('#manual_dentist_container').show();
                    $('#dentist_select').prop('required', false);
                    $('#manual_dentist_input').prop('required', true);
                    $('#dentist_select').val(''); // Clear dropdown selection
                }
            });

            $('#dentist_select').select2({
                width: '100%',
                placeholder: 'انتخاب کنید',
                allowClear: true,
                language: "fa"
            });
        });
</script>
<script>
    // Update form validation to handle both scenarios
    $('#add-treatment-plan-form').on('submit', function(e) {
        let isValid = true;
        if($('#selected_dentition_hidden').val() !== "PRIMARY" && $('#selected_dentition_hidden').val() !== "SECONDARY"){
            isValid = false;
            e.preventDefault();
            alert('دنتیشن دندانی (شیری یا دائمی) مشخص نشده.');
        }
        if($('#selected_teeth_hidden').val() === "" || $('#selected_teeth_hidden').val() === "[]"){
            isValid = false;
            e.preventDefault();
            alert('دندان یا فک مشخص نشده است.');
        }

        if (!isValid) {
            e.preventDefault();
            alert('لطفاً تمام فیلدهای ضروری را پر کنید.');
        }
    });
    function submit_edit_form(){
        let isValid = true;
        if($('#selected_dentition_hidden').val() !== "PRIMARY" && $('#selected_dentition_hidden').val() !== "SECONDARY"){
            isValid = false;
            alert('دنتیشن دندانی (شیری یا دائمی) مشخص نشده.');
        }
        if($('#selected_teeth_hidden').val() === "" || $('#selected_teeth_hidden').val() === "[]"){
            isValid = false;
            alert('دندان یا فک مشخص نشده است.');
        }
        if($('#services_select_edit').val() === "" || $('#services_select_edit').val() === "[]"){
            isValid = false;
            alert('درمان انتخاب نشده.');
        }
        console.log(isValid);
        if (!isValid) {
        }
        else {
            document.getElementById('edit-treatment-plan-form').submit();
        }
    }
    function treatment_change(select){
        const tariffs = JSON.parse('<?=json_encode($tariffs)?>')
        let treatment = select.value;
        for (const tariff of tariffs) {
            if (tariff.for_code === treatment){
                document.getElementById('treatment_cost').value = tariff.price;
                thousand_sepr(document.getElementById('treatment_cost'));
                dentist_cut_funcs(document.getElementById('dentist_cut_percentage'));
                return;
            }
            document.getElementById('treatment_cost').value = 0;
        }
    }
</script>
<script>
    $(document).on('click', '.delete-treatment', function () {
        const doneServiceID = $(this).data('code');
        Swal.fire({
            title: 'مطمئنی؟',
            text: 'این درمان برای همیشه حذف خواهد شد!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'بله, حذف شود!',
            cancelButtonText: 'بازگشت',
            customClass: {
                confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                cancelButton: 'btn btn-label-secondary waves-effect waves-light'
            },
            buttonsStyling: false
        }).then(function (result) {
            if (result.isConfirmed) {
                // Call backend to delete dentist
                fetch('<?=ROOT?>functions/cases_funcs.php', {
                    method: 'POST',
                    body: new URLSearchParams({ action: 'delete_done_services', code: doneServiceID })
                })
                    .then(r => r.json())
                    .then(data => {
                        if (data.success) {
                            $('.datatable-done-services').DataTable().ajax.reload();

                            Swal.fire({
                                icon: 'success',
                                title: 'حذف شد!',
                                text: data.message || 'درمان با موفقیت حذف شد.',
                                confirmButtonText: 'باشه',
                                customClass: {
                                    confirmButton: 'btn btn-success waves-effect waves-light'
                                }
                            });
                        } else {
                            Swal.fire({
                                title: 'لغو شده',
                                text: data.error || 'خطایی در حذف رخ داد.',
                                confirmButtonText: 'باشه',
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-success waves-effect waves-light'
                                }
                            });
                        }
                    })
                    .catch(() => {
                        Swal.fire({
                            title: 'خطا',
                            text: 'مشکل ارتباط با سرور',
                            confirmButtonText: 'باشه',
                            icon: 'error',
                            customClass: {
                                confirmButton: 'btn btn-success waves-effect waves-light'
                            }
                        });
                    });
            }
        });
    });
    $(document).on('click', '.delete-payment', function () {
        const paymentID = $(this).data('code');
        Swal.fire({
            title: 'مطمئنی؟',
            text: 'این پرداختی برای همیشه حذف خواهد شد!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'بله, حذف شود!',
            cancelButtonText: 'بازگشت',
            customClass: {
                confirmButton: 'btn btn-danger me-3 waves-effect waves-light',
                cancelButton: 'btn btn-label-secondary waves-effect waves-light'
            },
            buttonsStyling: false
        }).then(function (result) {
            if (result.isConfirmed) {
                // Call backend to delete dentist
                fetch('<?=ROOT?>functions/cases_funcs.php', {
                    method: 'POST',
                    body: new URLSearchParams({ action: 'delete_payment', code: paymentID })
                })
                    .then(r => r.json())
                    .then(data => {
                        if (data.success) {
                            $('.datatable-invoices').DataTable().ajax.reload();

                            Swal.fire({
                                icon: 'success',
                                title: 'حذف شد!',
                                text: data.message || 'پرداختی با موفقیت حذف شد.',
                                confirmButtonText: 'باشه',
                                customClass: {
                                    confirmButton: 'btn btn-success waves-effect waves-light'
                                }
                            });
                        } else {
                            Swal.fire({
                                title: 'لغو شده',
                                text: data.error || 'خطایی در حذف رخ داد.',
                                confirmButtonText: 'باشه',
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-success waves-effect waves-light'
                                }
                            });
                        }
                    })
                    .catch(() => {
                        Swal.fire({
                            title: 'خطا',
                            text: 'مشکل ارتباط با سرور',
                            confirmButtonText: 'باشه',
                            icon: 'error',
                            customClass: {
                                confirmButton: 'btn btn-success waves-effect waves-light'
                            }
                        });
                    });
            }
        });
    });
</script>
<?php
if(isset($_GET['mode'])){
    if($_GET['mode'] == "edit" || $_GET['mode'] == "readOnly"){
        if(isset($_GET['done-code'])){
            $done_code2 = $_GET['done-code'];
            $stmt = $pdo->prepare("SELECT * FROM done_treatments WHERE done_code=? AND clinic_code = ? AND patient_code = ? AND status != 'DELETED'");
            $stmt->execute([$done_code2,$officeCode,$patient_code]);
            $doneTreatment = $stmt->fetch();
            if($doneTreatment){
                ?>
                <script>
                    document.getElementById('add-done-services-form').action = document.getElementById('add-done-services-form').action + '&mode=editDoneServices&editDoneCode=<?=htmlspecialchars($done_code2)?>'
                    let teeth_json2 = '<?=$doneTreatment['teeth'];?>';
                    const dentition2 = '<?=$doneTreatment['dentition'];?>';
                    const dentistCode2 = '<?=$doneTreatment['dentist_code'];?>';
                    const manual_dentist_name2 = '<?=$doneTreatment['manual_dentist_name'];?>';
                    const service_code2 = '<?=$doneTreatment['service_code'];?>';
                    const cost2 = '<?=$doneTreatment['cost'];?>';
                    const additional_cost2 = '<?=$doneTreatment['additional_cost'];?>';
                    const patientPrimary_cost2 = '<?=$doneTreatment['patientPrimary_cost'];?>';
                    const clinicDiscount2 = '<?=$doneTreatment['clinicDiscount'];?>';
                    const dentistDiscount2 = '<?=$doneTreatment['dentistDiscount'];?>';
                    const patientFinal_cost2 = '<?=$doneTreatment['patientFinal_cost'];?>';
                    const note2 = '<?=$doneTreatment['note'];?>';
                    const start_date2 = '<?=$doneTreatment['start_date'];?>';
                    const finish_date2 = '<?=$doneTreatment['finish_date'];?>';
                    const status2 = '<?=$doneTreatment['status'];?>';

                    if(teeth_json2 === "" || teeth_json2 === null){
                        teeth_json2 = "[]";
                    }
                    const teeth2 = JSON.parse(teeth_json2);
                    console.log(teeth_json2);
                    document.getElementById('slctJawUBTN').classList.add('btn-outline-primary');
                    document.getElementById('slctJawUBTN').classList.remove('btn-primary');
                    document.getElementById('slctJawLBTN').classList.add('btn-outline-primary');
                    document.getElementById('slctJawLBTN').classList.remove('btn-primary');
                    selected_teeth_5 = [];
                    console.log('7777');
                    if(teeth_json2.includes("JAW")){
                        console.log('5555');
                        if(teeth_json2.includes("UPPERJAW") || teeth_json2.includes("BOTHJAW")){
                            console.log('2222');
                            select_jaw(document.getElementById('slctJawUBTN'),'u');
                        }
                        if(teeth_json2.includes("LOWERJAW") || teeth_json2.includes("BOTHJAW")){
                            console.log('3333');

                            select_jaw(document.getElementById('slctJawLBTN'),'l');
                        }
                        selected_dentition = dentition2;
                        change_dentition();
                        change_dentition();
                    }
                    else {
                        for (const tooth of teeth2) {
                            tooth_select(document.getElementById(tooth));
                            selected_dentition = dentition2;
                            change_dentition();
                            change_dentition();
                        }
                    }

                    status_btns = document.getElementsByClassName('doneServicesStatusBtn');
                    for (const statusbtn of status_btns) {
                        if(statusbtn.dataset.status === status2){
                            done_services_status(statusbtn);
                        }
                    }
                    document.getElementById('services_select').value = service_code2;
                    document.getElementById('treatment_cost').value = cost2;
                    document.getElementById('additionalTreatment_cost').value = additional_cost2;
                    document.getElementById('patientPrimary_cost').value = patientPrimary_cost2;
                    document.getElementById('clinicDiscount').value = clinicDiscount2;
                    document.getElementById('dentistDiscount').value = dentistDiscount2;
                    document.getElementById('patientFinal_cost').value = patientFinal_cost2;
                    document.getElementById('treatmentNote').value = note2;
                    document.getElementById('done-services-submit-btn').innerHTML = "ویرایش درمان";
                    const fp = document.getElementById('flatpickr-datetime2')._flatpickr;
                    fp.setDate(start_date2, true);
                    const fp2 = document.getElementById('flatpickr-datetime3')._flatpickr;
                    fp2.setDate(finish_date2, true);

                    if(dentistCode2 === "MANUAL"){
                        document.querySelector(
                            'input[name="dentist_selection_type"][value="manual"]'
                        ).checked = true;
                        $('#existing_dentist_container').hide();
                        $('#manual_dentist_container').show();
                        $('#dentist_select').prop('required', false);
                        $('#manual_dentist_input').prop('required', true);
                        $('#dentist_select').val(''); // Clear dropdown selection
                        document.getElementById('manual_dentist_input').value = manual_dentist_name2;
                    }
                    else {
                        document.querySelector(
                            'input[name="dentist_selection_type"][value="existing"]'
                        ).checked = true;
                        document.getElementById('dentist_select').value = dentistCode2;
                    }

                    thousand_sepr(document.getElementById('treatment_cost'));
                    thousand_sepr(document.getElementById('additionalTreatment_cost'));
                    thousand_sepr(document.getElementById('patientPrimary_cost'));
                    thousand_sepr(document.getElementById('patientFinal_cost'));
                </script>
                <?php
            if($_GET['mode'] == "readOnly"){
                ?>
                    <script>
                        const div = document.getElementById("addDoneServicesBox");
                        div.style.pointerEvents = 'none';
                        div.style.opacity = '0.5';
                    </script>
<?php
            }
            }
        }
    }
}
?>
</body>

</html>
