<?php
require_once "config.php";
session_start();
$officeCode = $_SESSION['office_code'] ?? $_SESSION['user_code'] ?? null;
if ($officeCode) {
    $code = trim($_GET['c'] ?? null);
    if ($code) {
        $stmt = $pdo->prepare("
    SELECT *
    FROM temp_download
    WHERE user_code = :office_code AND temp_code = :temp_code AND active = 1
");
        $stmt->execute([':office_code' => $officeCode, ':temp_code' => $code]);
        $files = $stmt->fetch(PDO::FETCH_ASSOC);
        $file_codes = $files['file_code'];
            $stmt = $pdo->prepare("SELECT url, file_extension, original_name 
                           FROM uploaded_files 
                           WHERE file_code = :code AND user_code LIMIT 1");
            $stmt->bindParam(':code', $file_codes, PDO::PARAM_STR);
            $stmt->execute();
            $file = $stmt->fetch(PDO::FETCH_ASSOC);

            $url  = $file['url'];
            $ext  = $file['file_extension'];

            // reconstruct original filename
            // if your DB stores original_name column, use that instead
            $clean_name = $file['original_name'];

            // get file content securely
            $content = @file_get_contents($url);

            // serve with correct headers
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="' . $clean_name . '"');
            header('Content-Length: ' . strlen($content));
            header('Cache-Control: no-cache, must-revalidate');
            header('Pragma: no-cache');

            // output file
            echo $content;
            // if you want multiple file downloads, zip them first instead of looping direct

    }
    else{
        echo "No Code";
    }
}
else{
    echo "No office code found.";
}