<?php
session_start();
require 'auth21.php';

if (empty($_SESSION['user_code'])) {
    header("Location: login");
    exit;
}

$patientCode = $_GET['pcode'] ?? '';
$officeCode  = $_SESSION['user_code'] ?? null;

$stmt = $pdo->prepare("
    SELECT *
    FROM patients
    WHERE patient_code = :code
      AND office_code = :office_code
      AND status != 'DELETED'
");
$stmt->execute([':code' => $patientCode, ':office_code' => $officeCode]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

// selected histories (if stored in patients table as JSON)
// decrypt helper
$dec = fn($v) => $v ? decryptData($v) : $v;
$patient_enc = [];

$patient_enc['patient_firstname_encrypted']             = $dec($row['patient_firstname_encrypted'] ?? null);
$patient_enc['patient_lastname_encrypted']              = $dec($row['patient_lastname_encrypted'] ?? null);
$patient_enc['patient_phone_encrypted']                 = $dec($row['patient_phone_encrypted'] ?? null);
$patient_enc['gender_encrypted']                        = $dec($row['gender_encrypted'] ?? null);
$patient_enc['patient_nationalid_encrypted']            = $dec($row['patient_nationalid_encrypted'] ?? null);
$patient_enc['firstname_en_encrypted']                  = $dec($row['firstname_en_encrypted'] ?? null);
$patient_enc['lastname_en_encrypted']                   = $dec($row['lastname_en_encrypted'] ?? null);
$patient_enc['home_number_encrypted']                   = $dec($row['home_number_encrypted'] ?? null);
$patient_enc['father_name_encrypted']                   = $dec($row['father_name_encrypted'] ?? null);
$patient_enc['emergency_contact_encrypted']             = $dec($row['emergency_contact_encrypted'] ?? null);
$patient_enc['emergency_contact_name_encrypted']        = $dec($row['emergency_contact_name_encrypted'] ?? null);
$patient_enc['emergency_contact_relation_encrypted']    = $dec($row['emergency_contact_relation_encrypted'] ?? null);
$patient_enc['education_encrypted']                     = $dec($row['education_encrypted'] ?? null);
$patient_enc['occupation_encrypted']                    = $dec($row['occupation_encrypted'] ?? null);
$patient_enc['birthdate_encrypted']                     = $dec($row['birthdate_encrypted'] ?? null);
$patient_enc['address_encrypted']                       = $dec($row['address_encrypted'] ?? null);
$patient_enc['bloodtype_encrypted']                     = $dec($row['bloodtype_encrypted'] ?? null);
$patient_enc['pregnancy_encrypted']                     = $dec($row['pregnancy_encrypted'] ?? null);
$patient_enc['marital_status_encrypted']                = $dec($row['marital_status_encrypted'] ?? null);
$patient_enc['medical_histories_encrypted']             = $dec($row['medical_histories_encrypted'] ?? null);
$iv = $row['iv'];
$salt = $row['salt'];
$enc_code = $row['enc_code'];

$tmp_patient = get_decrypted_data($patient_enc,$iv,$salt,$enc_code);

$firstname       = $tmp_patient['patient_firstname_encrypted'] ?? null;
$lastname        = $tmp_patient['patient_lastname_encrypted'] ?? null;
$phone           = $tmp_patient['patient_phone_encrypted'] ?? null;
$gender          = $tmp_patient['gender_encrypted'] ?? null;
$nationalid      = $tmp_patient['patient_nationalid_encrypted'] ?? null;
$firstname_en    = $tmp_patient['firstname_en_encrypted'] ?? null;
$lastname_en     = $tmp_patient['lastname_en_encrypted'] ?? null;
$home_number     = $tmp_patient['home_number_encrypted'] ?? null;
$father_name     = $tmp_patient['father_name_encrypted'] ?? null;
$emergency_contact             = $tmp_patient['emergency_contact_encrypted'] ?? null;
$emergency_contact_name        = $tmp_patient['emergency_contact_name_encrypted'] ?? null;
$emergency_contact_relation    = $tmp_patient['emergency_contact_relation_encrypted'] ?? null;
$education       = $tmp_patient['education_encrypted'] ?? null;
$occupation      = $tmp_patient['occupation_encrypted'] ?? null;
$birthdate       = $tmp_patient['birthdate_encrypted'] ?? null;
$address         = $tmp_patient['address_encrypted'] ?? null;
$bloodtype       = $tmp_patient['bloodtype_encrypted'] ?? null;
$pregnancy       = $tmp_patient['pregnancy_encrypted'] ?? null;
$marital_status  = $tmp_patient['marital_status_encrypted'] ?? null;
$patient_medical_histories_json = $tmp_patient['medical_histories_encrypted'] ?? null;

$patient_medical_histories_array = array();
echo $patient_medical_histories_json;
if ($patient_medical_histories_json == '[]' || $patient_medical_histories_json == null){
    $patient_medical_histories_array[0] = "NOTDEFINED";
}
else{
    $patient_medical_histories_array = json_decode($patient_medical_histories_json);
    if(!is_array($patient_medical_histories_array)){
        $patient_medical_histories_array = json_decode(json_decode($patient_medical_histories_json));
    }
}
// Fetch active medical histories for this office
$mhStmt = $pdo->prepare("
    SELECT
        id,
        history_code,
        title_encrypted,
        history_type,
        description_encrypted,
        alert_flag
    FROM medical_histories
    WHERE (office_code = :office_code OR office_code = 'DEFAULT')
      AND status != 'DELETED' AND hide_default_for NOT LIKE :pattern
");
$mhStmt->execute([':office_code' => $officeCode, ':pattern' => '%"'.$officeCode.'"%']);
$medical_histories = $mhStmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($medical_histories as &$mh) {
    $mh['title'] = decryptData($mh['title_encrypted']);
}
unset($mh);
?>
<!DOCTYPE html>
<html class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ویرایش بیمار</title>
    <link rel="icon" type="image/x-icon" href="../../assets/img/favicon/favicon.ico" />
    <link rel="stylesheet" href="../../assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="../../assets/vendor/fonts/tabler-icons.css" />
    <link rel="stylesheet" href="../../assets/vendor/fonts/flag-icons.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/rtl/core.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/rtl/theme-default.css" />
    <link rel="stylesheet" href="../../assets/css/demo.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/select2/select2.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/@form-validation/form-validation.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/sweetalert2/sweetalert2.css" />
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/js/jquery-3.6.0.min.js"></script>
    <script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link rel="stylesheet" href="../../assets/css/rtl.css" />
</head>

<body>
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <?php require_once 'sidebar.php';?>
        <div class="layout-page">
            <?php require_once 'navbar.php';?>
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    <h4 class="mb-4">ویرایش بیمار</h4>
                    <div class="card p-4">
                        <form id="editPatientForm" novalidate>
                            <input type="hidden" name="action" value="update_patient">
                            <input type="hidden" name="code" value="<?= htmlspecialchars($patientCode) ?>">

                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label class="form-label">نام*</label>
                                    <input type="text" name="firstname" class="form-control" required value="<?= htmlspecialchars($firstname) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">نام خانوادگی*</label>
                                    <input type="text" name="lastname" class="form-control" required value="<?= htmlspecialchars($lastname) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">موبایل*</label>
                                    <input type="text" name="phonenumber" class="form-control" required pattern="09\d{9}" minlength="11" maxlength="11" value="<?= htmlspecialchars($phone) ?>">
                                </div>
                            </div>

                            <div class="row g-3 mt-0">
                                <div class="col-md-4">
                                    <label class="form-label">جنسیت*</label>
                                    <select name="gender" class="form-select" required>
                                        <option value="">انتخاب کنید</option>
                                        <option value="male" <?= $gender === 'male' ? 'selected' : '' ?>>مرد</option>
                                        <option value="female" <?= $gender === 'female' ? 'selected' : '' ?>>زن</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">کد ملی*</label>
                                    <input type="text" name="nationalid" class="form-control" required pattern="\d{10}" maxlength="10" value="<?= htmlspecialchars($nationalid) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">سوابق پزشکی*</label><br>
                                    <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#medicalHistoriesModal">انتخاب سابقه</button>
                                    <div id="selectedHistoriesContainer" class="mt-2 d-flex flex-wrap gap-2">
                                        <?php foreach ($medical_histories as $mh): ?>
                                            <?php if (in_array($mh['history_code'], $patient_medical_histories_array, true)): ?>
                                                <span class="badge bg-primary selected-history-badge" data-id="<?= htmlspecialchars($mh['history_code']) ?>">
                <?= htmlspecialchars($mh['title']) ?>
                <button type="button" class="btn-close btn-close-white ms-1 remove-history-btn" aria-label="Remove"></button>
            </span>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </div>
                                    <div class="form-check mt-2">
                                        <input class="form-check-input" type="checkbox" name="no_medical_history" id="noMedicalHistory" <?php if($patient_medical_histories_array[0] == "NOMEDICALHISTORY"){echo 'checked';}if(!empty($patient_medical_histories_array) && $patient_medical_histories_array[0] != "NOTDEFINED" && $patient_medical_histories_array[0] != "NOMEDICALHISTORY"){echo ' disabled';}?> >
                                        <label class="form-check-label" for="noMedicalHistory">بیمار سابقه پزشکی ندارد</label>
                                    </div>
                                </div>
                            </div>

                            <div class="row g-3 mt-0">
                                <div class="col-md-4">
                                    <label class="form-label">First name (EN)</label>
                                    <input type="text" name="firstname_en" class="form-control" value="<?= htmlspecialchars($firstname_en) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Last name (EN)</label>
                                    <input type="text" name="lastname_en" class="form-control" value="<?= htmlspecialchars($lastname_en) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">شماره منزل</label>
                                    <input type="text" name="home_number" class="form-control" pattern="\d*" value="<?= htmlspecialchars($home_number) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">نام پدر</label>
                                    <input type="text" name="father_name" class="form-control" value="<?= htmlspecialchars($father_name) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">تماس اضطراری</label>
                                    <input type="text" name="emergency_contact" class="form-control" value="<?= htmlspecialchars($emergency_contact) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">نام و نام خانوادگی مخاطب اضطراری</label>
                                    <input type="text" name="emergency_contact_name" class="form-control" value="<?= htmlspecialchars($emergency_contact_name) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">نسبت</label>
                                    <select name="emergency_contact_relation" class="form-select">
                                        <option value="">انتخاب کنید</option>
                                        <option value="father" <?= $emergency_contact_relation === 'father' ? 'selected' : '' ?>>پدر</option>
                                        <option value="mother" <?= $emergency_contact_relation === 'mother' ? 'selected' : '' ?>>مادر</option>
                                        <option value="brother" <?= $emergency_contact_relation === 'brother' ? 'selected' : '' ?>>برادر</option>
                                        <option value="sister" <?= $emergency_contact_relation === 'sister' ? 'selected' : '' ?>>خواهر</option>
                                        <option value="spouse" <?= $emergency_contact_relation === 'spouse' ? 'selected' : '' ?>>همسر</option>
                                        <option value="friend" <?= $emergency_contact_relation === 'friend' ? 'selected' : '' ?>>دوست</option>
                                        <option value="other" <?= $emergency_contact_relation === 'other' ? 'selected' : '' ?>>سایر</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">تحصیلات</label>
                                    <select name="education" class="form-select">
                                        <option value="">انتخاب کنید</option>
                                        <option value="diploma" <?= $education === 'diploma' ? 'selected' : '' ?>>دیپلم</option>
                                        <option value="associate" <?= $education === 'associate' ? 'selected' : '' ?>>فوق دیپلم</option>
                                        <option value="bachelor" <?= $education === 'bachelor' ? 'selected' : '' ?>>لیسانس</option>
                                        <option value="master" <?= $education === 'master' ? 'selected' : '' ?>>فوق لیسانس</option>
                                        <option value="doctorate" <?= $education === 'doctorate' ? 'selected' : '' ?>>دکتری</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">شغل</label>
                                    <input type="text" name="occupation" class="form-control" value="<?= htmlspecialchars($occupation) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">تاریخ تولد</label>
                                    <input type="text" name="birthdate" class="form-control" placeholder="مثال: 1377/12/26" value="<?= htmlspecialchars($birthdate) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">آدرس</label>
                                    <input type="text" name="address" class="form-control" value="<?= htmlspecialchars($address) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">گروه خون</label>
                                    <select name="bloodtype" class="form-select">
                                        <option value="">انتخاب کنید</option>
                                        <option value="A+" <?= $bloodtype === 'A+' ? 'selected' : '' ?>>A+</option>
                                        <option value="A-" <?= $bloodtype === 'A-' ? 'selected' : '' ?>>A-</option>
                                        <option value="B+" <?= $bloodtype === 'B+' ? 'selected' : '' ?>>B+</option>
                                        <option value="B-" <?= $bloodtype === 'B-' ? 'selected' : '' ?>>B-</option>
                                        <option value="AB+" <?= $bloodtype === 'AB+' ? 'selected' : '' ?>>AB+</option>
                                        <option value="AB-" <?= $bloodtype === 'AB-' ? 'selected' : '' ?>>AB-</option>
                                        <option value="O+" <?= $bloodtype === 'O+' ? 'selected' : '' ?>>O+</option>
                                        <option value="O-" <?= $bloodtype === 'O-' ? 'selected' : '' ?>>O-</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">بارداری</label>
                                    <select name="pregnancy" class="form-select">
                                        <option value="">انتخاب کنید</option>
                                        <option value="yes" <?= $pregnancy === 'yes' ? 'selected' : '' ?>>بله</option>
                                        <option value="no" <?= $pregnancy === 'no' ? 'selected' : '' ?>>خیر</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">وضعیت تأهل</label>
                                    <select name="marital_status" class="form-select">
                                        <option value="">انتخاب کنید</option>
                                        <option value="single" <?= $marital_status === 'single' ? 'selected' : '' ?>>مجرد</option>
                                        <option value="married" <?= $marital_status === 'married' ? 'selected' : '' ?>>متأهل</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">ذخیره</button>
                                <a href="patients.php" class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Updated Medical Histories Modal -->
            <div class="modal fade" id="medicalHistoriesModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">انتخاب سوابق پزشکی</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <input type="text" id="medicalHistorySearch" class="form-control mb-3" placeholder="جستجو...">
                            <div id="medicalHistoriesList">
                                <?php if (!empty($medical_histories)): ?>
                                    <?php foreach ($medical_histories as $mh): ?>
                                        <div class="form-check mb-2">
                                            <input
                                                class="form-check-input mh-checkbox"
                                                type="checkbox"
                                                name="medical_histories[]"
                                                value="<?= htmlspecialchars($mh['history_code']) ?>"
                                                id="mh<?= htmlspecialchars($mh['history_code']) ?>"
                                                <?php
                                                if(in_array($mh['history_code'],$patient_medical_histories_array)){
                                                    echo 'checked';
                                                }
                                                ?>
                                            >
                                            <label class="form-check-label" for="mh<?= htmlspecialchars($mh['id']) ?>">
                                                <?= htmlspecialchars($mh['title']) ?>
                                                <span class="badge bg-label-info"><?= htmlspecialchars($mh['history_type']) ?></span>
                                                <?php if ($mh['alert_flag']): ?>
                                                    <span class="badge bg-label-danger">هشدار</span>
                                                <?php endif; ?>
                                            </label>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p class="text-muted">هیچ سابقه پزشکی فعال یافت نشد</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" data-bs-dismiss="modal">تایید</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Live filtering for digit-only inputs and length rules
    $(document).on('input', 'input[name="nationalid"]', function () {
        this.value = this.value.replace(/\D/g, '').slice(0, 10); // only digits, max 10
    });
    $(document).on('input', 'input[name="phonenumber"]', function () {
        this.value = this.value.replace(/\D/g, '').slice(0, 11); // only digits, max 11
    });
    $(document).on('input', 'input[name="home_number"]', function () {
        this.value = this.value.replace(/\D/g, ''); // only digits, unlimited length
    });

    $('#medicalHistorySearch').on('input', function(){
        const search = $(this).val().toLowerCase();
        $('#medicalHistoriesList .form-check').each(function(){
            const text = $(this).text().toLowerCase();
            $(this).toggle(text.indexOf(search) > -1);
        });
    });

    $(document).on('submit', '#editPatientForm', function(e) {
        const anyChecked = $('.mh-checkbox:checked').length > 0;
        const noHistoryChecked = $('#noMedicalHistory').is(':checked');

        // Final pattern checks before submitting
        const nationalid = $('input[name="nationalid"]').val();
        const phone = $('input[name="phonenumber"]').val();
        if (!/^\d{10}$/.test(nationalid)) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'خطا',
                text: 'کد ملی باید دقیقا ۱۰ رقم باشد.',
                showCancelButton: false,
                confirmButtonText: 'باشه',
                customClass: { confirmButton: 'btn btn-danger me-3 waves-effect waves-light' },
                buttonsStyling: false
            });
            return;
        }
        if (!/^09\d{9}$/.test(phone)) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'خطا',
                text: 'شماره موبایل باید با 09 شروع شده و ۱۱ رقم باشد.',
                showCancelButton: false,
                confirmButtonText: 'باشه',
                customClass: { confirmButton: 'btn btn-danger me-3 waves-effect waves-light' },
                buttonsStyling: false
            });
            return;
        }

        if (!anyChecked && !noHistoryChecked) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'خطا',
                text: 'لطفا حداقل یک سابقه پزشکی را انتخاب کنید یا گزینه "بیمار سابقه پزشکی ندارد" را علامت بزنید.',
                showCancelButton: false,
                confirmButtonText: 'باشه',
                customClass: { confirmButton: 'btn btn-danger me-3 waves-effect waves-light' },
                buttonsStyling: false
            });
        }
        else {
            e.preventDefault();
            const fd = new FormData(this);
            const medical_histories = [];
            $('.mh-checkbox:checked').each(function(){
                medical_histories.push($(this).val());
            });
            fd.append('medical_histories', JSON.stringify(medical_histories));
            $.ajax({
                url: 'functions/edit_patients_funcs.php',
                type: 'POST',
                data: fd,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function(res){
                    Swal.fire({
                        icon: res.success ? 'success' : 'error',
                        title: res.success ? 'موفق!' : 'خطا',
                        text: res.success ? res.message : res.error,
                        showCancelButton: false,
                        confirmButtonText: 'باشه',
                        customClass: {
                            confirmButton: 'btn btn-primary me-3 waves-effect waves-light'
                        },
                        buttonsStyling: false
                    });
                }
            });
        }
    });
</script>

<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>
<script>
    function refreshSelectedHistories() {
        const container = $('#selectedHistoriesContainer');
        container.empty();
        $('.mh-checkbox:checked').each(function(){
            const id = $(this).val();
            const label = $(this).closest('.form-check').find('label').clone().children().remove().end().text().trim();
            const $badge = $(`
            <span class="badge bg-primary selected-history-badge me-1 mb-1" data-id="${id}">
                ${label}
                <button type="button" class="btn-close btn-close-white ms-1 remove-history-btn" aria-label="Remove"></button>
            </span>
        `);
            container.append($badge);
        });
        const anyChecked = $('.mh-checkbox:checked').length > 0;

        if (anyChecked) {
            // اگه حداقل یکی از سوابق تیک خورده، "بدون سابقه" رو از تیک دربیار و غیرفعال کن
            $('#noMedicalHistory')
                .prop('checked', false)
                .prop('disabled', true);
        } else {
            // اگه هیچ سابقه‌ای انتخاب نشده، "بدون سابقه" رو از تیک دربیار ولی فعال کن
            $('#noMedicalHistory')
                .prop('checked', false)
                .prop('disabled', false);
        }
    }

    // On modal close, refresh chips
    $('#medicalHistoriesModal').on('hidden.bs.modal', refreshSelectedHistories);

    // Remove chip and uncheck corresponding box
    $(document).on('click', '.remove-history-btn', function(){
        const badge = $(this).closest('.selected-history-badge');
        const id = badge.data('id');
        $(`#mh${id}`).prop('checked', false);
        badge.remove()
        refreshSelectedHistories();
    });
</script>
</body>
</html>
