<?php
header('Content-Type: application/json; charset=utf-8');
require_once "config.php";

try {
    session_start();

    $officeCode = $_SESSION['user_code'] ?? null;
    if (!$officeCode) {
        throw new Exception("No office code found in session.");
    }

    $action = $_POST['action'] ?? null;
    if (!$action) {
        throw new Exception("No action provided.");
    }

    switch ($action) {
        case 'get_lab_services':
            getLabServices($pdo_lab, $officeCode);
            break;

        default:
            throw new Exception("Invalid action: " . htmlspecialchars($action));
    }

} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'error'   => $e->getMessage()
    ]);
}

function getLabServices($pdo_lab,$officeCode){
    $lab_code   = trim($_POST['add-order-lab-code'] ?? '');
    $stmt = $pdo_lab->prepare("
        SELECT *
        FROM services
        WHERE status = 'ACTIVE'
          AND lab_code = :lab_code
    ");
    $stmt->execute([':lab_code' => $lab_code]);

    $services = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $services[] = [
            'service_code' => $row['service_code'],
            'service_title' => $row['service_title'],
            'service_category_code' => $row['service_category_code']
        ];
    }

    $stmt = $pdo_lab->prepare("
        SELECT *
        FROM service_categories
        WHERE status = 'ACTIVE'
          AND lab_code = :lab_code
    ");
    $stmt->execute([':lab_code' => $lab_code]);

    $categories = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $categories[] = [
            'category_title' => $row['category_title'],
            'service_category_code' => $row['service_category_code']
        ];
    }

    $stmt = $pdo_lab->prepare("
        SELECT *
        FROM services_custom_fields
        WHERE status = 'ACTIVE'
          AND lab_code = :lab_code
    ");
    $stmt->execute([':lab_code' => $lab_code]);

    $custom_fields = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $custom_fields[] = [
            'cf_code' => $row['cf_code'],
            'cf_title' => $row['cf_title'],
            'cf_type' => $row['cf_type'],
            'cf_options' => $row['cf_options'],
            'cf_required' => $row['cf_required'],
            'cf_service_code' => $row['service_code']
        ];
    }

    echo json_encode(['success'=>true,'services' => $services,'categories' => $categories,'custom_fields'=>$custom_fields]);
}