<?php
header('Content-Type: application/json; charset=utf-8');
require_once "config.php"; // شامل اتصال PDO و crypto funcs

try {
    session_start();

    $officeCode = $_SESSION['user_code'] ?? null;
    if (!$officeCode) {
        throw new Exception("کد دفتر در سشن پیدا نشد.");
    }

    $action = $_POST['action'] ?? null;
    if (!$action) {
        throw new Exception("هیچ اکشنی ارسال نشده است.");
    }

    switch ($action) {
        case 'get_patient':
            getPatient($pdo, $officeCode);
            break;

        case 'update_patient':
            updatePatient($pdo, $officeCode);
            break;

        default:
            throw new Exception("اکشن نامعتبر: " . htmlspecialchars($action));
    }

} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'error'   => $e->getMessage()
    ]);
}

// === FUNCTIONS ===

function getPatient($pdo, $officeCode) {
    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'کد بیمار ارسال نشده است']);
        exit;
    }
    $code = trim($_POST['code']);

    $stmt = $pdo->prepare("
        SELECT *
        FROM patients
        WHERE patient_code = :code
          AND office_code = :office_code
          AND status != 'DELETED'
          LIMIT 1
    ");
    $stmt->execute([
        ':code'        => $code,
        ':office_code' => $officeCode
    ]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$row) {
        echo json_encode(['success' => false, 'error' => 'بیمار یافت نشد']);
        return;
    }
    $patient_encrypted = [
        'patient_firstname_encrypted'       => decryptData($row['patient_firstname_encrypted']),
        'patient_lastname_encrypted'        => decryptData($row['patient_lastname_encrypted']),
        'patient_nationalid_encrypted'      => decryptData($row['patient_nationalid_encrypted']),
        'patient_phone_encrypted'           => decryptData($row['patient_phone_encrypted']),
        'gender_encrypted'                  => decryptData($row['gender_encrypted']),
        'firstname_en_encrypted'            => decryptData($row['firstname_en_encrypted']),
        'lastname_en_encrypted'             => decryptData($row['lastname_en_encrypted']),
        'home_number_encrypted'             => decryptData($row['home_number_encrypted']),
        'father_name_encrypted'             => decryptData($row['father_name_encrypted']),
        'emergency_contact_encrypted'       => decryptData($row['emergency_contact_encrypted']),
        'emergency_contact_name_encrypted'  => decryptData($row['emergency_contact_name_encrypted']),
        'emergency_contact_relation_encrypted' => decryptData($row['emergency_contact_relation_encrypted']),
        'education_encrypted'               => decryptData($row['education_encrypted']),
        'occupation_encrypted'              => decryptData($row['occupation_encrypted']),
        'birthdate_encrypted'               => decryptData($row['birthdate_encrypted']),
        'address_encrypted'                 => decryptData($row['address_encrypted']),
        'bloodtype_encrypted'               => decryptData($row['bloodtype_encrypted']),
        'pregnancy_encrypted'               => decryptData($row['pregnancy_encrypted']),
        'marital_status_encrypted'          => decryptData($row['marital_status_encrypted']),
        'medical_histories_encrypted'       => json_decode(decryptData($row['medical_histories_encrypted']) ?? '[]', true)
    ];
    $iv = $row['iv'];
    $salt = $row['salt'];
    $enc_code = $row['enc_code'];
    $tmp_patient = get_decrypted_data($patient_encrypted,$iv,$salt,$enc_code);
    echo json_encode([
        'success' => true,
        'patient' => [
            'firstname'        => $tmp_patient['patient_firstname_encrypted'],
            'lastname'         => $tmp_patient['patient_lastname_encrypted'],
            'nationalid'       => $tmp_patient['patient_nationalid_encrypted'],
            'phonenumber'      => $tmp_patient['patient_phone_encrypted'],
            'firstname_en'     => $tmp_patient['firstname_en_encrypted'],
            'lastname_en'      => $tmp_patient['lastname_en_encrypted'],
            'home_number'      => $tmp_patient['home_number_encrypted'],
            'father_name'      => $tmp_patient['father_name_encrypted'],
            'emergency_contact'=> $tmp_patient['emergency_contact_encrypted'],
            'emergency_contact_name' => $tmp_patient['emergency_contact_name_encrypted'],
            'emergency_contact_relation' => $tmp_patient['emergency_contact_relation_encrypted'],
            'education'        => $tmp_patient['education_encrypted'],
            'occupation'       => $tmp_patient['occupation_encrypted'],
            'birthdate'        => $tmp_patient['birthdate_encrypted'],
            'address'          => $tmp_patient['address_encrypted'],
            'bloodtype'        => $tmp_patient['bloodtype_encrypted'],
            'pregnancy'        => $tmp_patient['pregnancy_encrypted'],
            'marital_status'   => $tmp_patient['marital_status_encrypted'],
            'medical_histories'=> json_decode($tmp_patient['medical_histories_encrypted'] ?? '[]', true)
        ]
    ]);
}

function updatePatient($pdo, $officeCode) {
    if (empty($_POST['code'])) {
        echo json_encode(['success' => false, 'error' => 'کد بیمار ارسال نشده است']);
        exit;
    }
    $patientCode = trim($_POST['code']);

    // Helper closures
    $enc = fn($v) => ($v !== '' && $v !== null) ? encryptData(trim($v)) : null;
    $hash = fn($v) => ($v !== '' && $v !== null) ? hashData(trim($v)) : null;

    $firstname = $_POST['firstname'] ?? '';
    $lastname  = $_POST['lastname'] ?? '';
    $fullname  = trim($firstname . ' ' . $lastname);

    $mh = $_POST['medical_histories'] ?? [];
    if (isset($_POST['no_medical_history']) && $_POST['no_medical_history'] === 'on') {
        $mh = ["NOMEDICALHISTORY"];
    }
    $mh_json = json_encode($mh, JSON_UNESCAPED_UNICODE);

    $payload['firstname']                = $_POST['firstname'] ?? '';
    $payload['lastname']                = $_POST['lastname'] ?? '';
    $payload['fullname']                = $_POST['firstname'] . ' ' . $_POST['lastname'] ?? '';
    $payload['nationalid']                = $_POST['nationalid'] ?? '';
    $payload['phonenumber']               = $_POST['phonenumber'] ?? '';
    $payload['firstname_en']              = $_POST['firstname_en'] ?? '';
    $payload['lastname_en']               = $_POST['lastname_en'] ?? '';
    $payload['home_number']               = $_POST['home_number'] ?? '';
    $payload['father_name']               = $_POST['father_name'] ?? '';
    $payload['emergency_contact']         = $_POST['emergency_contact'] ?? '';
    $payload['emergency_contact_name']    = $_POST['emergency_contact_name'] ?? '';
    $payload['emergency_contact_relation']= $_POST['emergency_contact_relation'] ?? '';
    $payload['education']                 = $_POST['education'] ?? '';
    $payload['occupation']                = $_POST['occupation'] ?? '';
    $payload['birthdate']                 = $_POST['birthdate'] ?? '';
    $payload['address']                   = $_POST['address'] ?? '';
    $payload['bloodtype']                 = $_POST['bloodtype'] ?? '';
    $payload['pregnancy']                 = $_POST['pregnancy'] ?? '';
    $payload['marital_status']            = $_POST['marital_status'] ?? '';
    $payload['medical_histories']         = $mh_json;
    $payload['gender']                    = $_POST['gender'] ?? '';

    $enc1 = get_encrypted_data(json_encode($payload));
    $enc_data = $enc1['encrypted_data'];
    $iv = $enc1['iv'];
    $salt = $enc1['salt'];
    $enc_code = $enc1['code'];

    $stmt = $pdo->prepare("
        UPDATE patients SET
            patient_firstname_encrypted = :fn,   patient_firstname_hash = :fn_h,
            patient_lastname_encrypted  = :ln,   patient_lastname_hash  = :ln_h,
            patient_fullname_encrypted  = :full, patient_fullname_hash  = :full_h,
            patient_nationalid_encrypted= :nid,  patient_nationalid_hash= :nid_h,
            patient_phone_encrypted     = :phone,patient_phone_hash     = :phone_h,
            firstname_en_encrypted      = :fn_en,firstname_en_hash      = :fn_en_h,
            lastname_en_encrypted       = :ln_en,lastname_en_hash       = :ln_en_h,
            home_number_encrypted       = :home, home_number_hash       = :home_h,
            father_name_encrypted       = :father,father_name_hash      = :father_h,
            emergency_contact_encrypted = :ec,   emergency_contact_hash = :ec_h,
            emergency_contact_name_encrypted = :ecn, emergency_contact_name_hash = :ecn_h,
            emergency_contact_relation_encrypted = :ecr, emergency_contact_relation_hash = :ecr_h,
            education_encrypted         = :edu,  education_hash         = :edu_h,
            occupation_encrypted        = :occ,  occupation_hash        = :occ_h,
            birthdate_encrypted         = :birth,birthdate_hash         = :birth_h,
            address_encrypted           = :addr, address_hash           = :addr_h,
            bloodtype_encrypted         = :blood,bloodtype_hash         = :blood_h,
            pregnancy_encrypted         = :preg, pregnancy_hash         = :preg_h,
            marital_status_encrypted    = :mar,  marital_status_hash    = :mar_h,
            medical_histories_encrypted = :mh,   medical_histories_hash = :mh_h,
            gender_encrypted = :gender,   gender_hash = :gender_h,iv = :iv,salt = :salt,enc_code = :enc_code,
            updated_at = NOW()
        WHERE patient_code = :code
          AND office_code  = :office_code
          AND status != 'DELETED'
    ");

    $stmt->execute([
        ':fn' => $enc($enc_data['firstname']), ':fn_h' => $hash($firstname),
        ':ln' => $enc($enc_data['lastname']),  ':ln_h' => $hash($lastname),
        ':full' => $enc($enc_data['fullname']),':full_h' => $hash($fullname),
        ':nid' => $enc($enc_data['nationalid'] ?? ''), ':nid_h' => $hash($_POST['nationalid'] ?? ''),
        ':phone' => $enc($enc_data['phonenumber'] ?? ''), ':phone_h' => $hash($_POST['phonenumber'] ?? ''),
        ':fn_en' => $enc($enc_data['firstname_en'] ?? ''), ':fn_en_h' => $hash($_POST['firstname_en'] ?? ''),
        ':ln_en' => $enc($enc_data['lastname_en'] ?? ''), ':ln_en_h' => $hash($_POST['lastname_en'] ?? ''),
        ':home' => $enc($enc_data['home_number'] ?? ''), ':home_h' => $hash($_POST['home_number'] ?? ''),
        ':father' => $enc($enc_data['father_name'] ?? ''), ':father_h' => $hash($_POST['father_name'] ?? ''),
        ':ec' => $enc($enc_data['emergency_contact'] ?? ''), ':ec_h' => $hash($_POST['emergency_contact'] ?? ''),
        ':ecn' => $enc($enc_data['emergency_contact_name'] ?? ''), ':ecn_h' => $hash($_POST['emergency_contact_name'] ?? ''),
        ':ecr' => $enc($enc_data['emergency_contact_relation'] ?? ''), ':ecr_h' => $hash($_POST['emergency_contact_relation'] ?? ''),
        ':edu' => $enc($enc_data['education'] ?? ''), ':edu_h' => $hash($_POST['education'] ?? ''),
        ':occ' => $enc($enc_data['occupation'] ?? ''), ':occ_h' => $hash($_POST['occupation'] ?? ''),
        ':birth' => $enc($enc_data['birthdate'] ?? ''), ':birth_h' => $hash($_POST['birthdate'] ?? ''),
        ':addr' => $enc($enc_data['address'] ?? ''), ':addr_h' => $hash($_POST['address'] ?? ''),
        ':blood' => $enc($enc_data['bloodtype'] ?? ''), ':blood_h' => $hash($_POST['bloodtype'] ?? ''),
        ':preg' => $enc($enc_data['pregnancy'] ?? ''), ':preg_h' => $hash($_POST['pregnancy'] ?? ''),
        ':mar' => $enc($enc_data['marital_status'] ?? ''), ':mar_h' => $hash($_POST['marital_status'] ?? ''),
        ':mh' => $enc($enc_data['medical_histories']), ':mh_h' => $hash($mh_json),
        ':gender' => $enc($enc_data['gender']), ':gender_h' => $hash($_POST['gender']),
        ':iv' => $iv, ':salt' => $salt, ':enc_code' => $enc_code,
        ':code' => $patientCode, ':office_code' => $officeCode
    ]);

    if ($stmt->rowCount()) {
        echo json_encode(['success' => true, 'message' => 'اطلاعات بیمار با موفقیت بروزرسانی شد.']);
    } else {
        echo json_encode(['success' => false, 'error' => 'بیمار یافت نشد یا تغییری اعمال نشد.']);
    }
}
