<?php
// فقط از example.com اجازه بده
header('Access-Control-Allow-Origin: https://panel.dentopin.com');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Credentials: true'); // برای ارسال Cookie/Session
require_once 'config.php';
// بررسی Rate Limit
$maxAttempts = 10;
$timeWindow = 300; // 5 دقیقه

if (!isset($_SESSION['salt_requests'])) {
    $_SESSION['salt_requests'] = [];
}

// پاک کردن درخواست‌های قدیمی
$_SESSION['salt_requests'] = array_filter(
    $_SESSION['salt_requests'],
    function($time) use ($timeWindow) {
        return (time() - $time) < $timeWindow;
    }
);

// بررسی تعداد درخواست‌ها
if (count($_SESSION['salt_requests']) >= $maxAttempts) {
    echo json_encode([
        'success' => false,
        'message' => 'تعداد درخواست‌ها زیاد است. لطفاً 5 دقیقه صبر کنید.'
    ]);
    exit;
}

// ثبت درخواست جدید
$_SESSION['salt_requests'][] = time();

// ادامه کد معمولی...
$data = json_decode(file_get_contents('php://input'), true);
$username = $data['username'] ?? '';

if (empty($username)) {
    echo json_encode([
        'success' => false,
        'message' => 'نام کاربری الزامی است'
    ]);
    exit;
}

try {
    $stmt = $pdo->prepare('SELECT user_salt FROM users WHERE user_username = ?');
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        $saltArray = array_values(unpack('C*', $user['user_salt']));

        echo json_encode([
            'success' => true,
            'salt' => $saltArray
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'کاربر یافت نشد'
        ]);
    }

} catch (PDOException $e) {
    error_log('Error: ' . $e->getMessage());

    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>