<?php
// login_funcs.php

require_once "config.php"; // اتصال PDO + توابع رمزنگاری
require_once "jdf.php"; // اتصال PDO + توابع رمزنگاری
header('Content-Type: application/json; charset=utf-8');

// شروع سشن
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Auto-login from cookie if no active session
if (empty($_SESSION['user_code']) && !empty($_COOKIE['remember_token'])) {
    $cookie_token = $_COOKIE['remember_token'];
    $token_hash = hash('sha256', $cookie_token);

    $stmt = $pdo->prepare("SELECT user_code, expires_at FROM remember_tokens WHERE token_hash = ?");
    $stmt->execute([$token_hash]);
    $token_data = $stmt->fetch(PDO::FETCH_ASSOC);

    // If token is valid and not expired
    if ($token_data && strtotime($token_data['expires_at']) > time()) {
        $_SESSION['user_code'] = $token_data['user_code'];

        // Rotate token to prevent reuse
        $new_token = bin2hex(random_bytes(32));
        $new_hash = hash('sha256', $new_token);
        $new_expiration = date('Y-m-d H:i:s', time() + (30 * 24 * 60 * 60));

        // Remove old token and store new one
        $pdo->prepare("DELETE FROM remember_tokens WHERE token_hash = ?")->execute([$token_hash]);
        $pdo->prepare("INSERT INTO remember_tokens (user_code, token_hash, expires_at) VALUES (?, ?, ?)")
            ->execute([$token_data['user_code'], $new_hash, $new_expiration]);

        // Reset cookie
        setcookie(
            'remember_token',
            $new_token,
            [
                'expires' => time() + (30 * 24 * 60 * 60),
                'path' => '/',
                'secure' => isset($_SERVER['HTTPS']),
                'httponly' => true,
                'samesite' => 'Strict'
            ]
        );
    }
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success" => false, "error" => "درخواست نامعتبر است"]);
    exit;
}

$action = $_POST['action'] ?? '';
switch ($action) {

    /**
     * ارسال OTP برای لاگین
     */
    case 'send_otp':
        $phone = trim($_POST['phonenumber'] ?? '');
        if (!preg_match('/^09\d{9}$/', $phone)) {
            echo json_encode(["success" => false, "error" => "شماره موبایل نامعتبر است"]);
            exit;
        }
        $_SESSION['pending_phone'] = $phone;
        try {
            $phone_enc = encryptData($phone);
            $phone_hash = hashData($_SESSION['pending_phone']);

            // جستجوی کاربر
            $stmt = $pdo->prepare("SELECT user_code FROM users WHERE phone_hash = ?");
            $stmt->execute([$phone_hash]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$user) {
                echo json_encode(["success" => false, "error" => $phone_hash]);
                exit;
            } else {
                $user_code = $user['user_code'];
            }

            // تولید OTP
            $otp_code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
            $otp_enc = encryptData($otp_code);
            $expires_at = date('Y-m-d H:i:s', time() + 300);

            // درج OTP
            $stmt = $pdo->prepare("INSERT INTO otp (phone_hash,phone_encrypted, otp_code_encrypted, purpose, expires_at) 
                                   VALUES (?,?, ?, 'login', ?)");
            $stmt->execute([$phone_hash,$phone_enc, $otp_enc, $expires_at]);

            // ذخیره شماره تلفن در سشن برای استفاده در otp.php
            $_SESSION['pending_phone'] = $phone;
            send_sms_5625($pdo,$pdo_lab,376083,['otp'=>$otp_code],$phone,"DENTOPIN_OFFICE");
            // ارسال SMS (فعلاً فقط در لاگ)
            error_log("OTP for $phone: $otp_code");
            $otp_text = "OTP for $phone: $otp_code";
            file_put_contents(__DIR__ . '/otp.txt', $otp_text);
            echo json_encode(["success" => true]);

        } catch (Exception $e) {
            echo json_encode(["success" => false, "error" => $e->getMessage()]);
        }
        break;

    /**
     * سایر اکشن‌های آینده
     */
    case 'verify_otp':
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }

        if (empty($_SESSION['pending_phone'])) {
            echo json_encode(["success" => false, "error" => "نشست نامعتبر است. لطفا دوباره وارد شوید."]);
            exit;
        }

        $otp_input = trim($_POST['otp'] ?? '');
        if (!preg_match('/^\d{6}$/', $otp_input)) {
            echo json_encode(["success" => false, "error" => "کد تایید نامعتبر است."]);
            exit;
        }

        try {
            $phone = $_SESSION['pending_phone'];
            $phone_enc = encryptData($_SESSION['pending_phone']);
            $phone_hash = hashData($_SESSION['pending_phone']);
            $stmt = $pdo->prepare("SELECT otp_code_encrypted, expires_at 
                               FROM otp 
                               WHERE phone_hash = ? AND purpose = 'login' 
                               ORDER BY id DESC LIMIT 1");
            $stmt->execute([$phone_hash]);
            $otp_data = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$otp_data) {
                echo json_encode(["success" => false, "error" => '']);
                exit;
            }

            if (strtotime($otp_data['expires_at']) < time()) {
                echo json_encode(["success" => false, "error" => "کد منقضی شده است."]);
                exit;
            }

            if (decryptData($otp_data['otp_code_encrypted']) !== $otp_input) {
                echo json_encode(["success" => false, "error" => decryptData($otp_data['otp_code_encrypted'])]);
                exit;
            }
            $date = jdate('Y-m-d', time(), '', 'Asia/Tehran');
            $time = jdate('H:i:s', time(), '', 'Asia/Tehran');

            send_sms_5625($pdo,$pdo_lab,384492,['date'=>$date,'hour'=>$time],$phone,"DENTOPIN_OFFICE");
// ایجاد سشن ورود
            $stmt = $pdo->prepare("SELECT user_code FROM users WHERE phone_hash = ?");
            $stmt->execute([$phone_hash]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            $_SESSION['user_code'] = $user['user_code'];
            unset($_SESSION['pending_phone']);

// Always create remember-me cookie (mandatory)
            $token = bin2hex(random_bytes(32)); // raw token for cookie
            $token_hash = hash('sha256', $token);
            $expires_at = date('Y-m-d H:i:s', time() + (30 * 24 * 60 * 60)); // 30 days

// Remove any old remember tokens for this user to avoid multiple valid tokens
            $pdo->prepare("DELETE FROM remember_tokens WHERE user_code = ?")->execute([$user['user_code']]);

            $pdo->prepare("DELETE FROM otp WHERE phone_hash = ?")->execute([$phone_hash]);

// Store new token
            $pdo->prepare("INSERT INTO remember_tokens (user_code, token_hash, expires_at) VALUES (?, ?, ?)")
                ->execute([$user['user_code'], $token_hash, $expires_at]);

// Set secure cookie
            setcookie(
                'remember_token',
                $token,
                [
                    'expires' => time() + (30 * 24 * 60 * 60),
                    'path' => '/',
                    'secure' => isset($_SERVER['HTTPS']),
                    'httponly' => true,
                    'samesite' => 'Strict'
                ]
            );

            echo json_encode(["success" => true]);

        } catch (Exception $e) {
            echo json_encode(["success" => false, "error" => $e->getMessage()]);
        }
        break;


    default:
        echo json_encode(["success" => false, "error" => "اکشن ناشناخته است"]);
}
