<?php
header('Content-Type: application/json; charset=utf-8');
require_once "config.php";

try {
    session_start();
    $officeCode = $_SESSION['user_code'] ?? null;
    if (!$officeCode) {
        throw new Exception("No office code found in session.");
    }

    $action = $_POST['action'] ?? null;
    if (!$action) {
        throw new Exception("No action provided.");
    }

    switch ($action) {
        case 'add_record':
            addRecord($pdo, $officeCode);
            break;

        default:
            throw new Exception("Invalid action: " . htmlspecialchars($action));
    }

} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'error'   => $e->getMessage()
    ]);
}

// ===== FUNCTIONS =====

function addRecord($pdo, $officeCode) {
    $name  = trim($_POST['name'] ?? '');
    $type  = trim($_POST['type'] ?? '');
    $link  = trim($_POST['link'] ?? '');
    $notes  = trim($_POST['notes'] ?? '');
    $pcode  = trim($_POST['pcode'] ?? '');
    $files  = trim($_POST['files'] ?? '[]');
    $count = count(json_decode($files));
    $record_code = uniqid("REC-") . '-' . substr(base64_encode(hash('sha256', $officeCode)), 0, 20) . '-' . substr(base64_encode(hash('sha256', $pcode)), 0, 20);

    $stmt = $pdo->prepare("
        INSERT INTO records (record_code,record_name,record_note,patient_code,office_code,type,link,files,count) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $stmt->execute([$record_code,$name,$notes,$pcode,$officeCode,$type,$link,$files,$count]);

    echo json_encode(['success' => true, 'message' => 'رکورد با موفقیت افزوده شد.']);
}