<?php
require_once 'config.php';
$histories = [
    [ "code" => "MH-diabetes1", "title" => "دیابت نوع ۱", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-diabetes2", "title" => "دیابت نوع ۲", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-hypertension", "title" => "فشار خون بالا", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-heartdisease", "title" => "بیماری قلبی", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-endocarditis", "title" => "سابقه اندوکاردیت عفونی", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-asthma", "title" => "آسم", "desc" => null, "type" => "بیماری", "alert" => 0 ],
    [ "code" => "MH-chf", "title" => "نارسایی قلبی", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-copd", "title" => "بیماری انسدادی مزمن ریه (COPD)", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-bleeding", "title" => "اختلالات انعقادی", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-osteoporosis", "title" => "پوکی استخوان", "desc" => null, "type" => "بیماری", "alert" => 0 ],
    [ "code" => "MH-hepB", "title" => "هپاتیت B", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-hepC", "title" => "هپاتیت C", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-HIV", "title" => "HIV مثبت", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-cancer", "title" => "سرطان فعال یا تحت درمان", "desc" => null, "type" => "بیماری", "alert" => 1 ],
    [ "code" => "MH-warfarin", "title" => "مصرف وارفارین", "desc" => null, "type" => "دارو", "alert" => 1 ],
    [ "code" => "MH-apixaban", "title" => "مصرف آپیکسابان", "desc" => null, "type" => "دارو", "alert" => 1 ],
    [ "code" => "MH-aspirin", "title" => "مصرف آسپرین", "desc" => null, "type" => "دارو", "alert" => 1 ],
    [ "code" => "MH-clopidogrel", "title" => "مصرف کلوپیدوگرل", "desc" => null, "type" => "دارو", "alert" => 1 ],
    [ "code" => "MH-isotretinoin", "title" => "مصرف ایزوترتینوئین", "desc" => null, "type" => "دارو", "alert" => 0 ],
    [ "code" => "MH-bisphosph", "title" => "مصرف بیس‌فسفونات‌ها", "desc" => null, "type" => "دارو", "alert" => 1 ],
    [ "code" => "MH-immunosupp", "title" => "مصرف داروهای سرکوب‌کننده ایمنی", "desc" => null, "type" => "دارو", "alert" => 1 ],
    [ "code" => "MH-steroids", "title" => "مصرف طولانی‌مدت کورتون‌ها", "desc" => null, "type" => "دارو", "alert" => 1 ],
    [ "code" => "MH-penicillin", "title" => "حساسیت به پنی‌سیلین", "desc" => null, "type" => "حساسیت", "alert" => 1 ],
    [ "code" => "MH-latex", "title" => "حساسیت به لاتکس", "desc" => null, "type" => "حساسیت", "alert" => 1 ],
    [ "code" => "MH-lidocaine", "title" => "حساسیت به لیدوکائین", "desc" => null, "type" => "حساسیت", "alert" => 1 ],
    [ "code" => "MH-chlorhex", "title" => "حساسیت به کلرهگزیدین", "desc" => null, "type" => "حساسیت", "alert" => 1 ],
    [ "code" => "MH-NSAID", "title" => "حساسیت به داروهای ضد التهاب غیراستروئیدی (NSAIDs)", "desc" => null, "type" => "حساسیت", "alert" => 1 ],
    [ "code" => "MH-heartvalve", "title" => "دریچه قلب مصنوعی", "desc" => null, "type" => "سابقه جراحی", "alert" => 1 ],
    [ "code" => "MH-orthoprosth", "title" => "تعویض مفصل", "desc" => null, "type" => "سابقه جراحی", "alert" => 1 ],
    [ "code" => "MH-pacemaker", "title" => "ضربان‌ساز قلبی", "desc" => null, "type" => "سابقه جراحی", "alert" => 1 ],
    [ "code" => "MH-maxfax", "title" => "جراحی فک و صورت", "desc" => null, "type" => "سابقه جراحی", "alert" => 0 ],
    [ "code" => "MH-dentalimplant", "title" => "ایمپلنت دندانی", "desc" => null, "type" => "سابقه جراحی", "alert" => 0 ],
    [ "code" => "MH-TMJ", "title" => "اختلال مفصل گیجگاهی-فکی (TMJ)", "desc" => null, "type" => "سایر", "alert" => 0 ],
    [ "code" => "MH-xerostomia", "title" => "خشکی دهان (زروستومیا)", "desc" => null, "type" => "سایر", "alert" => 0 ],
    [ "code" => "MH-bms", "title" => "سندروم سوزش دهان", "desc" => null, "type" => "سایر", "alert" => 0 ],
    [ "code" => "MH-dentalanxiety", "title" => "اضطراب دندانی شدید", "desc" => null, "type" => "سایر", "alert" => 0 ],
    [ "code" => "MH-bron", "title" => "سابقه آسیب استخوان فک ناشی از بیس‌فسفونات (BRONJ)", "desc" => null, "type" => "سایر", "alert" => 1 ]
];


$stmt = $pdo->prepare("
    INSERT INTO medical_histories (
        history_code, title_encrypted, title_hash,
        description_encrypted, description_hash,
        history_type, office_code, default_for_all,
        hide_default_for, status, alert_flag
    )
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

foreach ($histories as $h) {
    $stmt->execute([
        $h['code'],
        encryptData($h['title']), hashData($h['title']),
        $h['desc'] ? encryptData($h['desc']) : null,
        $h['desc'] ? hashData($h['desc']) : null,
        $h['type'], 'DEFAULT', 1, '[]', 'ACTIVE', $h['alert']
    ]);
}