<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../config.php';
session_start();

$officeCode = $_SESSION['user_code'] ?? null;
if (!$officeCode) {
    echo json_encode(['success' => false, 'error' => 'No office code']);
    exit;
}

$action = $_POST['action'] ?? '';
if ($action === 'get_patient') {
    getPatient($pdo, $officeCode);
} elseif ($action === 'update_patient') {
    updatePatient($pdo, $officeCode);
} elseif ($action === 'load_medical_histories') {
    loadMedicalHistories($pdo, $officeCode);
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid action']);
}

/**
 * لود اطلاعات کامل بیمار
 */
function getPatient($pdo, $officeCode) {
    $code = trim($_POST['code'] ?? '');
    if (!$code) {
        echo json_encode(['success' => false, 'error' => 'Patient code is required']);
        return;
    }

    $stmt = $pdo->prepare("
        SELECT *
        FROM patients
        WHERE patient_code = :code
          AND office_code = :office_code
          AND status != 'DELETED'
    ");
    $stmt->execute([':code' => $code, ':office_code' => $officeCode]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        echo json_encode([
            'success' => true,
            'patient' => [
                'firstname' => decryptData($row['patient_firstname_encrypted']),
                'lastname' => decryptData($row['patient_lastname_encrypted']),
                'phonenumber' => decryptData($row['patient_phone_encrypted']),
                'gender' => $row['gender'],
                'nationalid' => decryptData($row['patient_nationalid_encrypted']),
                'firstname_en' => $row['firstname_en'],
                'lastname_en' => $row['lastname_en'],
                'home_number' => $row['home_number'],
                'father_name' => $row['father_name'],
                'emergency_contact' => $row['emergency_contact'],
                'emergency_contact_name' => $row['emergency_contact_name'],
                'emergency_contact_relation' => $row['emergency_contact_relation'],
                'education' => $row['education'],
                'occupation' => $row['occupation'],
                'birthdate' => $row['birthdate'],
                'address' => $row['address'],
                'bloodtype' => $row['bloodtype'],
                'pregnancy' => $row['pregnancy'],
                'marital_status' => $row['marital_status'],
                'medical_histories' => json_decode($row['medical_histories'], true) ?? []
            ]
        ]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Patient not found']);
    }
}

/**
 * آپدیت اطلاعات بیمار
 */
function updatePatient($pdo, $officeCode) {
    $required = ['code','firstname','lastname','phonenumber','gender','nationalid'];
    foreach ($required as $field) {
        if (empty($_POST[$field])) {
            echo json_encode(['success' => false, 'error' => 'تمام فیلدهای الزامی را پر کنید']);
            return;
        }
    }

    $code = trim($_POST['code']);

    // سوابق پزشکی: اگر تیک "ندارد" خورده باشه، خالی ذخیره میشه
    if (!empty($_POST['no_medical_history'])) {
        $histories = [];
    } else {
        $histories = $_POST['medical_histories'] ?? [];
    }

    try {
        $stmt = $pdo->prepare("
            UPDATE patients
            SET
                patient_firstname_encrypted   = :firstname,
                patient_lastname_encrypted    = :lastname,
                patient_phone_encrypted       = :phone,
                gender                        = :gender,
                patient_nationalid_encrypted  = :nationalid,
                firstname_en                  = :firstname_en,
                lastname_en                   = :lastname_en,
                home_number                   = :home_number,
                father_name                   = :father_name,
                emergency_contact              = :emergency_contact,
                emergency_contact_name         = :emergency_contact_name,
                emergency_contact_relation     = :emergency_contact_relation,
                education                      = :education,
                occupation                     = :occupation,
                birthdate                      = :birthdate,
                address                        = :address,
                bloodtype                      = :bloodtype,
                pregnancy                      = :pregnancy,
                marital_status                 = :marital_status,
                medical_histories              = :medical_histories
            WHERE patient_code = :code
              AND office_code  = :office_code
              AND status != 'DELETED'
        ");
        $updated = $stmt->execute([
            ':firstname'        => encryptData($_POST['firstname']),
            ':lastname'         => encryptData($_POST['lastname']),
            ':phone'            => encryptData($_POST['phonenumber']),
            ':gender'           => $_POST['gender'],
            ':nationalid'       => encryptData($_POST['nationalid']),
            ':firstname_en'     => $_POST['firstname_en'] ?? '',
            ':lastname_en'      => $_POST['lastname_en'] ?? '',
            ':home_number'      => $_POST['home_number'] ?? '',
            ':father_name'      => $_POST['father_name'] ?? '',
            ':emergency_contact' => $_POST['emergency_contact'] ?? '',
            ':emergency_contact_name' => $_POST['emergency_contact_name'] ?? '',
            ':emergency_contact_relation' => $_POST['emergency_contact_relation'] ?? '',
            ':education'        => $_POST['education'] ?? '',
            ':occupation'       => $_POST['occupation'] ?? '',
            ':birthdate'        => $_POST['birthdate'] ?? '',
            ':address'          => $_POST['address'] ?? '',
            ':bloodtype'        => $_POST['bloodtype'] ?? '',
            ':pregnancy'        => $_POST['pregnancy'] ?? '',
            ':marital_status'   => $_POST['marital_status'] ?? '',
            ':medical_histories' => json_encode($histories, JSON_UNESCAPED_UNICODE),
            ':code'             => $code,
            ':office_code'      => $officeCode
        ]);

        if ($updated && $stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'اطلاعات بیمار با موفقیت بروزرسانی شد']);
        } else {
            echo json_encode(['success' => false, 'error' => 'تغییری ایجاد نشد یا بیمار یافت نشد']);
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'error' => 'خطا: '.$e->getMessage()]);
    }
}

/**
 * لود لیست سوابق پزشکی
 */
function loadMedicalHistories($pdo, $officeCode) {
    $stmt = $pdo->prepare("SELECT id, title FROM medical_histories WHERE office_code=:office_code ORDER BY title");
    $stmt->execute([':office_code' => $officeCode]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['success' => true, 'histories' => $rows]);
}
