<?php
require_once 'auth21.php';
if (!empty($_SESSION['user_code'])) {
    header("Location: home");
    exit;
}
$redirect = 'home';
if(isset($_GET['redirect'])){
    $redirect = urlencode($_GET['redirect']);
}
?>
<!DOCTYPE html>
<html class="light-style layout-wide customizer-hide" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer" data-theme="theme-default" dir="rtl" lang="fa">

<head>
    <meta charset="UTF-8"/>
    <meta content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" name="viewport"/>
    <title>صفحات - ورود | Vuexy - قالب مدیریت بوت استرپ</title>
    <meta content="" name="description"/>
    <!-- Favicon -->
    <link href="../../assets/img/favicon/favicon.ico" rel="icon" type="image/x-icon"/>
    <!-- Icons -->
    <link href="../../assets/vendor/fonts/fontawesome.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/tabler-icons.css" rel="stylesheet"/>
    <link href="../../assets/vendor/fonts/flag-icons.css" rel="stylesheet"/>
    <!-- Core CSS -->
    <link href="../../assets/vendor/css/rtl/core.css" rel="stylesheet"/>
    <link href="../../assets/vendor/css/rtl/theme-default.css" rel="stylesheet"/>
    <link href="../../assets/css/demo.css" rel="stylesheet"/>
    <!-- Vendors CSS -->
    <link href="../../assets/vendor/libs/node-waves/node-waves.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" rel="stylesheet"/>
    <link href="../../assets/vendor/libs/typeahead-js/typeahead.css" rel="stylesheet"/>
    <!-- Vendor -->
    <link href="../../assets/vendor/libs/@form-validation/form-validation.css" rel="stylesheet"/>
    <!-- Page CSS -->
    <!-- Page -->
    <link href="../../assets/vendor/css/pages/page-auth.css" rel="stylesheet"/>
    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>

    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../../assets/js/config.js"></script>
    <script src="../../assets/js/keymanager.js"></script>
    <!-- Better experience of RTL -->
    <link href="../../assets/css/rtl.css" rel="stylesheet"/>
</head>

<body>
<!-- Content -->
<div class="authentication-wrapper authentication-cover authentication-bg">
    <div class="authentication-inner row">
        <!-- /Left Text -->
        <div class="d-none d-lg-flex col-lg-7 p-0">
            <div class="auth-cover-bg auth-cover-bg-color d-flex justify-content-center align-items-center">
                <img alt="auth-login-cover" class="img-fluid my-5 auth-illustration" data-app-dark-img="illustrations/auth-login-illustration-dark.png" data-app-light-img="illustrations/auth-login-illustration-light.png" src="../../assets/img/illustrations/auth-login-illustration-light.png"/>
                <img alt="auth-login-cover" class="platform-bg" data-app-dark-img="illustrations/bg-shape-image-dark.png" data-app-light-img="illustrations/bg-shape-image-light.png" src="../../assets/img/illustrations/bg-shape-image-light.png"/>
            </div>
        </div>
        <!-- /Left Text -->
        <!-- Login -->
        <div class="d-flex col-12 col-lg-5 align-items-center p-sm-5 p-4">
            <div class="w-px-400 mx-auto">
                <!-- Logo -->
                <div class="app-brand mb-4">
                    <a class="app-brand-link gap-2" href="index.html">
                        <span class="app-brand-logo demo">
                            <svg fill="none" height="22" viewBox="0 0 32 22" width="32" xmlns="http://www.w3.org/2000/svg">
                                <path clip-rule="evenodd" d="M0.00172773 0V6.85398C0.00172773 6.85398 -0.133178 9.01207 1.98092 10.8388L13.6912 21.9964L19.7809 21.9181L18.8042 9.88248L16.4951 7.17289L9.23799 0H0.00172773Z" fill="#7367F0" fill-rule="evenodd"/>
                                <path clip-rule="evenodd" d="M7.69824 16.4364L12.5199 3.23696L16.5541 7.25596L7.69824 16.4364Z" fill="#161616" fill-rule="evenodd" opacity="0.06"/>
                                <path clip-rule="evenodd" d="M8.07751 15.9175L13.9419 4.63989L16.5849 7.28475L8.07751 15.9175Z" fill="#161616" fill-rule="evenodd" opacity="0.06"/>
                                <path clip-rule="evenodd" d="M7.77295 16.3566L23.6563 0H32V6.88383C32 6.88383 31.8262 9.17836 30.6591 10.4057L19.7824 22H13.6938L7.77295 16.3566Z" fill="#7367F0" fill-rule="evenodd"/>
                            </svg>
                        </span>
                    </a>
                </div>
                <!-- /Logo -->
                <h3 class="mb-1">به دنتوپین خوش آمدید! 👋</h3>
                <p class="mb-4">لطفا به حساب کاربری خود وارد شوید تا از امکانات سامانه استفاده کنید.</p>
                <form class="mb-3" id="formAuthentication">
                    <div class="mb-3">
                        <label class="form-label" for="email">نام کاربری</label>
                        <input autofocus class="form-control" id="username" name="username" placeholder="ایمیل یا نام کاربری خود را وارد کنید" type="text"/>
                    </div>
                    <div class="mb-3 form-password-toggle">
                        <div class="d-flex justify-content-between">
                            <label class="form-label" for="password">رمز عبور</label>
                            <a href="auth-forgot-password-cover.html">
                                <small>رمز عبور را فراموش کرده اید؟</small>
                            </a>
                        </div>
                        <div class="input-group input-group-merge">
                            <input aria-describedby="password" class="form-control" id="password" name="password" placeholder="············" type="password"/>
                            <span class="input-group-text cursor-pointer">
                                <i class="ti ti-eye-off"></i>
                            </span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" id="remember-me" type="checkbox"/>
                            <label class="form-check-label" for="remember-me"> مرا به خاطر بسپار</label>
                        </div>
                    </div>
                    <div id="loading"></div>
                    <div id="error"></div>
                    <button type="button" onclick="login_func()" id="loginBtn" name="login-submit" class="btn btn-primary d-grid w-100">ورود</button>
                </form>
                <script>
                    async function login_func() {
                        const username = document.getElementById('username').value;
                        const password = document.getElementById('password').value;
                        const errorDiv = document.getElementById('error');
                        const loadingDiv = document.getElementById('loading');
                        const loginBtn = document.getElementById('loginBtn');

                        // پاک کردن خطای قبلی
                        errorDiv.textContent = '';
                        loginBtn.disabled = true;
                        loadingDiv.style.display = 'block';

                        try {
                            // 1. دریافت Salt
                            const saltResponse = await fetch('functions/get_salt.php', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/json' },
                                body: JSON.stringify({ username: username })
                            });

                            const saltData = await saltResponse.json();

                            if (!saltData.success) {
                                throw new Error('کاربری با این نام وجود ندارد');
                            }

                            const salt = new Uint8Array(saltData.salt);
                            // 2. ساخت هش احراز هویت
                            const authHash = await hashPassword(password, salt);
                            // 3. ارسال لاگین
                            const loginResponse = await fetch('functions/login_funcs.php', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/json' },
                                body: JSON.stringify({
                                    username: username,
                                    auth_hash: authHash
                                })
                            });

                            const loginData = await loginResponse.json();

                            if (!loginData.success) {
                                throw new Error(loginData.message || 'نام کاربری یا رمز عبور اشتباه است');
                            }

                            // 4. ساخت کلید رمزنگاری
                            const encryptionKey = await deriveKey(password, salt);

                            // 5. ذخیره کلید
                            await keyManager.saveKey(encryptionKey);

                            // 6. ذخیره اطلاعات
                            sessionStorage.setItem('userId', loginData.user_code);
                            sessionStorage.setItem('username', username);
                            // 7. هدایت به داشبورد
                            window.location.href = 'otp';

                        } catch (error) {
                            errorDiv.textContent = error.message;
                            loginBtn.disabled = false;
                            loadingDiv.style.display = 'none';
                            console.log(error);
                        }
                    }
                </script>
                <script src="https://conceptadent.com/assets/vendor/jquery/jquery.min.js"></script>
            </div>
        </div>
        <!-- /Login -->
    </div>
</div>
<!-- / Content -->
<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="../../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../../assets/vendor/libs/popper/popper.js"></script>
<script src="../../assets/vendor/js/bootstrap.js"></script>
<script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
<script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../../assets/vendor/libs/hammer/hammer.js"></script>
<script src="../../assets/vendor/libs/i18n/i18n.js"></script>
<script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
<script src="../../assets/vendor/js/menu.js"></script>
<!-- endbuild -->
<!-- Vendors JS -->
<script src="../../assets/vendor/libs/@form-validation/popular.js"></script>
<script src="../../assets/vendor/libs/@form-validation/bootstrap5.js"></script>
<script src="../../assets/vendor/libs/@form-validation/auto-focus.js"></script>
<!-- Main JS -->
<script src="../../assets/js/main.js"></script>
<!-- Page JS -->
<script src="../../assets/js/pages-auth.js"></script>
</body>

</html>
